/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.xmlparser;

import com.yahoo.search.LocalSearchResult;
import com.yahoo.search.LocalSearchResults;
import com.yahoo.xml.XmlParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XmlParserLocalSearchResults
implements LocalSearchResults {
    public static final Map TYPE_MAP = new HashMap();
    private Map root;
    private LocalSearchResult[] results;

    public XmlParserLocalSearchResults(Map map) {
        this.root = map;
        List list = XmlParser.getList(map, "/ResultSet/Result");
        if (list != null) {
            this.results = new LocalSearchResult[list.size()];
            for (int i = 0; i < this.results.length; ++i) {
                Map map2 = (Map)list.get(i);
                this.results[i] = new XmlParserLocalSearchResult(map2);
            }
        } else {
            this.results = new LocalSearchResult[0];
        }
    }

    public BigInteger getTotalResultsAvailable() {
        return XmlParser.getBigInteger(this.root, "/ResultSet/totalResultsAvailable");
    }

    public BigInteger getTotalResultsReturned() {
        return XmlParser.getBigInteger(this.root, "/ResultSet/totalResultsReturned");
    }

    public BigInteger getFirstResultPosition() {
        return XmlParser.getBigInteger(this.root, "/ResultSet/firstResultPosition");
    }

    public String getResultsMapUrl() {
        return XmlParser.getString(this.root, "/ResultSet/ResultSetMapUrl/value");
    }

    public LocalSearchResult[] listResults() {
        return this.results;
    }

    static {
        TYPE_MAP.put("/ResultSet/totalResultsAvailable", BigInteger.class);
        TYPE_MAP.put("/ResultSet/totalResultsReturned", BigInteger.class);
        TYPE_MAP.put("/ResultSet/firstResultPosition", BigInteger.class);
    }

    public static class XmlParserLocalSearchResult
    implements LocalSearchResult {
        private Map result;
        private BigInteger id;
        private LocalSearchResult.LocalSearchCategory[] categories = null;
        private LocalSearchResult.LocalSearchRating rating = null;

        public XmlParserLocalSearchResult(Map map) {
            Object object;
            this.result = map;
            List list = XmlParser.getList(map, "/ResultSet/Result");
            if (list != null) {
                object = list.iterator();
                while (object.hasNext()) {
                    Map map2 = (Map)object.next();
                    List list2 = XmlParser.getList(map2, "/Categories/Category");
                    this.categories = new LocalSearchResult.LocalSearchCategory[list2.size()];
                    for (int i = 0; i < this.categories.length; ++i) {
                        this.categories[i] = new LocalSearchResult.LocalSearchCategory(XmlParser.getString((Map)list2.get(i), "/value"), XmlParser.getBigInteger((Map)list2.get(i), "/id/value"));
                    }
                }
            } else {
                this.categories = new LocalSearchResult.LocalSearchCategory[0];
            }
            if ((object = (Map)XmlParser.get(map, "/Rating")) != null) {
                this.rating = new LocalSearchResult.LocalSearchRating(XmlParser.getBigDecimal((Map)object, "/AverageRating/value"), XmlParser.getBigInteger((Map)object, "/TotalRatings/value"), XmlParser.getBigInteger((Map)object, "/TotalReviews/value"), XmlParser.getBigInteger((Map)object, "/LastReviewDate/value"), XmlParser.getString((Map)object, "/LastReviewIntro/value"));
            }
        }

        public BigInteger getId() {
            return XmlParser.getBigInteger(this.result, "/id");
        }

        public String getTitle() {
            return XmlParser.getString(this.result, "/Title/value");
        }

        public String getAddress() {
            return XmlParser.getString(this.result, "/Address/value");
        }

        public String getCity() {
            return XmlParser.getString(this.result, "/City/value");
        }

        public String getState() {
            return XmlParser.getString(this.result, "/State/value");
        }

        public String getPhone() {
            return XmlParser.getString(this.result, "/Phone/value");
        }

        public BigDecimal getLatitude() {
            return XmlParser.getBigDecimal(this.result, "/Latitude/value");
        }

        public BigDecimal getLongitude() {
            return XmlParser.getBigDecimal(this.result, "/Longitude/value");
        }

        public LocalSearchResult.LocalSearchRating getRating() {
            return this.rating;
        }

        public String getDistance() {
            return XmlParser.getString(this.result, "/Distance/value");
        }

        public String getUrl() {
            return XmlParser.getString(this.result, "/Url/value");
        }

        public String getClickUrl() {
            return XmlParser.getString(this.result, "/ClickUrl/value");
        }

        public String getMapUrl() {
            return XmlParser.getString(this.result, "/MapUrl/value");
        }

        public String getBusinessUrl() {
            return XmlParser.getString(this.result, "/BusinessUrl/value");
        }

        public String getBusinessClickUrl() {
            return XmlParser.getString(this.result, "/BusinessClickUrl/value");
        }

        public LocalSearchResult.LocalSearchCategory[] listCategories() {
            return this.categories;
        }
    }
}

