/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.search.xmlparser;

import com.yahoo.search.ImageThumbnail;
import com.yahoo.search.VideoSearchResult;
import com.yahoo.search.VideoSearchResults;
import com.yahoo.search.xmlparser.XmlParserImageThumbnail;
import com.yahoo.xml.XmlParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;

public class XmlParserVideoSearchResults
implements VideoSearchResults {
    private Map root;
    private VideoSearchResult[] results;

    public XmlParserVideoSearchResults(Map map) {
        this.root = map;
        List list = XmlParser.getList(map, "/ResultSet/Result");
        if (list != null) {
            this.results = new VideoSearchResult[list.size()];
            for (int i = 0; i < this.results.length; ++i) {
                Map map2 = (Map)list.get(i);
                this.results[i] = new XmlParserVideoSearchResult(map2);
            }
        } else {
            this.results = new VideoSearchResult[0];
        }
    }

    public BigInteger getTotalResultsAvailable() {
        return XmlParser.getBigInteger(this.root, "/ResultSet/totalResultsAvailable");
    }

    public BigInteger getTotalResultsReturned() {
        return XmlParser.getBigInteger(this.root, "/ResultSet/totalResultsReturned");
    }

    public BigInteger getFirstResultPosition() {
        return XmlParser.getBigInteger(this.root, "/ResultSet/firstResultPosition");
    }

    public VideoSearchResult[] listResults() {
        return this.results;
    }

    private class XmlParserVideoSearchResult
    implements VideoSearchResult {
        private Map result;
        private ImageThumbnail thumbnail;

        public XmlParserVideoSearchResult(Map map) {
            this.result = map;
            Map map2 = (Map)map.get("Thumbnail");
            if (map2 != null) {
                this.thumbnail = new XmlParserImageThumbnail(map2);
            }
        }

        public String getTitle() {
            return XmlParser.getString(this.result, "/Title/value");
        }

        public String getSummary() {
            return XmlParser.getString(this.result, "/Summary/value");
        }

        public String getUrl() {
            return XmlParser.getString(this.result, "/Url/value");
        }

        public String getClickUrl() {
            return XmlParser.getString(this.result, "/ClickUrl/value");
        }

        public String getRefererUrl() {
            return XmlParser.getString(this.result, "/RefererUrl/value");
        }

        public BigInteger getFileSize() {
            return XmlParser.getBigInteger(this.result, "/FileSize/value");
        }

        public String getFileFormat() {
            return XmlParser.getString(this.result, "/FileFormat/value");
        }

        public BigInteger getHeight() {
            return XmlParser.getBigInteger(this.result, "/Height/value");
        }

        public BigInteger getWidth() {
            return XmlParser.getBigInteger(this.result, "/Width/value");
        }

        public BigDecimal getDuration() {
            return XmlParser.getBigDecimal(this.result, "/Duration/value");
        }

        public boolean isStreaming() {
            Boolean bl = XmlParser.getBoolean(this.result, "/Streaming/value");
            return bl != null ? bl : false;
        }

        public String getChannels() {
            return XmlParser.getString(this.result, "/Channels/value");
        }

        public ImageThumbnail getThumbnail() {
            return this.thumbnail;
        }

        public String getPublisher() {
            return XmlParser.getString(this.result, "/Publisher/value");
        }

        public String getRestrictions() {
            return XmlParser.getString(this.result, "/Restrictions/value");
        }

        public String getCopyright() {
            return XmlParser.getString(this.result, "/Copyright/value");
        }
    }
}

