/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import visualizer.graph.Edge;
import visualizer.graph.Graph;
import visualizer.graph.Vertex;
import visualizer.triangulation.Triangulation;
import visualizer.view.ToolConfiguration;

public class GraphWriter {
    public static void saveAsXMLFile(Graph graph, String stplist, String description, String filename) throws IOException {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "ISO-8859-1"));
            out.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>\r\n");
            out.write("<graph description=\"");
            out.write(description);
            out.write("\">\r\n");
            ToolConfiguration tool = ToolConfiguration.getInstance(null);
            out.write("<number-iterations value=\"");
            out.write(Integer.toString(tool.getNrIterations()));
            out.write("\"/>\r\n");
            out.write("<fraction-delta value=\"");
            out.write(Float.toString(tool.getFracDelta()));
            out.write("\"/>\r\n");
            out.write("<min-cut value=\"");
            out.write(Float.toString(tool.getMin()));
            out.write("\"/>\r\n");
            out.write("<max-cut value=\"");
            out.write(Float.toString(tool.getMax()));
            out.write("\"/>\r\n");
            out.write("<number-grams value=\"");
            out.write(Integer.toString(tool.getNrGrams()));
            out.write("\"/>\r\n");
            out.write("<number-connections value=\"");
            out.write(Integer.toString(tool.getNrConnections()));
            out.write("\"/>\r\n");
            out.write("<number-neighbors value=\"");
            out.write(Integer.toString(tool.getNrNeighbors()));
            out.write("\"/>\r\n");
            out.write("<reducing value=\"");
            out.write(Boolean.toString(tool.isReducing()));
            out.write("\"/>\r\n");
            out.write("<dimensions value=\"");
            out.write(Integer.toString(tool.getDimensions()));
            out.write("\"/>\r\n");
            out.write("<stp-list value=\"");
            out.write(stplist);
            out.write("\"/>\r\n");
            out.write("<!--   vertex   -->\r\n");
            for (Vertex v : graph.getVertex()) {
                out.write("<vertex id=\"");
                out.write(Long.toString(v.getId()));
                out.write("\">\r\n");
                out.write("<x-coordinate value=\"");
                out.write(Float.toString(v.getX()));
                out.write("\"/>\r\n");
                out.write("<y-coordinate value=\"");
                out.write(Float.toString(v.getY()));
                out.write("\"/>\r\n");
                out.write("<title value=\"");
                out.write(GraphWriter.encodeToValidChars(GraphWriter.convert(GraphWriter.unConvert(v.getWebElement().getTitle()))));
                out.write("\"/>\r\n");
                out.write("<snippet value=\"");
                out.write(GraphWriter.encodeToValidChars(GraphWriter.convert(GraphWriter.unConvert(v.getWebElement().getSnippet()))));
                out.write("\"/>\r\n");
                out.write("<url value=\"");
                out.write(GraphWriter.encodeToValidChars(GraphWriter.convert(GraphWriter.unConvert(v.getWebElement().getUrl()))));
                out.write("\"/>\r\n");
                out.write("<scalar-class value=\"");
                out.write(Float.toString(v.getWebElement().getScalar()));
                out.write("\"/>\r\n");
                out.write("<date value=\"");
                out.write(v.getWebElement().getDate());
                out.write("\"/>\r\n");
                out.write("<scalars>\r\n");
                for (String n : graph.getScalarNames()) {
                    out.write("<scalar name=\"");
                    out.write(n.replaceAll("\"", "'"));
                    out.write("\" value=\"");
                    out.write(Float.toString(v.getScalar(graph.getScalarIndex(n))));
                    out.write("\"/>\r\n");
                }
                out.write("</scalars>\r\n");
                out.write("</vertex>\r\n");
            }
            out.write("<!--   edges   -->\r\n");
            for (Triangulation triangulation : graph.getTriangulations()) {
                out.write("<edges name=\"");
                out.write(triangulation.getName());
                out.write("\">\r\n");
                for (Edge e : triangulation.getEdges()) {
                    out.write("<edge source=\"");
                    out.write(Long.toString(e.getSource().getId()));
                    out.write("\" target=\"");
                    out.write(Long.toString(e.getTarget().getId()));
                    out.write("\"/>\r\n");
                }
                out.write("</edges>\r\n");
            }
            out.write("</graph>\r\n");
        }
        catch (FileNotFoundException e) {
            throw new IOException("File \"" + filename + "\" was not found!");
        }
        catch (IOException e) {
            throw new IOException("Problems reading the file \"" + filename + "\"");
        }
        finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static String convert(String value) {
        if (value == null) {
            return "";
        }
        value = value.replaceAll("&", "&amp;");
        value = value.replaceAll("<", "&lt;");
        value = value.replaceAll(">", "&gt;");
        value = value.replaceAll("\"", "&quot;");
        value = value.replaceAll("'", "&#39;");
        return value;
    }

    public static String unConvert(String value) {
        if (value == null) {
            return "";
        }
        value = value.replaceAll("&amp;", "&");
        value = value.replaceAll("&lt;", "<");
        value = value.replaceAll("&gt;", ">");
        value = value.replaceAll("&quot;", "\"");
        value = value.replaceAll("&#39;", "'");
        return value;
    }

    public static String encodeToValidChars(String pData) {
        StringBuffer encodedData = new StringBuffer();
        for (int i = 0; i < pData.length(); ++i) {
            char ch = pData.charAt(i);
            char chVal = ch;
            if (chVal >= ' ' && chVal <= '\u00ff') {
                encodedData.append(chVal);
                continue;
            }
            encodedData.append(" ");
        }
        return encodedData.toString();
    }
}

