/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph;

import java.io.IOException;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import visualizer.graph.Vertex;
import visualizer.web.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerySolver {
    private Vector<Vertex> vertex;
    public static final String splitSymbol = "&";
    public static final char splitSymbolChar = '&';

    public QuerySolver(Vector<Vertex> vertex) {
        this.vertex = vertex;
    }

    public boolean isoperand(String symb) {
        symb.replaceAll(" ", "");
        return !symb.equals("and") && !symb.equals("or") && !symb.equals("(") && !symb.equals(")");
    }

    public boolean prdc(String one, String two) {
        if (one.equals("(")) {
            return false;
        }
        if (!one.equals(")") && two.equals("(")) {
            return false;
        }
        if (!one.equals("(") && two.equals(")")) {
            return true;
        }
        if (one.equals("and") && two.equals("or")) {
            return true;
        }
        if (one.equals("or") && two.equals("and")) {
            return false;
        }
        if (one.equals(two)) {
            return true;
        }
        return true;
    }

    public static String replaceCharAt(String s, int pos, char c) {
        return s.substring(0, pos) + c + s.substring(pos + 1);
    }

    public String postfix(String query) {
        boolean outpos = false;
        String topsymb = "or";
        StringBuffer postr = new StringBuffer();
        Stack<String> opstk = new Stack<String>();
        query = query.trim();
        query = query.replaceAll("\\(", " \\( ");
        query = query.replaceAll("\\)", " \\) ");
        boolean inSet = false;
        for (int i = 0; i < query.length(); ++i) {
            if (query.charAt(i) == '\"') {
                inSet = !inSet;
                continue;
            }
            if (inSet || query.charAt(i) != ' ') continue;
            query = QuerySolver.replaceCharAt(query, i, '&');
        }
        String[] symbs = query.split(splitSymbol);
        for (int i = 0; i < symbs.length; ++i) {
            boolean und;
            symbs[i] = symbs[i].replaceAll("\"", "");
            if (this.isoperand(symbs[i])) {
                postr.append(symbs[i] + splitSymbol);
                continue;
            }
            if (!opstk.empty()) {
                und = false;
                topsymb = (String)opstk.pop();
            } else {
                und = true;
            }
            while (!und && this.prdc(topsymb, symbs[i])) {
                postr.append(topsymb + splitSymbol);
                if (!opstk.empty()) {
                    und = false;
                    topsymb = (String)opstk.pop();
                    continue;
                }
                und = true;
            }
            if (!und) {
                opstk.push(topsymb);
            }
            if (und || !symbs[i].equals(")")) {
                opstk.push(symbs[i]);
                continue;
            }
            topsymb = (String)opstk.pop();
        }
        while (!opstk.empty()) {
            postr.append((String)opstk.pop() + splitSymbol);
        }
        return postr.toString();
    }

    protected float[] oper(String opr, float[] cdata1, float[] cdata2) {
        float[] cdata = new float[this.vertex.size()];
        for (int i = 0; i < cdata1.length; ++i) {
            cdata[i] = (cdata1[i] + cdata2[i]) / 2.0f;
            if (!opr.equals("and") || cdata1[i] != 0.0f && cdata2[i] != 0.0f) continue;
            cdata[i] = 0.0f;
        }
        return cdata;
    }

    float[] value(String word) throws IOException {
        float[] cdata = new float[this.vertex.size()];
        float max = 0.0f;
        float min = 0.0f;
        float numberOcurrences = 0.0f;
        for (int i = 0; i < this.vertex.size(); ++i) {
            cdata[i] = this.getWordFrequency(word, this.vertex.elementAt(i).getWebElement());
            if (cdata[i] > max) {
                max = cdata[i];
            } else if (cdata[i] < min) {
                min = cdata[i];
            }
            if (!(cdata[i] > 0.0f)) continue;
            numberOcurrences += 1.0f;
        }
        return cdata;
    }

    float[] eval(String postFix) throws IOException {
        Stack<float[]> opndstk = new Stack<float[]>();
        String[] symbs = postFix.split(splitSymbol);
        for (int i = 0; i < symbs.length; ++i) {
            if (symbs[i].equals("")) continue;
            if (this.isoperand(symbs[i])) {
                opndstk.push(this.value(symbs[i]));
                continue;
            }
            float[] opnd2 = (float[])opndstk.pop();
            float[] opnd1 = (float[])opndstk.pop();
            float[] value = this.oper(symbs[i], opnd1, opnd2);
            opndstk.push(value);
        }
        return (float[])opndstk.pop();
    }

    public void createCdata(String query, int scalarIndex) throws IOException {
        int i;
        float[] cdata = this.eval(this.postfix(query));
        float max = 0.0f;
        float min = 1.0E11f;
        float numberOcurrences = 0.0f;
        for (i = 0; i < this.vertex.size(); ++i) {
            if (cdata[i] > max) {
                max = cdata[i];
            } else if (cdata[i] < min) {
                min = cdata[i];
            }
            if (!(cdata[i] > 0.0f)) continue;
            numberOcurrences += 1.0f;
        }
        for (i = 0; i < cdata.length; ++i) {
            cdata[i] = (double)(max - min) > 0.0 && cdata[i] >= numberOcurrences / (float)this.vertex.size() ? (cdata[i] - min) / (max - min) : 0.0f;
        }
        for (i = 0; i < this.vertex.size(); ++i) {
            this.vertex.elementAt(i).setScalar(scalarIndex, cdata[i]);
        }
    }

    private float getWordFrequency(String word, WebElement page) throws IOException {
        float frequency = 0.0f;
        Pattern p = Pattern.compile(word.toLowerCase());
        String content = page.getContent();
        if (content != null) {
            Matcher m = p.matcher(content.toLowerCase());
            while (m.find()) {
                frequency += 1.0f;
            }
        }
        return frequency;
    }
}

