/*
 * Decompiled with CFR 0.152.
 */
package visualizer.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Vector;
import visualizer.graph.GraphWriter;
import visualizer.view.color.ColorTable;
import visualizer.web.WebElement;

public class Vertex
implements Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final float EPSILON = 1.0E-5f;
    private WebElement webElement;
    private Vector<Float> scalars = new Vector();
    private Color color = Color.WHITE;
    private float x = 0.0f;
    private float y = 0.0f;
    private static int rayBase = 4;
    private float rayFactor = 0.0f;
    private long id = 0L;
    private static boolean isIdVisible = false;
    private static Font font = new Font("Verdana", 1, 12);
    private ColorTable colorTable;
    private boolean selected = false;
    private boolean trainningDocument = false;
    private Color trDocsColor = Color.BLACK;

    public Vertex(WebElement webElement, long id) {
        this.webElement = webElement;
        this.id = id;
    }

    public Vertex(WebElement webElement, long id, float x, float y) {
        this.webElement = webElement;
        this.id = id;
        this.x = x;
        this.y = y;
    }

    public void draw(Graphics2D g2) {
        Color fillColor;
        Color color = fillColor = this.trainningDocument ? Color.WHITE : this.color;
        if (this.selected) {
            g2.setStroke(new BasicStroke(4.0f));
            rayBase = (int)((double)rayBase * 1.5);
            g2.setColor(fillColor);
            g2.fillOval((int)this.x - this.getRay(), (int)this.y - this.getRay(), this.getRay() * 2, this.getRay() * 2);
            g2.setColor(Color.DARK_GRAY);
            g2.drawOval((int)this.x - this.getRay(), (int)this.y - this.getRay(), this.getRay() * 2, this.getRay() * 2);
            g2.setStroke(new BasicStroke(1.0f));
            rayBase = (int)((double)rayBase / 1.5);
        } else {
            g2.setColor(fillColor);
            g2.fillOval((int)this.x - this.getRay(), (int)this.y - this.getRay(), this.getRay() * 2, this.getRay() * 2);
            g2.setColor(Color.BLACK);
            g2.drawOval((int)this.x - this.getRay(), (int)this.y - this.getRay(), this.getRay() * 2, this.getRay() * 2);
        }
        if (isIdVisible) {
            g2.setFont(font);
            FontMetrics metrics = g2.getFontMetrics(font);
            g2.drawString(Long.toString(this.id), (int)this.x - metrics.stringWidth(Long.toString(this.id)) / 2, (int)this.y + metrics.getAscent() / 2);
        }
        if (this.trainningDocument) {
            g2.setColor(this.trDocsColor);
            g2.setStroke(new BasicStroke(3.0f));
            g2.drawLine((int)(this.x - (float)this.getRay()), (int)(this.y - (float)this.getRay()), (int)(this.x + (float)this.getRay()), (int)(this.y + (float)this.getRay()));
            g2.drawLine((int)(this.x + (float)this.getRay()), (int)(this.y - (float)this.getRay()), (int)(this.x - (float)this.getRay()), (int)(this.y + (float)this.getRay()));
            g2.setStroke(new BasicStroke(1.0f));
        }
    }

    public boolean isInside(int x, int y) {
        return Math.sqrt(Math.pow((float)x - this.x, 2.0) + Math.pow((float)y - this.y, 2.0)) <= (double)this.getRay();
    }

    public boolean isInside(Rectangle rectangle) {
        return this.x >= (float)rectangle.x && this.x - (float)rectangle.x < (float)rectangle.width && this.y >= (float)rectangle.y && this.y - (float)rectangle.y < (float)rectangle.height;
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setColor(int scalarIndex) {
        this.color = (float)scalarIndex > -1.0f ? this.colorTable.getColor(this.scalars.get(scalarIndex).floatValue()) : Color.WHITE;
    }

    public void setColorTable(ColorTable colorTable) {
        this.colorTable = colorTable;
    }

    public float getX() {
        return this.x;
    }

    public void setX(float x) {
        this.x = x;
    }

    public float getY() {
        return this.y;
    }

    public void setY(float y) {
        this.y = y;
    }

    public static int getRayBase() {
        return rayBase;
    }

    public static void setRayBase(int aRay) {
        rayBase = aRay;
    }

    public void setRayFactor(float ray) {
        this.rayFactor = this.rayFactor;
    }

    public float getRayFactor() {
        return this.rayFactor;
    }

    public int getRay() {
        return (int)((float)rayBase + this.rayFactor * (float)rayBase);
    }

    public void setRayFactor(int scalarIndex) {
        this.rayFactor = this.scalars.get(scalarIndex).floatValue();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String toString() {
        if (isIdVisible) {
            return this.id + " - " + (int)this.getWebElement().getScalar() + " - " + GraphWriter.unConvert(this.webElement.getTitle());
        }
        return (int)this.getWebElement().getScalar() + " - " + GraphWriter.unConvert(this.webElement.getTitle());
    }

    public void setScalar(int scalarIndex, float value) {
        if (this.scalars.size() > scalarIndex) {
            this.scalars.set(scalarIndex, Float.valueOf(value));
        } else {
            int size = this.scalars.size();
            for (int i = 0; i < scalarIndex - size; ++i) {
                this.scalars.add(Float.valueOf(0.0f));
            }
            this.scalars.add(Float.valueOf(value));
        }
    }

    public void removeScalar(int scalarIndex) {
        this.scalars.remove(scalarIndex);
    }

    public float getScalar(int scalarIndex) {
        if (this.scalars.size() > scalarIndex && scalarIndex > -1) {
            return this.scalars.get(scalarIndex).floatValue();
        }
        return 0.0f;
    }

    public static boolean isIsIdVisible() {
        return isIdVisible;
    }

    public static void setIsIdVisible(boolean aIsIdVisible) {
        isIdVisible = aIsIdVisible;
    }

    public WebElement getWebElement() {
        return this.webElement;
    }

    public void setWebElement(WebElement webElement) {
        this.webElement = webElement;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isTrainningDocument() {
        return this.trainningDocument;
    }

    public void setTrainningDocument(boolean trainningDocument) {
        this.trainningDocument = trainningDocument;
    }

    public Color getTrDocsColor() {
        return this.trDocsColor;
    }

    public void setTrDocsColor(Color trDocsColor) {
        this.trDocsColor = trDocsColor;
    }

    public int compareTo(Object o) {
        if (o instanceof Vertex) {
            if (this.x - ((Vertex)o).x == 1.0E-5f) {
                if (this.y - ((Vertex)o).y == 1.0E-5f) {
                    return 0;
                }
                if (this.y - ((Vertex)o).y > 1.0E-5f) {
                    return 1;
                }
                return -1;
            }
            if (this.x - ((Vertex)o).x > 1.0E-5f) {
                return 1;
            }
            return -1;
        }
        return -1;
    }
}

