/*
 * Decompiled with CFR 0.152.
 */
package visualizer.kmx;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Scanner;
import visualizer.kmx.Document;
import visualizer.kmx.Klass;
import visualizer.kmx.Request;
import visualizer.kmx.RequestType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KMXClient {
    private String server_address;
    private int server_port;

    public KMXClient(String server_address, int server_port) {
        this.server_address = server_address;
        this.server_port = server_port;
    }

    public int[] clustering(ArrayList<Document> docs, int nrClusters) throws IOException {
        int[] clusters = new int[docs.size()];
        Request req = new Request(RequestType.CLUSTERING);
        req.parameters = new Object[1];
        req.parameters[0] = new Integer(nrClusters);
        StringBuffer output = this.requestKMXService(req, docs);
        int count = 0;
        Scanner scanner = new Scanner(output.toString());
        while (scanner.hasNextLine()) {
            int value;
            String line = scanner.nextLine();
            int index = Integer.parseInt(line.substring(0, line.indexOf(59)));
            clusters[index] = value = Integer.parseInt(line.substring(line.indexOf(59) + 1));
            ++count;
        }
        if (count != clusters.length) {
            throw new IOException("Problems executing the clustering script.\nPlease contact paulovic@icmc.usp.br informing the error.");
        }
        return clusters;
    }

    public int[] classification(ArrayList<Document> docs, ArrayList<Klass> classification) throws IOException {
        int[] classes = new int[docs.size()];
        Request req = new Request(RequestType.CLASSIFICATION);
        req.parameters = new Object[1];
        req.parameters[0] = classification;
        StringBuffer output = this.requestKMXService(req, docs);
        ArrayList<String> classes_id = new ArrayList<String>();
        String[] classes_aux = new String[docs.size()];
        int count = 0;
        Scanner scanner = new Scanner(output.toString());
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            int index = Integer.parseInt(line.substring(0, line.indexOf(59)));
            String value_aux = line.substring(line.indexOf(59) + 1);
            if (!classes_id.contains(value_aux)) {
                classes_id.add(value_aux);
            }
            classes_aux[index] = value_aux;
            ++count;
        }
        Collections.sort(classes_id);
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = classes_id.size() - (classes_id.indexOf(classes_aux[i]) + 1);
        }
        if (count != classes.length) {
            throw new IOException("Problems executing the classification script.\nPlease contact paulovic@icmc.usp.br informing the error.");
        }
        return classes;
    }

    private StringBuffer requestKMXService(Request request, ArrayList<Document> documents) throws IOException {
        Socket socket = null;
        ObjectOutputStream out = null;
        BufferedReader in = null;
        StringBuffer output = new StringBuffer();
        try {
            socket = new Socket(this.server_address, this.server_port);
            out = new ObjectOutputStream(socket.getOutputStream());
            in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out.writeObject(request);
            out.writeObject(documents);
            String fromServer = in.readLine();
            while (fromServer != null && !fromServer.equals("##EOT##")) {
                if (fromServer.equals("##ERROR##")) {
                    throw new IOException();
                }
                output.append(fromServer + "\n");
                fromServer = in.readLine();
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new IOException("KMX Stub Server (" + this.server_address + ") unreacheable.\n" + "Please contact paulovic@icmc.usp.br informing the error.");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IOException("Problems with the KMX Stub server (" + this.server_address + ").\n" + "Please contact paulovic@icmc.usp.br informing the error.");
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
                if (socket != null) {
                    socket.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return output;
    }
}

