/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection;

import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import visualizer.projection.FastmapProjection;
import visualizer.projection.ForceScheme;
import visualizer.projection.GraphBuilderListener;
import visualizer.projection.Projector;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.distance.DistanceMatrixFactory;
import visualizer.projection.distance.DistanceMeasure;
import visualizer.util.BKmeans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterProjection {
    private Vector<Vector<Integer>> clusters;
    private float fractionDelta = 8.0f;
    private int numberIterations = 100;
    private Class projectionType = FastmapProjection.class;
    private GraphBuilderListener listener;

    public ClusterProjection(GraphBuilderListener listener) {
        this.listener = listener;
    }

    public float getFractionDelta() {
        return this.fractionDelta;
    }

    public void setFractionDelta(float fractionDelta) {
        this.fractionDelta = fractionDelta;
    }

    public int getNumberIterations() {
        return this.numberIterations;
    }

    public void setNumberIterations(int numberIterations) {
        this.numberIterations = numberIterations;
    }

    public Class getProjectionType() {
        return this.projectionType;
    }

    public void setProjectionType(Class projectionType) {
        this.projectionType = projectionType;
    }

    public Vector<Vector<Integer>> getClusters() {
        return this.clusters;
    }

    public float[][] getProjection(DistanceMeasure metric, float[][] points, int numberPivots, float clusterFactor) throws IOException {
        int i;
        Vector<float[][]> projections = new Vector<float[][]>();
        if (this.listener != null) {
            this.listener.setProjectionStatus("Creating the clusters...", 30);
        }
        BKmeans bkmeans = new BKmeans(numberPivots);
        this.clusters = bkmeans.execute(metric, points);
        float[][] centroids = bkmeans.getCentroids();
        if (this.listener != null) {
            this.listener.setProjectionStatus("Positioning the pivots...", 50);
        }
        float[][] pivotsProjection = this.createPivotsProjection(metric, centroids);
        if (this.listener != null) {
            this.listener.setProjectionStatus("Projecting the clusters...", 65);
        }
        for (int cluster = 0; cluster < this.clusters.size(); ++cluster) {
            if (this.listener != null) {
                this.listener.setProjectionStatus("Projecting the clusters...", 65 + cluster / 5);
            }
            DistanceMatrix dmat = this.createDistanceMatrix(metric, points, this.clusters.elementAt(cluster));
            try {
                Projector proj = (Projector)this.projectionType.newInstance();
                float[][] projection = proj.project(dmat);
                projections.add(projection);
                if (projection == null) continue;
                ForceScheme force = new ForceScheme(this.fractionDelta, projection.length);
                for (int i2 = 0; i2 < this.numberIterations; ++i2) {
                    force.iteration(dmat, projection);
                }
                continue;
            }
            catch (InstantiationException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (IllegalAccessException ex) {
                ex.printStackTrace();
            }
        }
        if (this.listener != null) {
            this.listener.setProjectionStatus("Assembling the final projection...", 85);
        }
        float[][] projection = new float[points.length][];
        float[] centroidMaxDistances = new float[this.clusters.size()];
        float overallMaxDistance = Float.MIN_VALUE;
        Arrays.fill(centroidMaxDistances, Float.MIN_VALUE);
        for (i = 0; i < this.clusters.size(); ++i) {
            if (this.listener != null) {
                this.listener.setProjectionStatus("Assembling the final projection...", 85 + i / 5);
            }
            for (int j = 0; j < this.clusters.elementAt(i).size(); ++j) {
                float distance = metric.calculateDistance(centroids[i], points[this.clusters.elementAt(i).elementAt(j)]);
                if (distance > centroidMaxDistances[i]) {
                    centroidMaxDistances[i] = distance;
                }
                if (!(distance > overallMaxDistance)) continue;
                overallMaxDistance = distance;
            }
        }
        for (i = 0; i < this.clusters.size(); ++i) {
            int j;
            float[][] p = (float[][])projections.elementAt(i);
            this.normalize2D(p, 0.0f, centroidMaxDistances[i] / overallMaxDistance);
            for (j = 0; j < p.length; ++j) {
                p[j][0] = p[j][0] + pivotsProjection[i][0] * clusterFactor;
                p[j][1] = p[j][1] + pivotsProjection[i][1] * clusterFactor;
            }
            for (j = 0; j < p.length; ++j) {
                projection[this.clusters.elementAt((int)i).elementAt((int)j).intValue()] = p[j];
            }
        }
        return projection;
    }

    private float[][] createPivotsProjection(DistanceMeasure metric, float[][] pivots) {
        float[][] projection = null;
        try {
            DistanceMatrix dmat = DistanceMatrixFactory.getInstance(pivots, metric.getClass());
            Projector proj = (Projector)this.projectionType.newInstance();
            projection = proj.project(dmat);
            if (projection != null) {
                ForceScheme force = new ForceScheme(this.fractionDelta, projection.length);
                for (int i = 0; i < this.numberIterations; ++i) {
                    force.iteration(dmat, projection);
                }
            }
            this.normalize2D(projection, 0.0f, 1.0f);
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        return projection;
    }

    private DistanceMatrix createDistanceMatrix(DistanceMeasure metric, float[][] points, Vector<Integer> cluster) {
        float[][] nPoints = new float[cluster.size()][];
        for (int i = 0; i < cluster.size(); ++i) {
            nPoints[i] = points[cluster.elementAt(i)];
        }
        DistanceMatrix dmat = DistanceMatrixFactory.getInstance(nPoints, metric.getClass());
        return dmat;
    }

    private void normalize2D(float[][] projection, float begin, float end) {
        float maxX = projection[0][0];
        float minX = projection[0][0];
        float maxY = projection[0][1];
        float minY = projection[0][1];
        for (int _ins = 1; _ins < projection.length; ++_ins) {
            if (minX > projection[_ins][0]) {
                minX = projection[_ins][0];
            } else if (maxX < projection[_ins][0]) {
                maxX = projection[_ins][0];
            }
            if (minY > projection[_ins][1]) {
                minY = projection[_ins][1];
                continue;
            }
            if (!(maxY < projection[_ins][1])) continue;
            maxY = projection[_ins][1];
        }
        float endY = (maxY - minY) / (maxX - minX);
        for (int _ins = 0; _ins < projection.length; ++_ins) {
            projection[_ins][0] = (double)(maxX - minX) > 0.0 ? (projection[_ins][0] - minX) / (maxX - minX) : 0.0f;
            projection[_ins][1] = (double)(maxY - minY) > 0.0 ? (projection[_ins][1] - minY) / ((maxY - minY) * endY) : 0.0f;
        }
    }
}

