/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection;

import java.util.ArrayList;
import visualizer.projection.distance.DistanceMatrix;

public class ForceScheme {
    public static final float EPSILON = 1.0E-7f;
    private float fractionDelta;
    private int[] index;

    public ForceScheme(float fractionDelta, int numberPoints) {
        int i;
        this.fractionDelta = fractionDelta;
        ArrayList<Integer> index_aux = new ArrayList<Integer>();
        for (i = 0; i < numberPoints; ++i) {
            index_aux.add(i);
        }
        this.index = new int[numberPoints];
        i = 0;
        for (int j = 0; j < this.index.length; ++j) {
            int ind = (int)Math.pow(2.0, i);
            if (ind >= index_aux.size()) {
                ind = 0;
            }
            this.index[j] = (Integer)index_aux.get(ind);
            index_aux.remove(ind);
            ++i;
        }
    }

    public float iteration(DistanceMatrix dmat, float[][] projection) {
        for (int ins1 = 0; ins1 < projection.length - 1; ++ins1) {
            int instance = this.index[ins1];
            for (int ins2 = 0; ins2 < projection.length; ++ins2) {
                int instance2 = this.index[ins2];
                if (instance == instance2) continue;
                float dr2 = this.distR2(projection[instance], projection[instance2]);
                float drn = dmat.getDistance(instance, instance2);
                float normdrn = (drn - dmat.getMinDistance()) / (dmat.getMaxDistance() - dmat.getMinDistance());
                float delta = normdrn - dr2;
                delta /= this.fractionDelta;
                delta *= Math.abs(delta);
                float[] fArray = projection[instance2];
                fArray[0] = fArray[0] + delta * ((projection[instance2][0] - projection[instance][0]) / dr2);
                float[] fArray2 = projection[instance2];
                fArray2[1] = fArray2[1] + delta * ((projection[instance2][1] - projection[instance][1]) / dr2);
            }
        }
        float error = 0.0f;
        float sumDist = 0.0f;
        float sumSquareMeanError = 0.0f;
        for (int i = 0; i < dmat.getNumberPoints() - 1; ++i) {
            for (int j = i + 1; j < dmat.getNumberPoints(); ++j) {
                float dist = dmat.getDistance(i, j) > 1.0E-7f ? dmat.getDistance(i, j) : 1.0E-7f;
                sumSquareMeanError = (float)((double)sumSquareMeanError + Math.pow(dist - this.distR2(projection[i], projection[j]), 2.0) / (double)dist);
                sumDist += dist;
            }
        }
        error = 1.0f / sumDist * sumSquareMeanError;
        return error;
    }

    private float distR2(float[] pointA, float[] pointB) {
        float x1x2 = pointA[0] - pointB[0];
        float y1y2 = pointA[1] - pointB[1];
        float dist = (float)Math.sqrt(x1x2 * x1x2 + y1y2 * y1y2);
        if (dist > 1.0E-7f) {
            return dist;
        }
        return 1.0E-7f;
    }
}

