/*
 * Decompiled with CFR 0.152.
 */
package visualizer.projection;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import java.io.IOException;
import java.util.Vector;
import visualizer.projection.FastmapProjection;
import visualizer.projection.ForceScheme;
import visualizer.projection.GraphBuilderListener;
import visualizer.projection.MeshGenerator;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.distance.DistanceMatrixFactory;
import visualizer.projection.distance.DistanceMeasure;
import visualizer.projection.distance.FastmapSimilarity;
import visualizer.triangulation.Neighborhood;
import visualizer.util.ApproxKNN;
import visualizer.util.BKmeans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LSPProjection {
    private GraphBuilderListener listener;
    private float[][] projection_cp;
    private int[] medoids = null;
    private DistanceMeasure metric = new FastmapSimilarity();
    private int nrControlPoints = 10;
    private int nrConnections = 10;
    private float fracDelta = 8.0f;
    private int nrIterations = 100;

    public LSPProjection(GraphBuilderListener listener) {
        this.listener = listener;
    }

    public float[][] project(float[][] points) throws IOException {
        float[][] projection = new float[points.length][];
        Vector<Vector<Integer>> clusters = null;
        try {
            FastmapSimilarity.normalize(points);
            if (this.listener != null) {
                this.listener.setProjectionStatus("Selecting control points...", 40);
            }
            BKmeans bkmeans = new BKmeans(this.nrControlPoints);
            clusters = bkmeans.execute(this.metric, points);
            this.medoids = bkmeans.getMedoids(points);
            this.nrControlPoints = this.medoids.length;
            float[][] points_cp = new float[this.medoids.length][];
            for (int i = 0; i < points_cp.length; ++i) {
                points_cp[i] = new float[points[this.medoids[i]].length];
                for (int j = 0; j < points_cp[i].length; ++j) {
                    points_cp[i][j] = points[this.medoids[i]][j];
                }
            }
            DistanceMatrix dmat_cp = DistanceMatrixFactory.getInstance(points_cp, this.metric.getClass());
            if (this.listener != null) {
                this.listener.setProjectionStatus("Projecting...", 40);
            }
            FastmapProjection fastmap = new FastmapProjection();
            this.projection_cp = fastmap.project(dmat_cp);
            if (this.projection_cp != null) {
                ForceScheme force = new ForceScheme(this.fracDelta, this.projection_cp.length);
                for (int i = 0; i < this.nrIterations; ++i) {
                    if (this.listener != null) {
                        this.listener.setProjectionStatus("Improving the projection...", (int)(45.0f + (float)i * 50.0f / (float)this.nrIterations));
                    }
                    force.iteration(dmat_cp, this.projection_cp);
                }
            }
            if (this.listener != null) {
                this.listener.setProjectionStatus("Creating the mesh...", 45);
            }
            ApproxKNN appknnmesh = new ApproxKNN(this.nrConnections, 10);
            Vector<Neighborhood> mesh = appknnmesh.execute(points, this.metric, clusters);
            if (this.listener != null) {
                this.listener.setProjectionStatus("Creating the mesh: testing the connectivity...", 55);
            }
            MeshGenerator meshgen = new MeshGenerator();
            mesh = meshgen.execute(mesh, clusters, points_cp, points, this.metric);
            if (this.listener != null) {
                this.listener.setProjectionStatus("Solving the system...", 65);
            }
            this.projectUsingColt(mesh, projection);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        Runtime.getRuntime().gc();
        return projection;
    }

    private void projectUsingColt(Vector<Neighborhood> neighbors, float[][] projection) {
        int i;
        int nRows = neighbors.size() + this.nrControlPoints;
        int nColumns = neighbors.size();
        SparseDoubleMatrix2D A = new SparseDoubleMatrix2D(nRows, nColumns);
        for (i = 0; i < neighbors.size(); ++i) {
            A.setQuick(i, i, 1.0);
            for (int j = 0; j < neighbors.get(i).getNeighbors().size(); ++j) {
                A.setQuick(i, (int)neighbors.get((int)i).getNeighbors().get((int)j).id, -(1.0f / (float)neighbors.get(i).getNeighbors().size()));
            }
        }
        for (i = 0; i < this.nrControlPoints; ++i) {
            A.setQuick(projection.length + i, this.medoids[i], 1.0);
        }
        SparseDoubleMatrix2D B = new SparseDoubleMatrix2D(nRows, 2);
        for (int i2 = 0; i2 < this.projection_cp.length; ++i2) {
            B.setQuick(neighbors.size() + i2, 0, this.projection_cp[i2][0]);
            B.setQuick(neighbors.size() + i2, 1, this.projection_cp[i2][1]);
        }
        long start = System.currentTimeMillis();
        DoubleMatrix2D AtA = A.zMult(A, null, 1.0, 1.0, true, false);
        DoubleMatrix2D AtB = A.zMult(B, null, 1.0, 1.0, true, false);
        long end = System.currentTimeMillis();
        System.out.println("Multiplying: " + (float)(end - start) / 1000.0f);
        start = System.currentTimeMillis();
        CholeskyDecomposition chol = new CholeskyDecomposition(AtA);
        DoubleMatrix2D X = chol.solve(AtB);
        end = System.currentTimeMillis();
        System.out.println("Solution: " + (float)(end - start) / 1000.0f);
        for (int i3 = 0; i3 < X.rows(); ++i3) {
            projection[i3] = new float[2];
            projection[i3][0] = (float)X.getQuick(i3, 0);
            projection[i3][1] = (float)X.getQuick(i3, 1);
        }
    }

    public int getNrControlPoints() {
        return this.nrControlPoints;
    }

    public void setNrControlPoints(int nrControlPoints) {
        this.nrControlPoints = nrControlPoints;
    }

    public int getNrConnections() {
        return this.nrConnections;
    }

    public void setNrConnections(int nrConnections) {
        this.nrConnections = nrConnections;
    }

    public float getFracDelta() {
        return this.fracDelta;
    }

    public void setFracDelta(float fracDelta) {
        this.fracDelta = fracDelta;
    }

    public int getNrIterations() {
        return this.nrIterations;
    }

    public void setNrIterations(int nrIterations) {
        this.nrIterations = nrIterations;
    }
}

