/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Vector;
import visualizer.projection.distance.DistanceMeasure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BKmeans {
    private Vector<Vector<Integer>> clusters;
    private Vector<float[]> centroids;
    private int nrClusters;
    private DistanceMeasure dm;
    private float EPSILON = 1.0E-5f;
    private int nrIterations = 15;

    public BKmeans(int nrClusters) {
        this.nrClusters = nrClusters;
    }

    public Vector<Vector<Integer>> execute(DistanceMeasure dm, float[][] points) throws IOException {
        this.dm = dm;
        this.clusters = new Vector();
        this.centroids = new Vector();
        Vector<Integer> cluster = new Vector<Integer>();
        for (int i = 0; i < points.length; ++i) {
            cluster.add(i);
        }
        this.clusters.add(cluster);
        float[] aux = new float[points[0].length];
        System.arraycopy(points[0], 0, aux, 0, points[0].length);
        this.centroids.add(aux);
        int removed = 0;
        int iterations = 0;
        int nrClusters_aux = this.nrClusters - 1;
        do {
            for (int j = 0; j < nrClusters_aux; ++j) {
                int gCluster = 0;
                int gElements = this.clusters.get(gCluster).size();
                for (int k = 1; k < this.clusters.size(); ++k) {
                    if (this.clusters.get(k).size() <= gElements) continue;
                    gCluster = k;
                    gElements = this.clusters.get(k).size();
                }
                if (gElements <= 1) continue;
                this.splitCluster(gCluster, points);
            }
            removed = this.removeEmptyClusters();
            nrClusters_aux = removed - 1;
            System.out.println("######Number Clusters: " + this.clusters.size());
            System.out.println("######Empty Clusters:  " + removed);
        } while (removed > this.nrClusters / 20 && ++iterations < 5);
        return this.clusters;
    }

    public float[][] getCentroids() {
        float[][] c = new float[this.centroids.size()][];
        for (int i = 0; i < this.centroids.size(); ++i) {
            c[i] = this.centroids.get(i);
        }
        return c;
    }

    public int[] getMedoids(float[][] points) throws IOException {
        int[] m = new int[this.centroids.size()];
        for (int i = 0; i < this.centroids.size(); ++i) {
            int point = -1;
            float distance = Float.MAX_VALUE;
            for (int j = 0; j < this.clusters.get(i).size(); ++j) {
                float distance2 = this.dm.calculateDistance(this.centroids.get(i), points[this.clusters.get(i).get(j)]);
                if (!(distance > distance2)) continue;
                point = this.clusters.get(i).get(j);
                distance = distance2;
            }
            m[i] = point;
        }
        return m;
    }

    private void splitCluster(int gCluster, float[][] points) throws IOException {
        Vector<Integer> cluster = this.clusters.get(gCluster);
        this.clusters.remove(gCluster);
        this.centroids.remove(gCluster);
        int[] pivots = this.getPivots(cluster, points);
        Vector<Integer> cluster1 = new Vector<Integer>();
        float[] centroid1 = new float[points[pivots[0]].length];
        System.arraycopy(points[pivots[0]], 0, centroid1, 0, points[pivots[0]].length);
        Vector<Integer> cluster2 = new Vector<Integer>();
        float[] centroid2 = new float[points[pivots[1]].length];
        System.arraycopy(points[pivots[1]], 0, centroid2, 0, points[pivots[1]].length);
        int iterations = 0;
        float[] oldCentr1 = null;
        float[] oldCentr2 = null;
        do {
            oldCentr1 = new float[centroid1.length];
            oldCentr2 = new float[centroid2.length];
            System.arraycopy(centroid1, 0, oldCentr1, 0, centroid1.length);
            System.arraycopy(centroid2, 0, oldCentr2, 0, centroid2.length);
            cluster1.clear();
            cluster2.clear();
            int size = cluster.size();
            for (int i = 0; i < size; ++i) {
                float distCentr2;
                float distCentr1 = this.dm.calculateDistance(points[cluster.get(i)], centroid1);
                if (distCentr1 - (distCentr2 = this.dm.calculateDistance(points[cluster.get(i)], centroid2)) < this.EPSILON) {
                    if (cluster1.size() > cluster2.size()) {
                        cluster2.add(cluster.get(i));
                        continue;
                    }
                    cluster1.add(cluster.get(i));
                    continue;
                }
                if (distCentr1 < distCentr2) {
                    cluster1.add(cluster.get(i));
                    continue;
                }
                cluster2.add(cluster.get(i));
            }
            Arrays.fill(centroid1, 0.0f);
            this.updateCentroid(points, centroid1, cluster1);
            Arrays.fill(centroid2, 0.0f);
            this.updateCentroid(points, centroid2, cluster2);
        } while (++iterations < this.nrIterations && (!this.equal(centroid1, oldCentr1) || !this.equal(centroid2, oldCentr2)));
        this.clusters.add(cluster1);
        this.clusters.add(cluster2);
        this.centroids.add(centroid1);
        this.centroids.add(centroid2);
    }

    private int[] getPivots(Vector<Integer> cluster, float[][] points) throws IOException {
        int[] pivots = new int[]{cluster.get((int)(Math.random() * (double)(cluster.size() - 1))), cluster.get((int)(Math.random() * (double)(cluster.size() - 1)))};
        if (pivots[0] == pivots[1]) {
            pivots[1] = pivots[0] == cluster.get(cluster.size() - 1) ? cluster.get(0).intValue() : cluster.get(cluster.size() - 1).intValue();
        }
        return pivots;
    }

    private void updateCentroid(float[][] points, float[] centroid, Vector<Integer> cluster) {
        for (int i = 0; i < cluster.size(); ++i) {
            for (int j = 0; j < points[cluster.get(i)].length; ++j) {
                int n = j;
                centroid[n] = centroid[n] + points[cluster.get(i)][j];
            }
        }
        int j = 0;
        while (j < centroid.length) {
            int n = j++;
            centroid[n] = centroid[n] / (float)cluster.size();
        }
    }

    private boolean equal(float[] newCentroid, float[] oldCentroid) {
        for (int i = 0; i < newCentroid.length; ++i) {
            if (!(newCentroid[i] - oldCentroid[i] > this.EPSILON)) continue;
            return false;
        }
        return true;
    }

    public int removeEmptyClusters() {
        int nrClusters = 0;
        for (int i = 0; i < this.clusters.size(); ++i) {
            if (this.clusters.get(i).size() != 0) continue;
            this.clusters.remove(i);
            this.centroids.remove(i);
            --i;
            ++nrClusters;
        }
        return nrClusters;
    }

    public class Pivot
    implements Comparable {
        public float distance;
        public int id;

        public Pivot(float distance, int id) {
            this.distance = distance;
            this.id = id;
        }

        public int compareTo(Object o) {
            if (o instanceof Pivot) {
                if (this.distance - ((Pivot)o).distance == BKmeans.this.EPSILON) {
                    return 0;
                }
                if (this.distance - ((Pivot)o).distance > BKmeans.this.EPSILON) {
                    return 1;
                }
                return -1;
            }
            return -1;
        }
    }
}

