/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import visualizer.graph.Vertex;
import visualizer.web.WebElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateVertexFromCorpus {
    public Vector<Vertex> create(String corpus) throws IOException {
        Vector<Vertex> vertex = new Vector<Vertex>();
        Vector<String> itemUrls = this.createFilenames(corpus);
        Vector<String> titles = this.createTitles(corpus, 1, itemUrls);
        Vector<String> pClass = new Vector<String>();
        for (int i = 0; i < itemUrls.size(); ++i) {
            WebElement we = WebElement.getStubElement();
            we.setDate("");
            we.setUrl(itemUrls.get(i));
            we.setSnippet(this.getFullContent(corpus, itemUrls.get(i)));
            we.setTitle(titles.get(i));
            String ini = itemUrls.get(i).substring(0, 2);
            if (!pClass.contains(ini)) {
                pClass.add(ini);
            }
            float scalar = pClass.indexOf(ini);
            we.setScalar(scalar);
            vertex.add(new Vertex(we, i));
        }
        return vertex;
    }

    private String getFullContent(String corpus, String itemUrl) throws IOException {
        ZipFile zip = null;
        try {
            zip = new ZipFile(corpus);
            ZipEntry entry = zip.getEntry(itemUrl);
            if (entry != null) {
                String line;
                BufferedReader in = new BufferedReader(new InputStreamReader(zip.getInputStream(entry), "ISO-8859-1"));
                StringBuffer text = new StringBuffer();
                while ((line = in.readLine()) != null) {
                    text.append(line + "\n");
                }
                String string = text.toString();
                return string;
            }
        }
        catch (IOException e) {
            throw new IOException("File " + itemUrl + " does not exist.");
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<String> createTitles(String corpus, int nrLines, Vector<String> itemUrls) {
        Vector<String> titles = new Vector<String>();
        ZipFile zip = null;
        try {
            zip = new ZipFile(corpus);
            for (String filename : itemUrls) {
                if (nrLines <= 0) continue;
                ZipEntry entry = zip.getEntry(filename);
                BufferedReader in = new BufferedReader(new InputStreamReader(zip.getInputStream(entry), "ISO-8859-1"));
                if (entry == null) continue;
                String line = "";
                String line_aux = null;
                int i = 0;
                while ((line_aux = in.readLine()) != null && i < nrLines) {
                    line_aux = line_aux.replace("&", "");
                    line_aux = line_aux.replace("\"", "");
                    line_aux = line_aux.replace("<b>", "");
                    if ((line_aux = line_aux.replace("</b>", "")).trim().length() <= 1) continue;
                    line = line + " " + line_aux;
                    ++i;
                }
                titles.add(line.trim());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return titles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<String> createFilenames(String corpus) {
        Vector<String> itemUrls = new Vector<String>();
        ZipFile zip = null;
        try {
            Vector<String> filenames_aux = new Vector<String>();
            zip = new ZipFile(corpus);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry2;
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || (entry2 = zip.getEntry(entry.getName())) == null) continue;
                filenames_aux.add(entry2.getName());
            }
            ArrayList<Integer> index_aux = new ArrayList<Integer>();
            for (int i = 0; i < filenames_aux.size(); ++i) {
                index_aux.add(i);
            }
            int[] index = new int[filenames_aux.size()];
            int i = 0;
            for (int j = 0; j < index.length; ++j) {
                int ind = (int)Math.pow(2.0, i);
                if (ind >= index_aux.size()) {
                    ind = 0;
                }
                index[j] = (Integer)index_aux.get(ind);
                index_aux.remove(ind);
                ++i;
            }
            for (i = 0; i < filenames_aux.size(); ++i) {
                itemUrls.add((String)filenames_aux.elementAt(index[i]));
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return itemUrls;
    }
}

