/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.util.Arrays;
import java.util.Vector;
import visualizer.projection.distance.DistanceMatrix;
import visualizer.projection.distance.DistanceMatrixFactory;
import visualizer.projection.distance.Euclidean;
import visualizer.triangulation.Neighborhood;
import visualizer.util.KNN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBSCAN2D {
    private int NR_NEIGHBORS = 4;

    public Vector<Vector<Integer>> execute(float[][] points) {
        DistanceMatrix dmat = DistanceMatrixFactory.getInstance(points, Euclidean.class);
        float eps = this.calculateEps(dmat);
        Vector<Point> points_aux = new Vector<Point>();
        for (int i = 0; i < dmat.getNumberPoints(); ++i) {
            points_aux.add(new Point(i));
        }
        this.dbscan(dmat, points_aux, eps, 7);
        int nrclusters = 0;
        for (Point p : points_aux) {
            if (p.clusterId <= nrclusters) continue;
            nrclusters = p.clusterId;
        }
        Vector<Vector<Integer>> clusters = new Vector<Vector<Integer>>();
        for (int i = 0; i < nrclusters + 1; ++i) {
            clusters.add(new Vector());
        }
        for (Point p : points_aux) {
            if (p.clusterId <= -1) continue;
            clusters.get(p.clusterId).add(p.id);
        }
        return clusters;
    }

    private float calculateEps(DistanceMatrix dmat) {
        float[] max_ray = new float[dmat.getNumberPoints()];
        KNN knn = new KNN(this.NR_NEIGHBORS);
        Vector<Neighborhood> neighbors = knn.execute(dmat);
        for (int p = 0; p < neighbors.size(); ++p) {
            float max_dist = Float.MIN_VALUE;
            for (int n = 0; n < neighbors.get(p).getNeighbors().size(); ++n) {
                if (!(neighbors.get((int)p).getNeighbors().get((int)n).distance > max_dist)) continue;
                max_dist = neighbors.get((int)p).getNeighbors().get((int)n).distance;
            }
            max_ray[p] = max_dist;
        }
        Arrays.sort(max_ray);
        return max_ray[(int)((float)dmat.getNumberPoints() * 0.85f)];
    }

    private void dbscan(DistanceMatrix dmat, Vector<Point> points, float eps, int minPts) {
        int clusterId = this.nextId(-1);
        for (int i = 0; i < points.size(); ++i) {
            Point p = points.get(i);
            if (p.clusterId != -2 || !this.expandCluster(dmat, points, p, clusterId, eps, minPts)) continue;
            clusterId = this.nextId(clusterId);
        }
    }

    private boolean expandCluster(DistanceMatrix dmat, Vector<Point> points, Point p, int clusterId, float eps, int minPts) {
        Vector<Point> seeds = this.regionQuery(dmat, points, p, eps);
        if (seeds.size() < minPts) {
            this.changeClusterId(p, -1);
            return false;
        }
        this.changeClusterIds(seeds, clusterId);
        seeds.remove(p);
        while (seeds.size() > 0) {
            Point currentP = seeds.firstElement();
            Vector<Point> result = this.regionQuery(dmat, points, currentP, eps);
            if (result.size() >= minPts) {
                for (int i = 0; i < result.size(); ++i) {
                    Point resultP = result.get(i);
                    if (resultP.clusterId != -2 && resultP.clusterId != -1) continue;
                    if (resultP.clusterId == -2) {
                        seeds.add(resultP);
                    }
                    this.changeClusterId(resultP, clusterId);
                }
            }
            seeds.remove(currentP);
        }
        return true;
    }

    private Vector<Point> regionQuery(DistanceMatrix dmat, Vector<Point> points, Point p, float eps) {
        Vector<Point> query = new Vector<Point>();
        for (int i = 0; i < points.size(); ++i) {
            if (!(dmat.getDistance(p.id, points.get((int)i).id) <= eps)) continue;
            query.add(points.get(i));
        }
        return query;
    }

    private void changeClusterId(Point p, int id) {
        p.clusterId = id;
    }

    private void changeClusterIds(Vector<Point> points, int id) {
        for (Point p : points) {
            p.clusterId = id;
        }
    }

    private int nextId(int id) {
        return ++id;
    }

    class Point {
        public static final int UNCLASSIFIED = -2;
        public static final int NOISE = -1;
        public int id = 0;
        public int clusterId = -2;

        public Point(int id) {
            this.id = id;
        }
    }
}

