/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.util.Vector;
import visualizer.projection.distance.DistanceMatrix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Kmedoids {
    private int numberClusters;
    private int[] medoids;

    public Kmedoids(int numberClusters) {
        this.numberClusters = numberClusters;
        this.medoids = new int[numberClusters];
    }

    public Vector<Vector<Integer>> doClustering(DistanceMatrix dmat) {
        Vector<Vector<Integer>> clusters = new Vector<Vector<Integer>>();
        for (int i = 0; i < this.numberClusters; ++i) {
            clusters.add(new Vector());
        }
        int[] oldMedoids = new int[this.numberClusters];
        for (int i = 0; i < this.numberClusters; ++i) {
            this.medoids[i] = i * (dmat.getNumberPoints() / this.numberClusters);
        }
        boolean medoidModified = true;
        for (int nroIterations = 0; medoidModified && nroIterations < dmat.getNumberPoints(); ++nroIterations) {
            int numberElements = Integer.MAX_VALUE;
            for (int point = 0; point < dmat.getNumberPoints(); ++point) {
                int nearestCluster = 0;
                float distance = dmat.getDistance(point, this.medoids[nearestCluster]);
                for (int cluster = 1; cluster < clusters.size(); ++cluster) {
                    float distance2 = dmat.getDistance(point, this.medoids[cluster]);
                    if (distance > distance2) {
                        nearestCluster = cluster;
                        distance = distance2;
                        continue;
                    }
                    if (distance != distance2 || numberElements <= clusters.elementAt(cluster).size()) continue;
                    numberElements = clusters.elementAt(cluster).size() + 1;
                    nearestCluster = cluster;
                    distance = distance2;
                }
                clusters.elementAt(nearestCluster).add(point);
            }
            oldMedoids = this.medoids;
            this.updateMedoids(dmat, clusters);
            medoidModified = this.isMedoidModified(oldMedoids);
        }
        return clusters;
    }

    public int[] getMedoids() {
        return this.medoids;
    }

    private void updateMedoids(DistanceMatrix dmat, Vector<Vector<Integer>> clusters) {
        for (int cluster = 0; cluster < clusters.size(); ++cluster) {
            int medoid = clusters.elementAt(cluster).elementAt(0);
            float sumDistances = dmat.getMaxDistance();
            for (int point = 0; point < clusters.elementAt(cluster).size(); ++point) {
                float sumDistances2 = 0.0f;
                for (int point2 = 0; point2 < clusters.elementAt(cluster).size(); ++point2) {
                    sumDistances2 += dmat.getDistance(clusters.elementAt(cluster).elementAt(point), clusters.elementAt(cluster).elementAt(point2));
                }
                if (!(sumDistances > (sumDistances2 /= (float)clusters.elementAt(cluster).size()))) continue;
                sumDistances = sumDistances2;
                medoid = clusters.elementAt(cluster).elementAt(point);
            }
            this.medoids[cluster] = medoid;
        }
    }

    private boolean isMedoidModified(int[] oldMedoids) {
        for (int medoid = 0; medoid < oldMedoids.length; ++medoid) {
            if (oldMedoids[medoid] == this.medoids[medoid]) continue;
            return true;
        }
        return false;
    }
}

