/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import java.util.Arrays;
import java.util.Vector;
import visualizer.projection.GraphBuilderListener;

public class PCA {
    private boolean useSamples = false;
    private float[] eigenvalues;
    private int targetdim = 2;

    public PCA(int targetdim) {
        this.targetdim = targetdim;
    }

    public float[][] project(float[][] points, GraphBuilderListener listener) {
        long start = System.currentTimeMillis();
        if (listener != null) {
            listener.setProjectionStatus("Creating the covariance matrix..", 10);
        }
        double[][] covmatrix_aux = this.createCovarianceMatrix(points);
        long finish = System.currentTimeMillis();
        System.out.println("Creating the covariance matrix: " + (float)(finish - start) / 1000.0f + "s");
        start = System.currentTimeMillis();
        if (listener != null) {
            listener.setProjectionStatus("Decomposing the covariance matrix..", 15);
        }
        DenseDoubleMatrix2D covmatrix = new DenseDoubleMatrix2D(covmatrix_aux);
        EigenvalueDecomposition dec = new EigenvalueDecomposition(covmatrix);
        DoubleMatrix2D decomp = dec.getV();
        finish = System.currentTimeMillis();
        System.out.println("Decomposing the covariance matrix: " + (float)(finish - start) / 1000.0f + "s");
        this.eigenvalues = new float[covmatrix_aux.length];
        DoubleMatrix1D eigenvalues = dec.getRealEigenvalues();
        for (int i = 0; i < covmatrix_aux.length; ++i) {
            this.eigenvalues[i] = (float)eigenvalues.get(covmatrix_aux.length - i - 1);
        }
        start = System.currentTimeMillis();
        if (listener != null) {
            listener.setProjectionStatus("Multiplying..", 20);
        }
        double[][] points_aux2 = new double[points.length][];
        for (int i = 0; i < points.length; ++i) {
            points_aux2[i] = new double[points[i].length];
            for (int j = 0; j < points[i].length; ++j) {
                points_aux2[i][j] = points[i][j];
            }
        }
        double[][] decomp_aux = new double[covmatrix_aux.length][];
        for (int i = 0; i < covmatrix_aux.length; ++i) {
            decomp_aux[i] = new double[this.targetdim];
            for (int j = 0; j < this.targetdim; ++j) {
                decomp_aux[i][j] = decomp.getQuick(i, covmatrix_aux[0].length - j - 1);
            }
        }
        DenseDoubleMatrix2D decompostion = new DenseDoubleMatrix2D(decomp_aux);
        DenseDoubleMatrix2D points_aux = new DenseDoubleMatrix2D(points_aux2);
        DoubleMatrix2D proj = ((DoubleMatrix2D)points_aux).zMult(decompostion, null, 1.0, 1.0, false, false);
        finish = System.currentTimeMillis();
        float[][] projection = new float[points.length][];
        double[][] projection_aux = proj.toArray();
        for (int i = 0; i < projection_aux.length; ++i) {
            projection[i] = new float[this.targetdim];
            for (int j = 0; j < projection_aux[i].length; ++j) {
                projection[i][j] = (float)projection_aux[i][j];
            }
        }
        return projection;
    }

    public void setUseSamples(boolean useSamples) {
        this.useSamples = useSamples;
    }

    public float[] getEigenvalues() {
        return this.eigenvalues;
    }

    private float[][] useSamples(float[][] points) {
        float[][] samples = new float[points.length / 4][];
        Vector<Integer> indexes = new Vector<Integer>();
        int i = 0;
        while (indexes.size() < samples.length) {
            int index = (int)(Math.random() * (double)(points.length - 1));
            if (indexes.contains(index)) continue;
            samples[i] = points[index];
            indexes.add(index);
            ++i;
        }
        return samples;
    }

    private double[][] createCovarianceMatrix(float[][] points) {
        int i;
        int j;
        int i2;
        if (this.useSamples) {
            points = this.useSamples(points);
        }
        double[] mean = new double[points[0].length];
        Arrays.fill(mean, 0.0);
        for (i2 = 0; i2 < points.length; ++i2) {
            for (j = 0; j < points[i2].length; ++j) {
                int n = j;
                mean[n] = mean[n] + (double)points[i2][j];
            }
        }
        i2 = 0;
        while (i2 < mean.length) {
            int n = i2++;
            mean[n] = mean[n] / (double)points.length;
        }
        for (i2 = 0; i2 < points.length; ++i2) {
            for (j = 0; j < points[i2].length; ++j) {
                float[] fArray = points[i2];
                int n = j;
                fArray[n] = (float)((double)fArray[n] - mean[j]);
            }
        }
        double[][] covmatrix = new double[points[0].length][];
        for (i = 0; i < covmatrix.length; ++i) {
            covmatrix[i] = new double[points[0].length];
        }
        for (i = 0; i < covmatrix.length; ++i) {
            for (int j2 = 0; j2 < covmatrix.length; ++j2) {
                covmatrix[i][j2] = this.covariance(points, i, j2);
            }
        }
        return covmatrix;
    }

    private float covariance(float[][] points, int a, int b) {
        float covariance = 0.0f;
        for (int i = 0; i < points.length; ++i) {
            covariance += points[i][a] * points[i][b];
        }
        return covariance /= (float)(points.length - 1);
    }
}

