/*
 * Decompiled with CFR 0.152.
 */
package visualizer.util;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PointsReader {
    private float[][] points;
    private float[] cdata;
    private Vector<String> attributes;

    public PointsReader(String filename) throws IOException {
        Vector points = new Vector();
        this.attributes = new Vector();
        BufferedReader in = null;
        try {
            StringTokenizer t;
            in = new BufferedReader(new FileReader(filename));
            String line = null;
            while ((line = in.readLine()) != null && line.trim().length() > 1) {
                if (line.lastIndexOf(35) != -1) continue;
                t = new StringTokenizer(line, ";");
                while (t.hasMoreTokens()) {
                    String token = t.nextToken();
                    this.attributes.add(token.trim());
                }
                break block10;
            }
            while ((line = in.readLine()) != null && line.trim().length() > 1) {
                if (line.lastIndexOf(35) != -1) continue;
                t = new StringTokenizer(line, ";");
                Vector<Float> point = new Vector<Float>();
                while (t.hasMoreTokens()) {
                    String token = t.nextToken();
                    point.add(Float.valueOf(Float.parseFloat(token)));
                }
                points.add(point);
            }
            this.points = new float[points.size()][];
            this.cdata = new float[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                this.points[i] = new float[((Vector)points.elementAt(i)).size() - 1];
                for (int j = 0; j < ((Vector)points.elementAt(i)).size() - 1; ++j) {
                    this.points[i][j] = ((Float)((Vector)points.elementAt(i)).elementAt(j)).floatValue();
                }
                this.cdata[i] = ((Float)((Vector)points.elementAt(i)).elementAt(((Vector)points.elementAt(i)).size() - 1)).floatValue();
            }
            if (this.points[0].length == this.attributes.size()) {
                this.attributes.remove(this.attributes.lastElement());
            }
        }
        catch (FileNotFoundException e) {
            throw new IOException("File " + filename + " does not exist!");
        }
        catch (IOException e) {
            throw new IOException("Problems reading the file " + filename + " : " + e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public float[][] getPoints() {
        return this.points;
    }

    public float[] getCdata() {
        return this.cdata;
    }

    public Vector<String> getAttributes() {
        return this.attributes;
    }
}

