/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import visualizer.graph.Vertex;
import visualizer.kmx.Document;
import visualizer.kmx.KMXClient;
import visualizer.preprocessing.Preprocessor;
import visualizer.preprocessing.stopwords.StopwordsList;
import visualizer.view.GraphPanel;
import visualizer.view.MessageDialog;
import visualizer.view.ToolConfiguration;
import visualizer.view.TrainningDocumentsSelection;
import visualizer.view.label.CovarianceLabel;

public class KMXClientView
extends JDialog {
    private GraphPanel graphPanel;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JRadioButton classificationRadioButton;
    private JRadioButton clusteringRadioButton;
    private JPanel dataPanel;
    private JButton executeButton;
    private ButtonGroup kmxButtonGroup;
    private JPanel kmxFunctionsPanel;
    private JTextField nrClustersTextField;
    private JLabel serverAddrLabel;
    private JTextField serverAddrTextField;
    private JPanel serverPanel;
    private JLabel serverPortLabel;
    private JTextField serverPortTextField;

    public KMXClientView(GraphPanel graphPanel, Frame parent) {
        super(parent);
        this.graphPanel = graphPanel;
        this.initComponents();
    }

    private void initComponents() {
        this.kmxButtonGroup = new ButtonGroup();
        this.buttonPanel = new JPanel();
        this.executeButton = new JButton();
        this.cancelButton = new JButton();
        this.dataPanel = new JPanel();
        this.kmxFunctionsPanel = new JPanel();
        this.clusteringRadioButton = new JRadioButton();
        this.nrClustersTextField = new JTextField();
        this.classificationRadioButton = new JRadioButton();
        this.serverPanel = new JPanel();
        this.serverAddrLabel = new JLabel();
        this.serverPortLabel = new JLabel();
        this.serverAddrTextField = new JTextField();
        this.serverPortTextField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("KMX Functions");
        this.setModal(true);
        this.executeButton.setText("Execute");
        this.executeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KMXClientView.this.executeButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.executeButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KMXClientView.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.dataPanel.setLayout(new BorderLayout());
        this.kmxFunctionsPanel.setLayout(new GridBagLayout());
        this.kmxFunctionsPanel.setBorder(BorderFactory.createTitledBorder("KMX Functions"));
        this.kmxButtonGroup.add(this.clusteringRadioButton);
        this.clusteringRadioButton.setSelected(true);
        this.clusteringRadioButton.setText("Clustering");
        this.clusteringRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.clusteringRadioButton.setMargin(new Insets(0, 0, 0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.kmxFunctionsPanel.add((Component)this.clusteringRadioButton, gridBagConstraints);
        this.nrClustersTextField.setColumns(5);
        this.nrClustersTextField.setText("2");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.kmxFunctionsPanel.add((Component)this.nrClustersTextField, gridBagConstraints);
        this.kmxButtonGroup.add(this.classificationRadioButton);
        this.classificationRadioButton.setText("Classification (SVM)");
        this.classificationRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.classificationRadioButton.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.kmxFunctionsPanel.add((Component)this.classificationRadioButton, gridBagConstraints);
        this.dataPanel.add((Component)this.kmxFunctionsPanel, "Center");
        this.serverPanel.setLayout(new GridBagLayout());
        this.serverPanel.setBorder(BorderFactory.createTitledBorder("Server Options"));
        this.serverAddrLabel.setText("Server address");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.serverPanel.add((Component)this.serverAddrLabel, gridBagConstraints);
        this.serverPortLabel.setText("Server port");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.serverPanel.add((Component)this.serverPortLabel, gridBagConstraints);
        this.serverAddrTextField.setColumns(15);
        this.serverAddrTextField.setText("143.107.232.165");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.serverPanel.add((Component)this.serverAddrTextField, gridBagConstraints);
        this.serverPortTextField.setColumns(15);
        this.serverPortTextField.setText("7000");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.serverPanel.add((Component)this.serverPortTextField, gridBagConstraints);
        this.dataPanel.add((Component)this.serverPanel, "South");
        this.getContentPane().add((Component)this.dataPanel, "Center");
        this.pack();
    }

    private void executeButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
        if (this.clusteringRadioButton.isSelected()) {
            this.clustering();
        } else if (this.classificationRadioButton.isSelected()) {
            this.classification();
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(true);
        this.dispose();
    }

    private void classification() {
        TrainningDocumentsSelection td = new TrainningDocumentsSelection(this.graphPanel, this.serverAddrTextField.getText().trim(), Integer.parseInt(this.serverPortTextField.getText().trim()));
        this.graphPanel.cleanImage();
        this.graphPanel.validate();
        this.graphPanel.repaint();
    }

    private void clustering() {
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                MessageDialog message = null;
                try {
                    message = new MessageDialog(KMXClientView.this.graphPanel.getProjectionExplorerWeb());
                    message.show("Clustering...");
                    Preprocessor prepoc = new Preprocessor();
                    StopwordsList stp = KMXClientView.this.graphPanel.getStopwordsManager().getStopwordListManager().getStopwordListUsed();
                    float max = ToolConfiguration.getInstance(KMXClientView.this.graphPanel.getProjectionExplorerWeb()).getMax();
                    float min = ToolConfiguration.getInstance(KMXClientView.this.graphPanel.getProjectionExplorerWeb()).getMin();
                    int nrGrams = ToolConfiguration.getInstance(KMXClientView.this.graphPanel.getProjectionExplorerWeb()).getNrGrams();
                    int matrixType = 1;
                    boolean stemming = ToolConfiguration.getInstance(KMXClientView.this.graphPanel.getProjectionExplorerWeb()).isStemming();
                    float[][] points = prepoc.getMatrix(max, min, nrGrams, matrixType, stemming, KMXClientView.this.graphPanel.getGraph().getVertex(), stp);
                    ArrayList<Document> docs = new ArrayList<Document>();
                    for (int i = 0; i < KMXClientView.this.graphPanel.getGraph().getVertex().size(); ++i) {
                        Vertex v = KMXClientView.this.graphPanel.getGraph().getVertex().get(i);
                        StringBuffer terms = new StringBuffer();
                        for (int j = 0; j < points[i].length; ++j) {
                            if (!(points[i][j] > 0.0f)) continue;
                            String ngram = prepoc.getNgrams().get((int)j).ngram.replaceAll("<>", "");
                            int k = 0;
                            while ((float)k < points[i][j]) {
                                terms.append(ngram + " ");
                                ++k;
                            }
                        }
                        docs.add(new Document(i, "-", "-", terms.toString()));
                    }
                    KMXClient kmxc = new KMXClient(KMXClientView.this.serverAddrTextField.getText().trim(), Integer.parseInt(KMXClientView.this.serverPortTextField.getText().trim()));
                    try {
                        int i;
                        int[] clusters = kmxc.clustering(docs, Integer.parseInt(KMXClientView.this.nrClustersTextField.getText()));
                        String scalar = "KMX-Clustering-" + KMXClientView.this.nrClustersTextField.getText();
                        KMXClientView.this.graphPanel.getGraph().addScalarName(scalar);
                        int index = KMXClientView.this.graphPanel.getGraph().getScalarIndex(scalar);
                        for (int i2 = 0; i2 < KMXClientView.this.graphPanel.getGraph().getVertex().size(); ++i2) {
                            Vertex v = KMXClientView.this.graphPanel.getGraph().getVertex().get(i2);
                            v.setScalar(index, clusters[i2]);
                        }
                        KMXClientView.this.graphPanel.getGraph().normalizeScalars(0.0f, 1.0f);
                        KMXClientView.this.graphPanel.refreshScalars(scalar);
                        Vector<Integer> clusts = new Vector<Integer>();
                        for (int i3 = 0; i3 < clusters.length; ++i3) {
                            if (clusts.contains(clusters[i3])) continue;
                            clusts.add(clusters[i3]);
                        }
                        Vector clustVertex = new Vector();
                        for (i = 0; i < clusts.size(); ++i) {
                            clustVertex.add(new Vector());
                        }
                        for (i = 0; i < clusters.length; ++i) {
                            ((Vector)clustVertex.get(clusts.indexOf(clusters[i]))).add(KMXClientView.this.graphPanel.getGraph().getVertex().get(i));
                        }
                        for (i = 0; i < clusts.size(); ++i) {
                            CovarianceLabel label = new CovarianceLabel((Vector)clustVertex.get(i), stp);
                            KMXClientView.this.graphPanel.getLabels().add(label);
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        if (message != null) {
                            message.close();
                        }
                        JOptionPane.showMessageDialog(KMXClientView.this, ex.getMessage(), "Error", 0);
                    }
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                finally {
                    if (message != null) {
                        message.close();
                    }
                }
            }
        };
        t.start();
    }
}

