/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableRowSorter;
import visualizer.graph.Vertex;
import visualizer.kmx.Document;
import visualizer.kmx.KMXClient;
import visualizer.kmx.Klass;
import visualizer.preprocessing.Preprocessor;
import visualizer.preprocessing.stopwords.StopwordsList;
import visualizer.view.GraphPanel;
import visualizer.view.MessageDialog;
import visualizer.view.ToolConfiguration;
import visualizer.view.TrainningDocumentsCellRender;
import visualizer.view.TrainningDocumentsTableModel;
import visualizer.view.label.CovarianceLabel;

public class TrainningDocumentsSelection
extends JPanel {
    private TrainningDocumentsTableModel docsTableModel;
    private GraphPanel graphPanel;
    private String server_address;
    private int server_port;
    private static boolean show_td_message = true;
    private JPanel buttonPanel;
    private JButton closeButton;
    private JLabel docsLabel;
    private JScrollPane docsScrollPane;
    private JTable docsTable;
    private JTextField docsTextField;
    private JButton executeButton;
    private JButton removeButton;

    public TrainningDocumentsSelection(GraphPanel graphPanel, String server_address, int server_port) {
        this.server_address = server_address;
        this.server_port = server_port;
        this.graphPanel = graphPanel;
        this.graphPanel.setTrainDocsSelection(this);
        this.initComponents();
        this.docsTableModel = new TrainningDocumentsTableModel(this.graphPanel);
        this.docsTable.setModel(this.docsTableModel);
        this.docsTable.setDefaultRenderer(Object.class, new TrainningDocumentsCellRender());
        this.docsTable.setRowSorter(new TableRowSorter<TrainningDocumentsTableModel>(this.docsTableModel));
    }

    private void initComponents() {
        this.docsScrollPane = new JScrollPane();
        this.docsTable = new JTable();
        this.buttonPanel = new JPanel();
        this.removeButton = new JButton();
        this.executeButton = new JButton();
        this.closeButton = new JButton();
        this.docsLabel = new JLabel();
        this.docsTextField = new JTextField();
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(10, 100));
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                TrainningDocumentsSelection.this.formComponentResized(evt);
            }
        });
        this.docsScrollPane.setBorder(BorderFactory.createTitledBorder("Trainning Documents"));
        this.docsScrollPane.setViewportView(this.docsTable);
        this.add((Component)this.docsScrollPane, "Center");
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setBorder(BorderFactory.createTitledBorder("Commands"));
        this.removeButton.setText("Remove");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TrainningDocumentsSelection.this.removeButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.buttonPanel.add((Component)this.removeButton, gridBagConstraints);
        this.executeButton.setText("Execute");
        this.executeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TrainningDocumentsSelection.this.executeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.buttonPanel.add((Component)this.executeButton, gridBagConstraints);
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TrainningDocumentsSelection.this.closeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.buttonPanel.add((Component)this.closeButton, gridBagConstraints);
        this.docsLabel.setText("Documents");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.buttonPanel.add((Component)this.docsLabel, gridBagConstraints);
        this.docsTextField.setColumns(3);
        this.docsTextField.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.buttonPanel.add((Component)this.docsTextField, gridBagConstraints);
        this.add((Component)this.buttonPanel, "East");
    }

    private void formComponentResized(ComponentEvent evt) {
        int s_colunm0 = 50;
        int s_colunm2 = 80;
        int s_colunm1 = this.docsScrollPane.getWidth() - (s_colunm0 + s_colunm2 + 30);
        this.docsTable.setAutoResizeMode(0);
        this.docsTable.getColumnModel().getColumn(0).setPreferredWidth(s_colunm0);
        this.docsTable.getColumnModel().getColumn(1).setPreferredWidth(s_colunm1);
        this.docsTable.getColumnModel().getColumn(2).setPreferredWidth(s_colunm2);
        if (show_td_message) {
            JOptionPane.showMessageDialog(this.graphPanel.getProjectionExplorerWeb(), "Click on the projection's points to select\nthe training documents.", "Select the training documents", 1);
            show_td_message = false;
        }
    }

    private void executeButtonActionPerformed(ActionEvent evt) {
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (TrainningDocumentsSelection.this.docsTableModel.getRowCount() < 1) {
                    JOptionPane.showMessageDialog(TrainningDocumentsSelection.this.graphPanel.getProjectionExplorerWeb(), "Training documents must be selected!", "Error", 0);
                    return;
                }
                for (int i = 0; i < TrainningDocumentsSelection.this.docsTableModel.getRowCount(); ++i) {
                    String klass = (String)TrainningDocumentsSelection.this.docsTableModel.getValueAt(i, 2);
                    if (klass.trim().length() >= 1) continue;
                    JOptionPane.showMessageDialog(TrainningDocumentsSelection.this.graphPanel.getProjectionExplorerWeb(), "A class label must be assigned to all documents!", "Error", 0);
                    return;
                }
                MessageDialog message = null;
                try {
                    message = new MessageDialog(TrainningDocumentsSelection.this.graphPanel.getProjectionExplorerWeb());
                    message.show("Classifying...");
                    Preprocessor prepoc = new Preprocessor();
                    StopwordsList stp = TrainningDocumentsSelection.this.graphPanel.getStopwordsManager().getStopwordListManager().getStopwordListUsed();
                    float max = ToolConfiguration.getInstance(TrainningDocumentsSelection.this.graphPanel.getProjectionExplorerWeb()).getMax();
                    float min = ToolConfiguration.getInstance(TrainningDocumentsSelection.this.graphPanel.getProjectionExplorerWeb()).getMin();
                    int nrGrams = ToolConfiguration.getInstance(TrainningDocumentsSelection.this.graphPanel.getProjectionExplorerWeb()).getNrGrams();
                    int matrixType = 1;
                    boolean stemming = ToolConfiguration.getInstance(TrainningDocumentsSelection.this.graphPanel.getProjectionExplorerWeb()).isStemming();
                    float[][] points = prepoc.getMatrix(max, min, nrGrams, matrixType, stemming, TrainningDocumentsSelection.this.graphPanel.getGraph().getVertex(), stp);
                    ArrayList<Document> docs = new ArrayList<Document>();
                    for (int i = 0; i < TrainningDocumentsSelection.this.graphPanel.getGraph().getVertex().size(); ++i) {
                        Vertex v = TrainningDocumentsSelection.this.graphPanel.getGraph().getVertex().get(i);
                        StringBuffer terms = new StringBuffer();
                        for (int j = 0; j < points[i].length; ++j) {
                            if (!(points[i][j] > 0.0f)) continue;
                            String ngram = prepoc.getNgrams().get((int)j).ngram.replaceAll("<>", "");
                            int k = 0;
                            while ((float)k < points[i][j]) {
                                terms.append(ngram + " ");
                                ++k;
                            }
                        }
                        docs.add(new Document(i, "-", "-", terms.toString()));
                    }
                    ArrayList<Klass> classif = new ArrayList<Klass>();
                    for (int i = 0; i < TrainningDocumentsSelection.this.docsTableModel.getRowCount(); ++i) {
                        long id = (Long)TrainningDocumentsSelection.this.docsTableModel.getValueAt(i, 0);
                        String klass = (String)TrainningDocumentsSelection.this.docsTableModel.getValueAt(i, 2);
                        classif.add(new Klass(id, klass));
                    }
                    try {
                        int i;
                        KMXClient kmxc = new KMXClient(TrainningDocumentsSelection.this.server_address, TrainningDocumentsSelection.this.server_port);
                        int[] classification = kmxc.classification(docs, classif);
                        String scalar = "KMX-Classification-" + classif.size();
                        TrainningDocumentsSelection.this.graphPanel.getGraph().addScalarName(scalar);
                        int index = TrainningDocumentsSelection.this.graphPanel.getGraph().getScalarIndex(scalar);
                        for (int i2 = 0; i2 < TrainningDocumentsSelection.this.graphPanel.getGraph().getVertex().size(); ++i2) {
                            Vertex v = TrainningDocumentsSelection.this.graphPanel.getGraph().getVertex().get(i2);
                            v.setScalar(index, classification[i2]);
                        }
                        TrainningDocumentsSelection.this.graphPanel.getGraph().normalizeScalars(0.0f, 1.0f);
                        TrainningDocumentsSelection.this.graphPanel.refreshScalars(scalar);
                        Vector<Integer> clusts = new Vector<Integer>();
                        for (int i3 = 0; i3 < classification.length; ++i3) {
                            if (clusts.contains(classification[i3])) continue;
                            clusts.add(classification[i3]);
                        }
                        Vector clustVertex = new Vector();
                        for (i = 0; i < clusts.size(); ++i) {
                            clustVertex.add(new Vector());
                        }
                        for (i = 0; i < classification.length; ++i) {
                            ((Vector)clustVertex.get(clusts.indexOf(classification[i]))).add(TrainningDocumentsSelection.this.graphPanel.getGraph().getVertex().get(i));
                        }
                        for (i = 0; i < clusts.size(); ++i) {
                            CovarianceLabel label = new CovarianceLabel((Vector)clustVertex.get(i), stp);
                            TrainningDocumentsSelection.this.graphPanel.getLabels().add(label);
                        }
                    }
                    catch (IOException ex) {
                        if (message != null) {
                            message.close();
                        }
                        JOptionPane.showMessageDialog(TrainningDocumentsSelection.this.graphPanel.getProjectionExplorerWeb(), ex.getMessage(), "Error", 0);
                    }
                }
                catch (NumberFormatException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                finally {
                    if (message != null) {
                        message.close();
                    }
                }
            }
        };
        t.start();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int[] selRows = this.docsTable.getSelectedRows();
        for (int i = selRows.length - 1; i >= 0; --i) {
            int modelRow = this.docsTable.convertRowIndexToModel(selRows[i]);
            Vertex v = this.docsTableModel.removeRow(modelRow);
            v.setTrainningDocument(false);
        }
        this.docsTextField.setText(Integer.toString(this.docsTableModel.getRowCount()));
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        for (Vertex v : this.graphPanel.getGraph().getVertex()) {
            v.setTrainningDocument(false);
        }
        this.graphPanel.setTrainDocsSelection(null);
        this.graphPanel.cleanImage();
        this.graphPanel.validate();
        this.graphPanel.repaint();
    }

    public void addVertex(Vertex v) {
        boolean add = true;
        for (int i = 0; i < this.docsTableModel.getRowCount(); ++i) {
            if (Long.valueOf(v.getId()) != this.docsTableModel.getValueAt(i, 0)) continue;
            add = false;
            break;
        }
        if (add) {
            v.setTrainningDocument(true);
            this.docsTableModel.addRow(v, Integer.toString((int)v.getWebElement().getScalar()));
            this.docsTextField.setText(Integer.toString(this.docsTableModel.getRowCount()));
        }
    }
}

