/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view.color;

import java.awt.Color;

public abstract class ColorScale {
    private static float min = 0.0f;
    private static float max = 1.0f;
    private static boolean reverse = false;
    protected Color[] colors;

    public abstract String getName();

    public Color getColor(float value) {
        int index;
        float maxlength = (float)((this.colors.length - 1) / 2) + max * (float)((this.colors.length - 1) / 2);
        float minlength = min * (float)((this.colors.length - 1) / 2);
        if (reverse) {
            value = 1.0f - value;
            maxlength = (float)((this.colors.length - 1) / 2) + (1.0f - min) * (float)((this.colors.length - 1) / 2);
            minlength = (1.0f - max) * (float)((this.colors.length - 1) / 2);
        }
        return this.colors.length >= (index = (int)(value * (maxlength - minlength) + minlength)) ? this.colors[index] : this.colors[this.colors.length - 1];
    }

    public int getNumberColors() {
        return this.colors.length;
    }

    public float getMin() {
        return min;
    }

    public void setMin(float min) {
        ColorScale.min = min;
    }

    public float getMax() {
        return max;
    }

    public void setMax(float max) {
        ColorScale.max = max;
    }

    public boolean isReverse() {
        return reverse;
    }

    public void setReverse(boolean reverse) {
        ColorScale.reverse = reverse;
    }
}

