/*
 * Decompiled with CFR 0.152.
 */
package visualizer.view.label;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class StringBox {
    private String msg = "";

    public StringBox(String msg) {
        this.msg = msg;
    }

    public Rectangle draw(Graphics g, Point position, Font font, boolean selected) {
        Graphics2D g2 = (Graphics2D)g;
        g.setFont(font);
        FontMetrics metrics = g.getFontMetrics(g.getFont());
        int width = metrics.stringWidth(this.msg);
        int height = metrics.getAscent();
        Rectangle rectangle = new Rectangle(position.x - 2, position.y - 2, width + 4, height + 4);
        if (selected) {
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g2.setPaint(Color.BLUE);
        } else {
            g2.setComposite(AlphaComposite.getInstance(3, 0.65f));
            g2.setPaint(new Color(255, 255, 204));
        }
        g.drawRect(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
        g2.fill(rectangle);
        if (selected) {
            g2.setPaint(Color.WHITE);
        } else {
            g2.setPaint(Color.BLACK);
        }
        g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        g.drawString(this.msg, position.x, position.y + height - 2);
        return rectangle;
    }
}

