/*
 * Decompiled with CFR 0.152.
 */
package visualizer.web.patents;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import visualizer.graph.Graph;
import visualizer.graph.Vertex;
import visualizer.preprocessing.stopwords.StopwordListManager;
import visualizer.projection.GraphBuilder;
import visualizer.projection.GraphBuilderListener;
import visualizer.view.ProjectionExplorerWeb;
import visualizer.view.SearchPanel;
import visualizer.view.ToolConfiguration;
import visualizer.web.WebElement;
import visualizer.web.patents.PatentsGetter;
import visualizer.web.patents.USPTOClass;
import visualizer.web.patents.USPTOTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatentsGetterPanel
extends SearchPanel
implements GraphBuilderListener {
    private USPTOTableModel allPatentsTableModel = new USPTOTableModel();
    private USPTOTableModel popularPatentsTableModel = new USPTOTableModel();
    private JScrollPane allPatentsScrollPane;
    private JTable allPatentsTable;
    private JPanel buttonPanel;
    private JButton downloadButton;
    private JPanel patentsPanel;
    private JScrollPane popularPatentsScrollPane;
    private JTable popularPatentsTable;
    private JLabel statusLabel;
    private JPanel statusPanel;
    private JProgressBar statusProgressBar;
    private JPanel tablePanel;

    public PatentsGetterPanel(ProjectionExplorerWeb view) {
        super(view);
        this.initComponents();
        this.initTableModel();
    }

    private void initComponents() {
        this.patentsPanel = new JPanel();
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.statusProgressBar = new JProgressBar();
        this.tablePanel = new JPanel();
        this.popularPatentsScrollPane = new JScrollPane();
        this.popularPatentsTable = new JTable(this.popularPatentsTableModel);
        this.allPatentsScrollPane = new JScrollPane();
        this.allPatentsTable = new JTable(this.allPatentsTableModel);
        this.buttonPanel = new JPanel();
        this.downloadButton = new JButton();
        this.setLayout(new BorderLayout());
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                PatentsGetterPanel.this.formComponentResized(evt);
            }
        });
        this.patentsPanel.setLayout(new BorderLayout());
        this.statusPanel.setLayout(new BorderLayout());
        this.statusPanel.setBorder(BorderFactory.createTitledBorder("Status"));
        this.statusLabel.setText("status");
        this.statusPanel.add((Component)this.statusLabel, "North");
        this.statusPanel.add((Component)this.statusProgressBar, "Center");
        this.patentsPanel.add((Component)this.statusPanel, "South");
        this.tablePanel.setLayout(new GridLayout(2, 1));
        this.popularPatentsScrollPane.setBorder(BorderFactory.createTitledBorder("Popular US Patent RSS Feeds"));
        this.popularPatentsScrollPane.setViewportView(this.popularPatentsTable);
        this.tablePanel.add(this.popularPatentsScrollPane);
        this.allPatentsScrollPane.setBorder(BorderFactory.createTitledBorder("Complete List of all RSS Feeds by Class"));
        this.allPatentsScrollPane.setViewportView(this.allPatentsTable);
        this.tablePanel.add(this.allPatentsScrollPane);
        this.patentsPanel.add((Component)this.tablePanel, "Center");
        this.add((Component)this.patentsPanel, "Center");
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.downloadButton.setText("Execute");
        this.downloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PatentsGetterPanel.this.downloadButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.downloadButton);
        this.add((Component)this.buttonPanel, "South");
    }

    private void formComponentResized(ComponentEvent evt) {
        int s_colunm0 = 50;
        int s_colunm2 = 70;
        int s_colunm1 = this.allPatentsScrollPane.getWidth() - (s_colunm0 + s_colunm2 + 30);
        this.allPatentsTable.setAutoResizeMode(0);
        this.allPatentsTable.getColumnModel().getColumn(0).setPreferredWidth(s_colunm0);
        DefaultTableCellRenderer render = new DefaultTableCellRenderer();
        render.setHorizontalAlignment(0);
        this.allPatentsTable.getColumnModel().getColumn(0).setCellRenderer(render);
        this.allPatentsTable.getColumnModel().getColumn(1).setPreferredWidth(s_colunm1);
        this.allPatentsTable.getColumnModel().getColumn(2).setPreferredWidth(s_colunm2);
        s_colunm0 = 50;
        s_colunm2 = 70;
        s_colunm1 = this.popularPatentsScrollPane.getWidth() - (s_colunm0 + s_colunm2 + 30);
        this.popularPatentsTable.setAutoResizeMode(0);
        this.popularPatentsTable.getColumnModel().getColumn(0).setPreferredWidth(s_colunm0);
        render = new DefaultTableCellRenderer();
        render.setHorizontalAlignment(0);
        this.popularPatentsTable.getColumnModel().getColumn(0).setCellRenderer(render);
        this.popularPatentsTable.getColumnModel().getColumn(1).setPreferredWidth(s_colunm1);
        this.popularPatentsTable.getColumnModel().getColumn(2).setPreferredWidth(s_colunm2);
    }

    private void downloadButtonActionPerformed(ActionEvent evt) {
        Vector<USPTOClass> classes = this.allPatentsTableModel.getUSPTOClasses();
        classes.addAll(this.popularPatentsTableModel.getUSPTOClasses());
        Vector<USPTOClass> links = new Vector<USPTOClass>();
        for (USPTOClass cl : classes) {
            if (!cl.getSelected().booleanValue() || links.contains(cl)) continue;
            links.add(cl);
        }
        if (classes.size() > 0) {
            this.statusProgressBar.setValue(0);
            this.statusProgressBar.setMaximum(classes.size());
            this.downloadButton.setEnabled(false);
            PatentsGetter getter = new PatentsGetter(links);
            getter.executeDownload(this);
        } else {
            JOptionPane.showMessageDialog(this, "A link of a PATENT source must be selected!", "Error", 0);
        }
    }

    @Override
    public void queryFinished(Vector<WebElement> pages) {
        if (pages.size() > 0) {
            Vector<Vertex> vertex = new Vector<Vertex>();
            for (int i = 0; i < pages.size(); ++i) {
                Vertex v = new Vertex(pages.get(i), i);
                vertex.add(v);
            }
            Graph graph = new Graph();
            graph.setVertex(vertex);
            StopwordListManager stpManager = new StopwordListManager();
            stpManager.changeStopwordList("English");
            GraphBuilder builder = new GraphBuilder(graph, stpManager);
            ToolConfiguration tool = ToolConfiguration.getInstance(this.view);
            builder.setFractionDelta(tool.getFracDelta());
            builder.setMatrixType(tool.getMatrixType());
            builder.setMax(tool.getMax());
            builder.setMin(tool.getMin());
            builder.setNrConnections(tool.getNrConnections());
            builder.setNrIterations(tool.getNrIterations());
            builder.setNrNeighbors(tool.getNrNeighbors());
            builder.setNumberGrams(tool.getNrGrams());
            builder.setStemming(tool.isStemming());
            builder.setReducting(tool.isReducing());
            builder.setTargetReduction(tool.getDimensions());
            builder.start(this);
        } else {
            this.statusProgressBar.setValue(0);
            this.downloadButton.setEnabled(true);
            JOptionPane.showMessageDialog(this, "None patents were retrieved.\nMore patent sources must be selected!", "Error", 0);
        }
    }

    @Override
    public void projectionFinished(Graph graph, StopwordListManager stpListManager) {
        this.view.addProjection(graph, this, stpListManager);
    }

    @Override
    public void setProjectionStatus(String status, int value) {
        this.statusLabel.setText(status);
        this.statusProgressBar.setValue(value);
    }

    @Override
    public void setQueryStatus(String status, int value) {
        this.statusLabel.setText(status);
        this.statusProgressBar.setValue(value);
    }

    @Override
    public String getQuery() {
        return new String("Patents source");
    }

    public void initTableModel() {
        this.allPatentsTableModel.addRow(new USPTOClass("002", "Apparel", "http://www.freepatentsonline.com/rssfeed/rsspat002.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("004", "Baths, closets, sinks, and spittoons", "http://www.freepatentsonline.com/rssfeed/rsspat004.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("005", "Beds", "http://www.freepatentsonline.com/rssfeed/rsspat005.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("007", "Compound tools", "http://www.freepatentsonline.com/rssfeed/rsspat007.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("008", "Bleaching and dyeing; fluid treatment and chemical modification of textiles and fibers", "http://www.freepatentsonline.com/rssfeed/rsspat008.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("012", "Boot and shoe making", "http://www.freepatentsonline.com/rssfeed/rsspat012.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("014", "Bridges", "http://www.freepatentsonline.com/rssfeed/rsspat014.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("015", "Brushing, scrubbing, and general cleaning", "http://www.freepatentsonline.com/rssfeed/rsspat015.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("016", "Miscellaneous hardware", "http://www.freepatentsonline.com/rssfeed/rsspat016.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("019", "Textiles: fiber preparation", "http://www.freepatentsonline.com/rssfeed/rsspat019.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("023", "Chemistry: physical processes", "http://www.freepatentsonline.com/rssfeed/rsspat023.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("024", "Buckles, buttons, clasps, etc.", "http://www.freepatentsonline.com/rssfeed/rsspat024.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("026", "Textiles: cloth finishing", "http://www.freepatentsonline.com/rssfeed/rsspat026.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("027", "Undertaking", "http://www.freepatentsonline.com/rssfeed/rsspat027.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("028", "Textiles: manufacturing", "http://www.freepatentsonline.com/rssfeed/rsspat028.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("029", "Metal working", "http://www.freepatentsonline.com/rssfeed/rsspat029.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("030", "Cutlery", "http://www.freepatentsonline.com/rssfeed/rsspat030.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("033", "Geometrical instruments", "http://www.freepatentsonline.com/rssfeed/rsspat033.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("034", "Drying and gas or vapor contact with solids", "http://www.freepatentsonline.com/rssfeed/rsspat034.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("036", "Boots, shoes, and leggings", "http://www.freepatentsonline.com/rssfeed/rsspat036.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("037", "Excavating", "http://www.freepatentsonline.com/rssfeed/rsspat037.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("038", "Textiles: ironing or smoothing", "http://www.freepatentsonline.com/rssfeed/rsspat038.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("040", "Card, picture, or sign exhibiting", "http://www.freepatentsonline.com/rssfeed/rsspat040.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("042", "Firearms", "http://www.freepatentsonline.com/rssfeed/rsspat042.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("043", "Fishing, trapping, and vermin destroying", "http://www.freepatentsonline.com/rssfeed/rsspat043.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("044", "Fuel and related compositions", "http://www.freepatentsonline.com/rssfeed/rsspat044.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("047", "Plant husbandry", "http://www.freepatentsonline.com/rssfeed/rsspat047.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("048", "Gas: heating and illuminating", "http://www.freepatentsonline.com/rssfeed/rsspat048.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("049", "Movable or removable closures", "http://www.freepatentsonline.com/rssfeed/rsspat049.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("051", "Abrasive tool making process, material, or composition", "http://www.freepatentsonline.com/rssfeed/rsspat051.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("052", "Static structures (e.g., buildings)", "http://www.freepatentsonline.com/rssfeed/rsspat052.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("053", "Package making", "http://www.freepatentsonline.com/rssfeed/rsspat053.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("054", "Harness for working animal", "http://www.freepatentsonline.com/rssfeed/rsspat054.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("055", "Gas separation", "http://www.freepatentsonline.com/rssfeed/rsspat055.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("056", "Harvesters", "http://www.freepatentsonline.com/rssfeed/rsspat056.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("057", "Textiles: spinning, twisting, and twining", "http://www.freepatentsonline.com/rssfeed/rsspat057.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("059", "Chain, staple, and horseshoe making", "http://www.freepatentsonline.com/rssfeed/rsspat059.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("060", "Power plants", "http://www.freepatentsonline.com/rssfeed/rsspat060.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("062", "Refrigeration", "http://www.freepatentsonline.com/rssfeed/rsspat062.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("063", "Jewelry", "http://www.freepatentsonline.com/rssfeed/rsspat063.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("065", "Glass manufacturing", "http://www.freepatentsonline.com/rssfeed/rsspat065.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("066", "Textiles: knitting", "http://www.freepatentsonline.com/rssfeed/rsspat066.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("068", "Textiles: fluid treating apparatus", "http://www.freepatentsonline.com/rssfeed/rsspat068.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("069", "Leather manufactures", "http://www.freepatentsonline.com/rssfeed/rsspat069.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("070", "Locks", "http://www.freepatentsonline.com/rssfeed/rsspat070.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("071", "Chemistry: fertilizers", "http://www.freepatentsonline.com/rssfeed/rsspat071.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("072", "Metal deforming", "http://www.freepatentsonline.com/rssfeed/rsspat072.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("073", "Measuring and testing", "http://www.freepatentsonline.com/rssfeed/rsspat073.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("074", "Machine element or mechanism", "http://www.freepatentsonline.com/rssfeed/rsspat074.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("075", "Specialized metallurgical processes, compositions for use therein, consolidated metal powder compositions, and loose metal particulate mixtures", "http://www.freepatentsonline.com/rssfeed/rsspat075.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("076", "Metal tools and implements, making", "http://www.freepatentsonline.com/rssfeed/rsspat076.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("079", "Button making", "http://www.freepatentsonline.com/rssfeed/rsspat079.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("081", "Tools", "http://www.freepatentsonline.com/rssfeed/rsspat081.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("082", "Turning", "http://www.freepatentsonline.com/rssfeed/rsspat082.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("083", "Cutting", "http://www.freepatentsonline.com/rssfeed/rsspat083.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("084", "Music", "http://www.freepatentsonline.com/rssfeed/rsspat084.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("086", "Ammunition and explosive-charge making", "http://www.freepatentsonline.com/rssfeed/rsspat086.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("087", "Textiles: braiding, netting, and lace making", "http://www.freepatentsonline.com/rssfeed/rsspat087.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("089", "Ordnance", "http://www.freepatentsonline.com/rssfeed/rsspat089.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("091", "Motors: expansible chamber type", "http://www.freepatentsonline.com/rssfeed/rsspat091.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("092", "Expansible chamber devices", "http://www.freepatentsonline.com/rssfeed/rsspat092.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("095", "Gas separation: processes", "http://www.freepatentsonline.com/rssfeed/rsspat095.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("096", "Gas separation: apparatus", "http://www.freepatentsonline.com/rssfeed/rsspat096.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("099", "Foods and beverages: apparatus", "http://www.freepatentsonline.com/rssfeed/rsspat099.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("100", "Presses", "http://www.freepatentsonline.com/rssfeed/rsspat100.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("101", "Printing", "http://www.freepatentsonline.com/rssfeed/rsspat101.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("102", "Ammunition and explosives", "http://www.freepatentsonline.com/rssfeed/rsspat102.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("104", "Railways", "http://www.freepatentsonline.com/rssfeed/rsspat104.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("105", "Railway rolling stock", "http://www.freepatentsonline.com/rssfeed/rsspat105.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("106", "Compositions: coating or plastic", "http://www.freepatentsonline.com/rssfeed/rsspat106.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("108", "Horizontally supported planar surfaces", "http://www.freepatentsonline.com/rssfeed/rsspat108.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("109", "Safes, bank protection, or a related device", "http://www.freepatentsonline.com/rssfeed/rsspat109.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("110", "Furnaces", "http://www.freepatentsonline.com/rssfeed/rsspat110.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("111", "Planting", "http://www.freepatentsonline.com/rssfeed/rsspat111.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("112", "Sewing", "http://www.freepatentsonline.com/rssfeed/rsspat112.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("114", "Ships", "http://www.freepatentsonline.com/rssfeed/rsspat114.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("116", "Signals and indicators", "http://www.freepatentsonline.com/rssfeed/rsspat116.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("117", "Single-crystal, oriented-crystal, and epitaxy growth processes; non-coating apparatus therefor", "http://www.freepatentsonline.com/rssfeed/rsspat117.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("118", "Coating apparatus", "http://www.freepatentsonline.com/rssfeed/rsspat118.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("119", "Animal husbandry", "http://www.freepatentsonline.com/rssfeed/rsspat119.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("122", "Liquid heaters and vaporizers", "http://www.freepatentsonline.com/rssfeed/rsspat122.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("123", "Internal-combustion engines", "http://www.freepatentsonline.com/rssfeed/rsspat123.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("124", "Mechanical guns and projectors", "http://www.freepatentsonline.com/rssfeed/rsspat124.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("125", "Stone working", "http://www.freepatentsonline.com/rssfeed/rsspat125.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("126", "Stoves and furnaces", "http://www.freepatentsonline.com/rssfeed/rsspat126.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("127", "Sugar, starch, and carbohydrates", "http://www.freepatentsonline.com/rssfeed/rsspat127.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("128", "Surgery", "http://www.freepatentsonline.com/rssfeed/rsspat128.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("131", "Tobacco", "http://www.freepatentsonline.com/rssfeed/rsspat131.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("132", "Toilet", "http://www.freepatentsonline.com/rssfeed/rsspat132.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("134", "Cleaning and liquid contact with solids", "http://www.freepatentsonline.com/rssfeed/rsspat134.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("135", "Tent, canopy, umbrella, or cane", "http://www.freepatentsonline.com/rssfeed/rsspat135.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("136", "Batteries: thermoelectric and photoelectric", "http://www.freepatentsonline.com/rssfeed/rsspat136.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("137", "Fluid handling", "http://www.freepatentsonline.com/rssfeed/rsspat137.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("138", "Pipes and tubular conduits", "http://www.freepatentsonline.com/rssfeed/rsspat138.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("139", "Textiles: weaving", "http://www.freepatentsonline.com/rssfeed/rsspat139.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("140", "Wireworking", "http://www.freepatentsonline.com/rssfeed/rsspat140.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("141", "Fluent material handling, with receiver or receiver coacting means", "http://www.freepatentsonline.com/rssfeed/rsspat141.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("142", "Wood turning", "http://www.freepatentsonline.com/rssfeed/rsspat142.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("144", "Woodworking", "http://www.freepatentsonline.com/rssfeed/rsspat144.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("147", "Coopering", "http://www.freepatentsonline.com/rssfeed/rsspat147.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("148", "Metal treatment", "http://www.freepatentsonline.com/rssfeed/rsspat148.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("149", "Explosive and thermic compositions or charges", "http://www.freepatentsonline.com/rssfeed/rsspat149.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("150", "Purses, wallets, and protective covers", "http://www.freepatentsonline.com/rssfeed/rsspat150.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("152", "Resilient tires and wheels", "http://www.freepatentsonline.com/rssfeed/rsspat152.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("156", "Adhesive bonding and miscellaneous chemical manufacture", "http://www.freepatentsonline.com/rssfeed/rsspat156.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("157", "Wheelwright machines", "http://www.freepatentsonline.com/rssfeed/rsspat157.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("159", "Concentrating evaporators", "http://www.freepatentsonline.com/rssfeed/rsspat159.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("160", "Flexible or portable closure, partition, or panel", "http://www.freepatentsonline.com/rssfeed/rsspat160.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("162", "Paper making and fiber liberation", "http://www.freepatentsonline.com/rssfeed/rsspat162.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("163", "Needle and pin making", "http://www.freepatentsonline.com/rssfeed/rsspat163.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("164", "Metal founding", "http://www.freepatentsonline.com/rssfeed/rsspat164.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("165", "Heat exchange", "http://www.freepatentsonline.com/rssfeed/rsspat165.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("166", "Wells", "http://www.freepatentsonline.com/rssfeed/rsspat166.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("168", "Farriery", "http://www.freepatentsonline.com/rssfeed/rsspat168.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("169", "Fire extinguishers", "http://www.freepatentsonline.com/rssfeed/rsspat169.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("171", "Unearthing plants or buried objects", "http://www.freepatentsonline.com/rssfeed/rsspat171.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("172", "Earth working", "http://www.freepatentsonline.com/rssfeed/rsspat172.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("173", "Tool driving or impacting", "http://www.freepatentsonline.com/rssfeed/rsspat173.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("174", "Electricity: conductors and insulators", "http://www.freepatentsonline.com/rssfeed/rsspat174.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("175", "Boring or penetrating the earth", "http://www.freepatentsonline.com/rssfeed/rsspat175.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("177", "Weighing scales", "http://www.freepatentsonline.com/rssfeed/rsspat177.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("178", "Telegraphy", "http://www.freepatentsonline.com/rssfeed/rsspat178.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("180", "Motor vehicles", "http://www.freepatentsonline.com/rssfeed/rsspat180.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("181", "Acoustics", "http://www.freepatentsonline.com/rssfeed/rsspat181.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("182", "Fire escape, ladder, or scaffold", "http://www.freepatentsonline.com/rssfeed/rsspat182.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("184", "Lubrication", "http://www.freepatentsonline.com/rssfeed/rsspat184.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("185", "Motors: spring, weight, or animal powered", "http://www.freepatentsonline.com/rssfeed/rsspat185.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("186", "Merchandising", "http://www.freepatentsonline.com/rssfeed/rsspat186.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("187", "Elevator, industrial lift truck, or stationary lift for vehicle", "http://www.freepatentsonline.com/rssfeed/rsspat187.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("188", "Brakes", "http://www.freepatentsonline.com/rssfeed/rsspat188.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("190", "Trunks and hand-carried luggage", "http://www.freepatentsonline.com/rssfeed/rsspat190.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("191", "Electricity: transmission to vehicles", "http://www.freepatentsonline.com/rssfeed/rsspat191.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("192", "Clutches and power-stop control", "http://www.freepatentsonline.com/rssfeed/rsspat192.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("193", "Conveyors, chutes, skids, guides, and ways", "http://www.freepatentsonline.com/rssfeed/rsspat193.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("194", "Check-actuated control mechanisms", "http://www.freepatentsonline.com/rssfeed/rsspat194.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("196", "Mineral oils: apparatus", "http://www.freepatentsonline.com/rssfeed/rsspat196.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("198", "Conveyors: power-driven", "http://www.freepatentsonline.com/rssfeed/rsspat198.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("199", "Type casting", "http://www.freepatentsonline.com/rssfeed/rsspat199.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("200", "Electricity: circuit makers and breakers", "http://www.freepatentsonline.com/rssfeed/rsspat200.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("201", "Distillation: processes, thermolytic", "http://www.freepatentsonline.com/rssfeed/rsspat201.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("202", "Distillation: apparatus", "http://www.freepatentsonline.com/rssfeed/rsspat202.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("203", "Distillation: processes, separatory", "http://www.freepatentsonline.com/rssfeed/rsspat203.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("204", "Chemistry: electrical and wave energy", "http://www.freepatentsonline.com/rssfeed/rsspat204.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("205", "Electrolysis: processes, compositions used therein, and methods of preparing the compositions", "http://www.freepatentsonline.com/rssfeed/rsspat205.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("206", "Special receptacle or package", "http://www.freepatentsonline.com/rssfeed/rsspat206.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("208", "Mineral oils: processes and products", "http://www.freepatentsonline.com/rssfeed/rsspat208.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("209", "Classifying, separating, and assorting solids", "http://www.freepatentsonline.com/rssfeed/rsspat209.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("210", "Liquid purification or separation", "http://www.freepatentsonline.com/rssfeed/rsspat210.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("211", "Supports: racks", "http://www.freepatentsonline.com/rssfeed/rsspat211.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("212", "Traversing hoists", "http://www.freepatentsonline.com/rssfeed/rsspat212.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("213", "Railway draft appliances", "http://www.freepatentsonline.com/rssfeed/rsspat213.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("215", "Bottles and jars", "http://www.freepatentsonline.com/rssfeed/rsspat215.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("216", "Etching a substrate: processes", "http://www.freepatentsonline.com/rssfeed/rsspat216.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("217", "Wooden receptacles", "http://www.freepatentsonline.com/rssfeed/rsspat217.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("218", "High-voltage switches with arc preventing or extinguishing devices", "http://www.freepatentsonline.com/rssfeed/rsspat218.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("219", "Electric heating", "http://www.freepatentsonline.com/rssfeed/rsspat219.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("220", "Receptacles", "http://www.freepatentsonline.com/rssfeed/rsspat220.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("221", "Article dispensing", "http://www.freepatentsonline.com/rssfeed/rsspat221.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("222", "Dispensing", "http://www.freepatentsonline.com/rssfeed/rsspat222.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("223", "Apparel apparatus", "http://www.freepatentsonline.com/rssfeed/rsspat223.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("224", "Package and article carriers", "http://www.freepatentsonline.com/rssfeed/rsspat224.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("225", "Severing by tearing or breaking", "http://www.freepatentsonline.com/rssfeed/rsspat225.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("226", "Advancing material of indeterminate length", "http://www.freepatentsonline.com/rssfeed/rsspat226.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("227", "Elongated-member-driving apparatus", "http://www.freepatentsonline.com/rssfeed/rsspat227.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("228", "Metal fusion bonding", "http://www.freepatentsonline.com/rssfeed/rsspat228.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("229", "Envelopes, wrappers, and paperboard boxes", "http://www.freepatentsonline.com/rssfeed/rsspat229.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("231", "Whips and whip apparatus", "http://www.freepatentsonline.com/rssfeed/rsspat231.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("232", "Deposit and collection receptacles", "http://www.freepatentsonline.com/rssfeed/rsspat232.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("234", "Selective cutting (e.g., punching)", "http://www.freepatentsonline.com/rssfeed/rsspat234.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("235", "Registers", "http://www.freepatentsonline.com/rssfeed/rsspat235.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("236", "Automatic temperature and humidity regulation", "http://www.freepatentsonline.com/rssfeed/rsspat236.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("237", "Heating systems", "http://www.freepatentsonline.com/rssfeed/rsspat237.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("238", "Railways: surface track", "http://www.freepatentsonline.com/rssfeed/rsspat238.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("239", "Fluid sprinkling, spraying, and diffusing", "http://www.freepatentsonline.com/rssfeed/rsspat239.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("241", "Solid material comminution or disintegration", "http://www.freepatentsonline.com/rssfeed/rsspat241.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("242", "Winding, tensioning, or guiding", "http://www.freepatentsonline.com/rssfeed/rsspat242.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("244", "Aeronautics", "http://www.freepatentsonline.com/rssfeed/rsspat244.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("245", "Wire fabrics and structure", "http://www.freepatentsonline.com/rssfeed/rsspat245.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("246", "Railway switches and signals", "http://www.freepatentsonline.com/rssfeed/rsspat246.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("248", "Supports", "http://www.freepatentsonline.com/rssfeed/rsspat248.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("249", "Static molds", "http://www.freepatentsonline.com/rssfeed/rsspat249.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("250", "Radiant energy", "http://www.freepatentsonline.com/rssfeed/rsspat250.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("251", "Valves and valve actuation", "http://www.freepatentsonline.com/rssfeed/rsspat251.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("252", "Compositions", "http://www.freepatentsonline.com/rssfeed/rsspat252.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("254", "Implements or apparatus for applying pushing or pulling force", "http://www.freepatentsonline.com/rssfeed/rsspat254.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("256", "Fences", "http://www.freepatentsonline.com/rssfeed/rsspat256.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("257", "Active solid-state devices (e.g., transistors, solid-state diodes)", "http://www.freepatentsonline.com/rssfeed/rsspat257.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("258", "Railway mail delivery", "http://www.freepatentsonline.com/rssfeed/rsspat258.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("260", "Chemistry of carbon compounds", "http://www.freepatentsonline.com/rssfeed/rsspat260.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("261", "Gas and liquid contact apparatus", "http://www.freepatentsonline.com/rssfeed/rsspat261.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("264", "Plastic and nonmetallic article shaping or treating: processes", "http://www.freepatentsonline.com/rssfeed/rsspat264.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("266", "Metallurgical apparatus", "http://www.freepatentsonline.com/rssfeed/rsspat266.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("267", "Spring devices", "http://www.freepatentsonline.com/rssfeed/rsspat267.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("269", "Work holders", "http://www.freepatentsonline.com/rssfeed/rsspat269.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("270", "Sheet-material associating", "http://www.freepatentsonline.com/rssfeed/rsspat270.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("271", "Sheet feeding or delivering", "http://www.freepatentsonline.com/rssfeed/rsspat271.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("273", "Amusement devices: games", "http://www.freepatentsonline.com/rssfeed/rsspat273.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("276", "Typesetting", "http://www.freepatentsonline.com/rssfeed/rsspat276.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("277", "Seal for a joint or juncture", "http://www.freepatentsonline.com/rssfeed/rsspat277.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("278", "Land vehicles: animal draft appliances", "http://www.freepatentsonline.com/rssfeed/rsspat278.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("279", "Chucks or sockets", "http://www.freepatentsonline.com/rssfeed/rsspat279.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("280", "Land vehicles", "http://www.freepatentsonline.com/rssfeed/rsspat280.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("281", "Books, strips, and leaves", "http://www.freepatentsonline.com/rssfeed/rsspat281.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("283", "Printed matter", "http://www.freepatentsonline.com/rssfeed/rsspat283.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("285", "Pipe joints or couplings", "http://www.freepatentsonline.com/rssfeed/rsspat285.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("289", "Knots and knot tying", "http://www.freepatentsonline.com/rssfeed/rsspat289.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("290", "Prime-mover dynamo plants", "http://www.freepatentsonline.com/rssfeed/rsspat290.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("291", "Track sanders", "http://www.freepatentsonline.com/rssfeed/rsspat291.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("292", "Closure fasteners", "http://www.freepatentsonline.com/rssfeed/rsspat292.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("293", "Vehicle fenders", "http://www.freepatentsonline.com/rssfeed/rsspat293.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("294", "Handling: hand and hoist-line implements", "http://www.freepatentsonline.com/rssfeed/rsspat294.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("295", "Railway wheels and axles", "http://www.freepatentsonline.com/rssfeed/rsspat295.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("296", "Land vehicles: bodies and tops", "http://www.freepatentsonline.com/rssfeed/rsspat296.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("297", "Chairs and seats", "http://www.freepatentsonline.com/rssfeed/rsspat297.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("298", "Land vehicles: dumping", "http://www.freepatentsonline.com/rssfeed/rsspat298.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("299", "Mining or in situ disintegration of hard material", "http://www.freepatentsonline.com/rssfeed/rsspat299.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("300", "Brush, broom, and mop making", "http://www.freepatentsonline.com/rssfeed/rsspat300.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("301", "Land vehicles: wheels and axles", "http://www.freepatentsonline.com/rssfeed/rsspat301.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("303", "Fluid-pressure and analogous brake systems", "http://www.freepatentsonline.com/rssfeed/rsspat303.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("305", "Wheel substitutes for land vehicles", "http://www.freepatentsonline.com/rssfeed/rsspat305.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("307", "Electrical transmission or interconnection systems", "http://www.freepatentsonline.com/rssfeed/rsspat307.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("310", "Electrical generator or motor structure", "http://www.freepatentsonline.com/rssfeed/rsspat310.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("312", "Supports: cabinet structure", "http://www.freepatentsonline.com/rssfeed/rsspat312.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("313", "Electric lamp and discharge devices", "http://www.freepatentsonline.com/rssfeed/rsspat313.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("314", "Electric lamp and discharge devices: consumable electrodes", "http://www.freepatentsonline.com/rssfeed/rsspat314.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("315", "Electric lamp and discharge devices: systems", "http://www.freepatentsonline.com/rssfeed/rsspat315.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("318", "Electricity: motive power systems", "http://www.freepatentsonline.com/rssfeed/rsspat318.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("320", "Electricity: battery or capacitor charging or discharging", "http://www.freepatentsonline.com/rssfeed/rsspat320.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("322", "Electricity: single generator systems", "http://www.freepatentsonline.com/rssfeed/rsspat322.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("323", "Electricity: power supply or regulation systems", "http://www.freepatentsonline.com/rssfeed/rsspat323.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("324", "Electricity: measuring and testing", "http://www.freepatentsonline.com/rssfeed/rsspat324.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("326", "Electronic digital logic circuitry", "http://www.freepatentsonline.com/rssfeed/rsspat326.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("327", "Miscellaneous active electrical nonlinear devices, circuits, and systems", "http://www.freepatentsonline.com/rssfeed/rsspat327.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("329", "Demodulators", "http://www.freepatentsonline.com/rssfeed/rsspat329.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("330", "Amplifiers", "http://www.freepatentsonline.com/rssfeed/rsspat330.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("331", "Oscillators", "http://www.freepatentsonline.com/rssfeed/rsspat331.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("332", "Modulators", "http://www.freepatentsonline.com/rssfeed/rsspat332.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("333", "Wave transmission lines and networks", "http://www.freepatentsonline.com/rssfeed/rsspat333.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("334", "Tuners", "http://www.freepatentsonline.com/rssfeed/rsspat334.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("335", "Electricity: magnetically operated switches, magnets, and electromagnets", "http://www.freepatentsonline.com/rssfeed/rsspat335.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("336", "Inductor devices", "http://www.freepatentsonline.com/rssfeed/rsspat336.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("337", "Electricity: electrothermally or thermally actuated switches", "http://www.freepatentsonline.com/rssfeed/rsspat337.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("338", "Electrical resistors", "http://www.freepatentsonline.com/rssfeed/rsspat338.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("340", "Communications: electrical", "http://www.freepatentsonline.com/rssfeed/rsspat340.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("341", "Coded data generation or conversion", "http://www.freepatentsonline.com/rssfeed/rsspat341.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("342", "Communications: directive radio wave systems and devices (e.g., radar, radio navigation)", "http://www.freepatentsonline.com/rssfeed/rsspat342.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("343", "Communications: radio wave antennas", "http://www.freepatentsonline.com/rssfeed/rsspat343.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("345", "Computer graphics processing and selective visual display systems", "http://www.freepatentsonline.com/rssfeed/rsspat345.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("346", "Recorders", "http://www.freepatentsonline.com/rssfeed/rsspat346.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("347", "Incremental printing of symbolic information", "http://www.freepatentsonline.com/rssfeed/rsspat347.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("348", "Television", "http://www.freepatentsonline.com/rssfeed/rsspat348.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("349", "Liquid crystal cells, elements and systems", "http://www.freepatentsonline.com/rssfeed/rsspat349.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("351", "Optics: eye examining, vision testing and correcting", "http://www.freepatentsonline.com/rssfeed/rsspat351.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("352", "Optics: motion pictures", "http://www.freepatentsonline.com/rssfeed/rsspat352.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("353", "Optics: image projectors", "http://www.freepatentsonline.com/rssfeed/rsspat353.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("355", "Photocopying", "http://www.freepatentsonline.com/rssfeed/rsspat355.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("356", "Optics: measuring and testing", "http://www.freepatentsonline.com/rssfeed/rsspat356.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("358", "Facsimile and static presentation processing", "http://www.freepatentsonline.com/rssfeed/rsspat358.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("359", "Optical: systems and elements", "http://www.freepatentsonline.com/rssfeed/rsspat359.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("360", "Dynamic magnetic information storage or retrieval", "http://www.freepatentsonline.com/rssfeed/rsspat360.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("361", "Electricity: electrical systems and devices", "http://www.freepatentsonline.com/rssfeed/rsspat361.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("362", "Illumination", "http://www.freepatentsonline.com/rssfeed/rsspat362.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("363", "Electric power conversion systems", "http://www.freepatentsonline.com/rssfeed/rsspat363.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("365", "Static information storage and retrieval", "http://www.freepatentsonline.com/rssfeed/rsspat365.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("366", "Agitating", "http://www.freepatentsonline.com/rssfeed/rsspat366.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("367", "Communications, electrical: acoustic wave systems and devices", "http://www.freepatentsonline.com/rssfeed/rsspat367.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("368", "Horology: time measuring systems or devices", "http://www.freepatentsonline.com/rssfeed/rsspat368.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("369", "Dynamic information storage or retrieval", "http://www.freepatentsonline.com/rssfeed/rsspat369.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("370", "Multiplex communications", "http://www.freepatentsonline.com/rssfeed/rsspat370.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("372", "Coherent light generators", "http://www.freepatentsonline.com/rssfeed/rsspat372.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("373", "Industrial electric heating furnaces", "http://www.freepatentsonline.com/rssfeed/rsspat373.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("374", "Thermal measuring and testing", "http://www.freepatentsonline.com/rssfeed/rsspat374.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("375", "Pulse or digital communications", "http://www.freepatentsonline.com/rssfeed/rsspat375.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("376", "Induced nuclear reactions: processes, systems, and elements", "http://www.freepatentsonline.com/rssfeed/rsspat376.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("377", "Electrical pulse counters, pulse dividers, or shift registers: circuits and systems", "http://www.freepatentsonline.com/rssfeed/rsspat377.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("378", "X-ray or gamma ray systems or devices", "http://www.freepatentsonline.com/rssfeed/rsspat378.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("379", "Telephonic communications", "http://www.freepatentsonline.com/rssfeed/rsspat379.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("380", "Cryptography", "http://www.freepatentsonline.com/rssfeed/rsspat380.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("381", "Electrical audio signal processing systems and devices", "http://www.freepatentsonline.com/rssfeed/rsspat381.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("382", "Image analysis", "http://www.freepatentsonline.com/rssfeed/rsspat382.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("383", "Flexible bags", "http://www.freepatentsonline.com/rssfeed/rsspat383.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("384", "Bearings", "http://www.freepatentsonline.com/rssfeed/rsspat384.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("385", "Optical waveguides", "http://www.freepatentsonline.com/rssfeed/rsspat385.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("386", "Television signal processing for dynamic recording or reproducing", "http://www.freepatentsonline.com/rssfeed/rsspat386.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("388", "Electricity: motor control systems", "http://www.freepatentsonline.com/rssfeed/rsspat388.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("392", "Electric resistance heating devices", "http://www.freepatentsonline.com/rssfeed/rsspat392.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("396", "Photography", "http://www.freepatentsonline.com/rssfeed/rsspat396.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("398", "Optical communications", "http://www.freepatentsonline.com/rssfeed/rsspat398.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("399", "Electrophotography", "http://www.freepatentsonline.com/rssfeed/rsspat399.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("400", "Typewriting machines", "http://www.freepatentsonline.com/rssfeed/rsspat400.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("401", "Coating implements with material supply", "http://www.freepatentsonline.com/rssfeed/rsspat401.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("402", "Binder device releasably engaging aperture or notch of sheet", "http://www.freepatentsonline.com/rssfeed/rsspat402.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("403", "Joints and connections", "http://www.freepatentsonline.com/rssfeed/rsspat403.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("404", "Road structure, process, or apparatus", "http://www.freepatentsonline.com/rssfeed/rsspat404.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("405", "Hydraulic and earth engineering", "http://www.freepatentsonline.com/rssfeed/rsspat405.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("406", "Conveyors: fluid current", "http://www.freepatentsonline.com/rssfeed/rsspat406.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("407", "Cutters, for shaping", "http://www.freepatentsonline.com/rssfeed/rsspat407.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("408", "Cutting by use of rotating axially moving tool", "http://www.freepatentsonline.com/rssfeed/rsspat408.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("409", "Gear cutting, milling, or planing", "http://www.freepatentsonline.com/rssfeed/rsspat409.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("410", "Freight accommodation on freight carrier", "http://www.freepatentsonline.com/rssfeed/rsspat410.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("411", "Expanded, threaded, driven, headed, tool-deformed, or locked-threaded fastener", "http://www.freepatentsonline.com/rssfeed/rsspat411.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("412", "Bookbinding: process and apparatus", "http://www.freepatentsonline.com/rssfeed/rsspat412.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("413", "Sheet metal container making", "http://www.freepatentsonline.com/rssfeed/rsspat413.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("414", "Material or article handling", "http://www.freepatentsonline.com/rssfeed/rsspat414.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("415", "Rotary kinetic fluid motors or pumps", "http://www.freepatentsonline.com/rssfeed/rsspat415.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("416", "Fluid reaction surfaces (i.e., impellers)", "http://www.freepatentsonline.com/rssfeed/rsspat416.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("417", "Pumps", "http://www.freepatentsonline.com/rssfeed/rsspat417.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("418", "Rotary expansible chamber devices", "http://www.freepatentsonline.com/rssfeed/rsspat418.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("419", "Powder metallurgy processes", "http://www.freepatentsonline.com/rssfeed/rsspat419.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("420", "Alloys or metallic compositions", "http://www.freepatentsonline.com/rssfeed/rsspat420.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("422", "Chemical apparatus and process disinfecting, deodorizing, preserving, or sterilizing", "http://www.freepatentsonline.com/rssfeed/rsspat422.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("423", "Chemistry of inorganic compounds", "http://www.freepatentsonline.com/rssfeed/rsspat423.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("424", "Drug, bio-affecting and body treating compositions", "http://www.freepatentsonline.com/rssfeed/rsspat424.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("425", "Plastic article or earthenware shaping or treating: apparatus", "http://www.freepatentsonline.com/rssfeed/rsspat425.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("426", "Food or edible material: processes, compositions, and products", "http://www.freepatentsonline.com/rssfeed/rsspat426.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("427", "Coating processes", "http://www.freepatentsonline.com/rssfeed/rsspat427.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("428", "Stock material or miscellaneous articles", "http://www.freepatentsonline.com/rssfeed/rsspat428.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("429", "Chemistry: electrical current producing apparatus, product, and process", "http://www.freepatentsonline.com/rssfeed/rsspat429.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("430", "Radiation imagery chemistry: process, composition, or product thereof", "http://www.freepatentsonline.com/rssfeed/rsspat430.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("431", "Combustion", "http://www.freepatentsonline.com/rssfeed/rsspat431.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("432", "Heating", "http://www.freepatentsonline.com/rssfeed/rsspat432.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("433", "Dentistry", "http://www.freepatentsonline.com/rssfeed/rsspat433.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("434", "Education and demonstration", "http://www.freepatentsonline.com/rssfeed/rsspat434.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("435", "Chemistry: molecular biology and microbiology", "http://www.freepatentsonline.com/rssfeed/rsspat435.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("436", "Chemistry: analytical and immunological testing", "http://www.freepatentsonline.com/rssfeed/rsspat436.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("438", "Semiconductor device manufacturing: process", "http://www.freepatentsonline.com/rssfeed/rsspat438.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("439", "Electrical connectors", "http://www.freepatentsonline.com/rssfeed/rsspat439.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("440", "Marine propulsion", "http://www.freepatentsonline.com/rssfeed/rsspat440.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("441", "Buoys, rafts, and aquatic devices", "http://www.freepatentsonline.com/rssfeed/rsspat441.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("442", "Fabric (woven, knitted, or nonwoven textile or cloth, etc.)", "http://www.freepatentsonline.com/rssfeed/rsspat442.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("445", "Electric lamp or space discharge component or device manufacturing", "http://www.freepatentsonline.com/rssfeed/rsspat445.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("446", "Amusement devices: toys", "http://www.freepatentsonline.com/rssfeed/rsspat446.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("449", "Bee culture", "http://www.freepatentsonline.com/rssfeed/rsspat449.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("450", "Foundation garments", "http://www.freepatentsonline.com/rssfeed/rsspat450.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("451", "Abrading", "http://www.freepatentsonline.com/rssfeed/rsspat451.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("452", "Butchering", "http://www.freepatentsonline.com/rssfeed/rsspat452.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("453", "Coin handling", "http://www.freepatentsonline.com/rssfeed/rsspat453.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("454", "Ventilation", "http://www.freepatentsonline.com/rssfeed/rsspat454.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("455", "Telecommunications", "http://www.freepatentsonline.com/rssfeed/rsspat455.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("460", "Crop threshing or separating", "http://www.freepatentsonline.com/rssfeed/rsspat460.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("462", "Books, strips, and leaves for manifolding", "http://www.freepatentsonline.com/rssfeed/rsspat462.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("463", "Amusement devices: games", "http://www.freepatentsonline.com/rssfeed/rsspat463.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("464", "Rotary shafts, gudgeons, housings, and flexible couplings for rotary shafts", "http://www.freepatentsonline.com/rssfeed/rsspat464.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("470", "Threaded, headed fastener, or washer making: process and apparatus", "http://www.freepatentsonline.com/rssfeed/rsspat470.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("472", "Amusement devices", "http://www.freepatentsonline.com/rssfeed/rsspat472.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("473", "Games using tangible projectile", "http://www.freepatentsonline.com/rssfeed/rsspat473.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("474", "Endless belt power transmission systems or components", "http://www.freepatentsonline.com/rssfeed/rsspat474.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("475", "Planetary gear transmission systems or components", "http://www.freepatentsonline.com/rssfeed/rsspat475.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("476", "Friction gear transmission systems or components", "http://www.freepatentsonline.com/rssfeed/rsspat476.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("477", "Interrelated power delivery controls, including engine control", "http://www.freepatentsonline.com/rssfeed/rsspat477.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("482", "Exercise devices", "http://www.freepatentsonline.com/rssfeed/rsspat482.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("483", "Tool changing", "http://www.freepatentsonline.com/rssfeed/rsspat483.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("492", "Roll or roller", "http://www.freepatentsonline.com/rssfeed/rsspat492.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("493", "Manufacturing container or tube from paper; or other manufacturing from a sheet or web", "http://www.freepatentsonline.com/rssfeed/rsspat493.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("494", "Imperforate bowl: centrifugal separators", "http://www.freepatentsonline.com/rssfeed/rsspat494.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("501", "Compositions: ceramic", "http://www.freepatentsonline.com/rssfeed/rsspat501.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("502", "Catalyst, solid sorbent, or support therefor: product or process of making", "http://www.freepatentsonline.com/rssfeed/rsspat502.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("503", "Record receiver having plural interactive leaves or a colorless color former, method of use, or developer therefor", "http://www.freepatentsonline.com/rssfeed/rsspat503.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("504", "Plant protecting and regulating compositions", "http://www.freepatentsonline.com/rssfeed/rsspat504.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("505", "Superconductor technology: apparatus, material, process", "http://www.freepatentsonline.com/rssfeed/rsspat505.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("507", "Earth boring, well treating, and oil field chemistry", "http://www.freepatentsonline.com/rssfeed/rsspat507.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("508", "Solid anti-friction devices, materials therefor, lubricant or separant compositions for moving solid surfaces, and miscellaneous mineral oil compositions", "http://www.freepatentsonline.com/rssfeed/rsspat508.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("510", "Cleaning compositions for solid surfaces, auxiliary compositions therefor, or processes of preparing the compositions", "http://www.freepatentsonline.com/rssfeed/rsspat510.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("512", "Perfume compositions", "http://www.freepatentsonline.com/rssfeed/rsspat512.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("514", "Drug, bio-affecting and body treating compositions", "http://www.freepatentsonline.com/rssfeed/rsspat514.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("516", "Colloid systems and wetting agents; subcombinations thereof; processes of", "http://www.freepatentsonline.com/rssfeed/rsspat516.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("518", "Chemistry: fischer-tropsch processes; or purification or recovery of products thereof", "http://www.freepatentsonline.com/rssfeed/rsspat518.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("520", "Synthetic resins or natural rubbers -- part of the class 520 series", "http://www.freepatentsonline.com/rssfeed/rsspat520.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("521", "Synthetic resins or natural rubbers -- part of the class 520 series", "http://www.freepatentsonline.com/rssfeed/rsspat521.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("522", "Synthetic resins or natural rubbers -- part of the class 520 series", "http://www.freepatentsonline.com/rssfeed/rsspat522.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("523", "Synthetic resins or natural rubbers -- part of the class 520 series", "http://www.freepatentsonline.com/rssfeed/rsspat523.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("524", "Synthetic resins or natural rubbers -- part of the class 520 series", "http://www.freepatentsonline.com/rssfeed/rsspat524.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("525", "Synthetic resins or natural rubbers -- part of the class 520 series", "http://www.freepatentsonline.com/rssfeed/rsspat525.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("526", "Synthetic resins or natural rubbers -- part of the class 520 series", "http://www.freepatentsonline.com/rssfeed/rsspat526.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("527", "Synthetic resins or natural rubbers -- part of the class 520 series", "http://www.freepatentsonline.com/rssfeed/rsspat527.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("528", "Synthetic resins or natural rubbers -- part of the class 520 series", "http://www.freepatentsonline.com/rssfeed/rsspat528.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("530", "Chemistry: natural resins or derivatives; peptides or proteins; lignins or reaction products thereof", "http://www.freepatentsonline.com/rssfeed/rsspat530.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("532", "Organic compounds -- part of the class 532-570 series", "http://www.freepatentsonline.com/rssfeed/rsspat532.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("534", "Organic compounds -- part of the class 532-570 series", "http://www.freepatentsonline.com/rssfeed/rsspat534.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("536", "Organic compounds -- part of the class 532-570 series", "http://www.freepatentsonline.com/rssfeed/rsspat536.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("540", "Organic compounds -- part of the class 532-570 series", "http://www.freepatentsonline.com/rssfeed/rsspat540.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("544", "Organic compounds -- part of the class 532-570 series", "http://www.freepatentsonline.com/rssfeed/rsspat544.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("546", "Organic compounds -- part of the class 532-570 series", "http://www.freepatentsonline.com/rssfeed/rsspat546.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("548", "Organic compounds -- part of the class 532-570 series", "http://www.freepatentsonline.com/rssfeed/rsspat548.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("549", "Organic compounds -- part of the class 532-570 series", "http://www.freepatentsonline.com/rssfeed/rsspat549.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("552", "Organic compounds -- part of the class 532-570 series", "http://www.freepatentsonline.com/rssfeed/rsspat552.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("554", "Organic compounds -- part of the class 532-570 series", "http://www.freepatentsonline.com/rssfeed/rsspat554.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("556", "Organic compounds -- part of the class 532-570 series", "http://www.freepatentsonline.com/rssfeed/rsspat556.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("558", "Organic compounds -- part of the class 532-570 series", "http://www.freepatentsonline.com/rssfeed/rsspat558.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("560", "Organic compounds -- part of the class 532-570 series", "http://www.freepatentsonline.com/rssfeed/rsspat560.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("562", "Organic compounds -- part of the class 532-570 series", "http://www.freepatentsonline.com/rssfeed/rsspat562.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("564", "Organic compounds -- part of the class 532-570 series", "http://www.freepatentsonline.com/rssfeed/rsspat564.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("568", "Organic compounds -- part of the class 532-570 series", "http://www.freepatentsonline.com/rssfeed/rsspat568.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("570", "Organic compounds -- part of the class 532-570 series", "http://www.freepatentsonline.com/rssfeed/rsspat570.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("585", "Chemistry of hydrocarbon compounds", "http://www.freepatentsonline.com/rssfeed/rsspat585.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("588", "Hazardous or toxic waste destruction or containment", "http://www.freepatentsonline.com/rssfeed/rsspat588.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("600", "Surgery", "http://www.freepatentsonline.com/rssfeed/rsspat600.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("601", "Surgery: kinesitherapy", "http://www.freepatentsonline.com/rssfeed/rsspat601.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("602", "Surgery: splint, brace, or bandage", "http://www.freepatentsonline.com/rssfeed/rsspat602.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("604", "Surgery", "http://www.freepatentsonline.com/rssfeed/rsspat604.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("606", "Surgery", "http://www.freepatentsonline.com/rssfeed/rsspat606.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("607", "Surgery: light, thermal, and electrical application", "http://www.freepatentsonline.com/rssfeed/rsspat607.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("623", "Prosthesis (i.e., artificial body members), parts thereof, or aids and accessories therefor", "http://www.freepatentsonline.com/rssfeed/rsspat623.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("700", "Data processing: generic control systems or specific applications", "http://www.freepatentsonline.com/rssfeed/rsspat700.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("701", "Data processing: vehicles, navigation, and relative location", "http://www.freepatentsonline.com/rssfeed/rsspat701.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("702", "Data processing: measuring, calibrating, or testing", "http://www.freepatentsonline.com/rssfeed/rsspat702.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("703", "Data processing: structural design, modeling, simulation, and emulation", "http://www.freepatentsonline.com/rssfeed/rsspat703.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("704", "Data processing: speech signal processing, linguistics, language translation, and audio compression/decompression", "http://www.freepatentsonline.com/rssfeed/rsspat704.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("705", "Data processing: financial, business practice, management, or cost/price determination", "http://www.freepatentsonline.com/rssfeed/rsspat705.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("706", "Data processing: artificial intelligence", "http://www.freepatentsonline.com/rssfeed/rsspat706.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("707", "Data processing: database and file management or data structures", "http://www.freepatentsonline.com/rssfeed/rsspat707.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("708", "Electrical computers: arithmetic processing and calculating", "http://www.freepatentsonline.com/rssfeed/rsspat708.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("709", "Electrical computers and digital processing systems: multicomputer data transferring", "http://www.freepatentsonline.com/rssfeed/rsspat709.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("710", "Electrical computers and digital data processing systems: input/output", "http://www.freepatentsonline.com/rssfeed/rsspat710.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("711", "Electrical computers and digital processing systems: memory", "http://www.freepatentsonline.com/rssfeed/rsspat711.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("712", "Electrical computers and digital processing systems: processing architectures and instruction processing (e.g., processors)", "http://www.freepatentsonline.com/rssfeed/rsspat712.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("713", "Electrical computers and digital processing systems: support", "http://www.freepatentsonline.com/rssfeed/rsspat713.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("714", "Error detection/correction and fault detection/recovery", "http://www.freepatentsonline.com/rssfeed/rsspat714.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("715", "Data processing: presentation processing of document, operator interface processing, and screen saver display processing", "http://www.freepatentsonline.com/rssfeed/rsspat715.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("716", "Data processing: design and analysis of circuit or semiconductor mask", "http://www.freepatentsonline.com/rssfeed/rsspat716.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("717", "Data processing: software development, installation, and management", "http://www.freepatentsonline.com/rssfeed/rsspat717.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("718", "Electrical computers and digital processing systems: virtual machine task or process management or task management/control", "http://www.freepatentsonline.com/rssfeed/rsspat718.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("719", "Electrical computers and digital processing systems: interprogram communication or interprocess communication (ipc)", "http://www.freepatentsonline.com/rssfeed/rsspat719.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("720", "Dynamic optical information storage or retrieval", "http://www.freepatentsonline.com/rssfeed/rsspat720.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("725", "Interactive video distribution systems", "http://www.freepatentsonline.com/rssfeed/rsspat725.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("800", "Multicellular living organisms and unmodified parts thereof and related processes", "http://www.freepatentsonline.com/rssfeed/rsspat800.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("901", "Robots", "http://www.freepatentsonline.com/rssfeed/rsspat901.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("902", "Electronic funds transfer", "http://www.freepatentsonline.com/rssfeed/rsspat902.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("930", "Peptide or protein sequence", "http://www.freepatentsonline.com/rssfeed/rsspat930.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("968", "Horology", "http://www.freepatentsonline.com/rssfeed/rsspat968.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("976", "Nuclear technology", "http://www.freepatentsonline.com/rssfeed/rsspat976.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("977", "Nanotechnology", "http://www.freepatentsonline.com/rssfeed/rsspat977.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("984", "Musical instruments", "http://www.freepatentsonline.com/rssfeed/rsspat984.xml"));
        this.allPatentsTableModel.addRow(new USPTOClass("987", "Organic compounds containing a bi, sb, as, or p atom or containing a metal atom of the 6th to 8th group of the periodic system", "http://www.freepatentsonline.com/rssfeed/rsspat987.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("345", "Graphic processing", "http://www.freepatentsonline.com/rssfeed/rsspat345.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("710", "I/O Systems", "http://www.freepatentsonline.com/rssfeed/rsspat710.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("712", "CPUs", "http://www.freepatentsonline.com/rssfeed/rsspat712.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("369", "Dynamic Storage", "http://www.freepatentsonline.com/rssfeed/rsspat369.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("365", "Static Storage", "http://www.freepatentsonline.com/rssfeed/rsspat365.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("347", "Printers/Printing", "http://www.freepatentsonline.com/rssfeed/rsspat347.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("705", "Finance", "http://www.freepatentsonline.com/rssfeed/rsspat705.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("706", "Artificial Intelligence", "http://www.freepatentsonline.com/rssfeed/rsspat706.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("707", "Databases", "http://www.freepatentsonline.com/rssfeed/rsspat707.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("717", "Development", "http://www.freepatentsonline.com/rssfeed/rsspat717.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("715", "Documents", "http://www.freepatentsonline.com/rssfeed/rsspat715.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("701", "Navigation and GPS", "http://www.freepatentsonline.com/rssfeed/rsspat701.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("714", "Error Correction", "http://www.freepatentsonline.com/rssfeed/rsspat714.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("455", "Telecommunications", "http://www.freepatentsonline.com/rssfeed/rsspat455.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("340", "Communications", "http://www.freepatentsonline.com/rssfeed/rsspat340.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("341", "Coded", "http://www.freepatentsonline.com/rssfeed/rsspat341.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("342", "Radio", "http://www.freepatentsonline.com/rssfeed/rsspat342.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("343", "Antennas", "http://www.freepatentsonline.com/rssfeed/rsspat343.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("370", "Multiplex", "http://www.freepatentsonline.com/rssfeed/rsspat370.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("375", "Digital", "http://www.freepatentsonline.com/rssfeed/rsspat375.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("128", "Surgery", "http://www.freepatentsonline.com/rssfeed/rsspat128.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("600", "Surgery(2)", "http://www.freepatentsonline.com/rssfeed/rsspat600.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("604", "Surgery(3)", "http://www.freepatentsonline.com/rssfeed/rsspat604.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("424", "Drugs", "http://www.freepatentsonline.com/rssfeed/rsspat424.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("514", "Drugs(2)", "http://www.freepatentsonline.com/rssfeed/rsspat514.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("623", "Prosthesis", "http://www.freepatentsonline.com/rssfeed/rsspat623.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("433", "Dentistry", "http://www.freepatentsonline.com/rssfeed/rsspat433.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("257", "Active Solid-state", "http://www.freepatentsonline.com/rssfeed/rsspat257.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("310", "Generators or Motors", "http://www.freepatentsonline.com/rssfeed/rsspat310.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("324", "Measuring", "http://www.freepatentsonline.com/rssfeed/rsspat324.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("327", "Nonlinear Devices", "http://www.freepatentsonline.com/rssfeed/rsspat327.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("361", "Systems/Devices", "http://www.freepatentsonline.com/rssfeed/rsspat361.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("438", "Semiconductor manufacture", "http://www.freepatentsonline.com/rssfeed/rsspat438.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("381", "Audio Signal Processing", "http://www.freepatentsonline.com/rssfeed/rsspat381.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("362", "Illumination", "http://www.freepatentsonline.com/rssfeed/rsspat362.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("439", "Connectors", "http://www.freepatentsonline.com/rssfeed/rsspat439.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("380", "Cryptography", "http://www.freepatentsonline.com/rssfeed/rsspat380.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("062", "Refrigeration", "http://www.freepatentsonline.com/rssfeed/rsspat062.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("073", "Measuring and Testing", "http://www.freepatentsonline.com/rssfeed/rsspat073.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("248", "Supports", "http://www.freepatentsonline.com/rssfeed/rsspat248.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("427", "Coating process", "http://www.freepatentsonline.com/rssfeed/rsspat427.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("428", "Stock material", "http://www.freepatentsonline.com/rssfeed/rsspat428.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("417", "Pumps", "http://www.freepatentsonline.com/rssfeed/rsspat417.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("060", "Power plants", "http://www.freepatentsonline.com/rssfeed/rsspat060.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("250", "Radiant", "http://www.freepatentsonline.com/rssfeed/rsspat250.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("165", "Heat-exchange", "http://www.freepatentsonline.com/rssfeed/rsspat165.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("429", "Fuel Cells", "http://www.freepatentsonline.com/rssfeed/rsspat429.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("204", "Electrical and Wave", "http://www.freepatentsonline.com/rssfeed/rsspat204.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("435", "Molecular Biology ", "http://www.freepatentsonline.com/rssfeed/rsspat435.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("156", "Adhesive", "http://www.freepatentsonline.com/rssfeed/rsspat156.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("210", "Liquid Purification", "http://www.freepatentsonline.com/rssfeed/rsspat210.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("239", "Fluid diffusion", "http://www.freepatentsonline.com/rssfeed/rsspat239.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("431", "Combustion", "http://www.freepatentsonline.com/rssfeed/rsspat431.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("188", "Brakes", "http://www.freepatentsonline.com/rssfeed/rsspat188.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("192", "Clutches", "http://www.freepatentsonline.com/rssfeed/rsspat192.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("152", "Tires", "http://www.freepatentsonline.com/rssfeed/rsspat152.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("095", "Gas separation", "http://www.freepatentsonline.com/rssfeed/rsspat095.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("348", "Television", "http://www.freepatentsonline.com/rssfeed/rsspat348.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("349", "LCD", "http://www.freepatentsonline.com/rssfeed/rsspat349.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("386", "TV Signal", "http://www.freepatentsonline.com/rssfeed/rsspat386.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("725", "Interactive Video", "http://www.freepatentsonline.com/rssfeed/rsspat725.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("359", "Optical Systems", "http://www.freepatentsonline.com/rssfeed/rsspat359.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("482", "Exercise Devices", "http://www.freepatentsonline.com/rssfeed/rsspat482.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("473", "Games(1)", "http://www.freepatentsonline.com/rssfeed/rsspat473.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("273", "Games(2)", "http://www.freepatentsonline.com/rssfeed/rsspat273.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("426", "Food", "http://www.freepatentsonline.com/rssfeed/rsspat426.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("084", "Music", "http://www.freepatentsonline.com/rssfeed/rsspat084.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("002", "Apparel", "http://www.freepatentsonline.com/rssfeed/rsspat002.xml"));
        this.popularPatentsTableModel.addRow(new USPTOClass("036", "Boots and Shoes", "http://www.freepatentsonline.com/rssfeed/rsspat036.xml"));
    }
}

