/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d.util;

import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import javax.swing.ImageIcon;

public abstract class GraphicsUtils {
    protected GraphicsUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean hasAlpha(Image object) {
        if (object instanceof BufferedImage) {
            object = ((BufferedImage)object).getColorModel();
        } else {
            object = new PixelGrabber((Image)object, 0, 0, 1, 1, false);
            try {
                ((PixelGrabber)object).grabPixels();
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
            object = ((PixelGrabber)object).getColorModel();
        }
        return ((ColorModel)object).hasAlpha();
    }

    public static boolean usesAlpha(Image object) {
        if (object == null) {
            return false;
        }
        if ((object = GraphicsUtils.toBufferedImage((Image)object).getAlphaRaster()) == null) {
            return false;
        }
        object = ((Raster)object).getDataBuffer();
        for (int i = 0; i < ((DataBuffer)object).getSize(); ++i) {
            if (((DataBuffer)object).getElem(i) >= 255) continue;
            return true;
        }
        return false;
    }

    public static BufferedImage toBufferedImage(RenderedImage renderedImage) {
        if (renderedImage instanceof BufferedImage) {
            return (BufferedImage)renderedImage;
        }
        ColorModel colorModel = renderedImage.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(renderedImage.getWidth(), renderedImage.getHeight());
        boolean bl = colorModel.isAlphaPremultiplied();
        Hashtable<String, Object> hashtable = null;
        if (renderedImage.getPropertyNames() != null) {
            hashtable = new Hashtable<String, Object>();
            for (String string : renderedImage.getPropertyNames()) {
                hashtable.put(string, renderedImage.getProperty(string));
            }
        }
        BufferedImage bufferedImage = new BufferedImage(colorModel, writableRaster, bl, hashtable);
        renderedImage.copyData(writableRaster);
        return bufferedImage;
    }

    public static BufferedImage toBufferedImage(Image image) {
        int n;
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean bl = GraphicsUtils.hasAlpha(image);
        Object object = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            n = 1;
            if (bl) {
                n = 3;
            }
            object = ((GraphicsEnvironment)object).getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(image.getWidth(null), image.getHeight(null), n);
        }
        catch (HeadlessException headlessException) {
            object = null;
        }
        if (object == null) {
            n = 1;
            if (bl) {
                n = 2;
            }
            object = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
        }
        Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return object;
    }
}

