/*
 * Decompiled with CFR 0.152.
 */
package de.erichseifert.vectorgraphics2d;

import de.erichseifert.vectorgraphics2d.VectorGraphics2D;
import de.erichseifert.vectorgraphics2d.util.DataUtils;
import de.erichseifert.vectorgraphics2d.util.GraphicsUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;

public class PDFGraphics2D
extends VectorGraphics2D {
    protected static final String FONT_RESOURCE_PREFIX = "F";
    protected static final String IMAGE_RESOURCE_PREFIX = "Im";
    protected static final String TRANSPARENCY_RESOURCE_PREFIX = "T";
    protected static final double MM_IN_UNITS = 2.834645669291339;
    private static final Map<Integer, Integer> a = DataUtils.map(new Integer[]{0, 1, 2}, new Integer[]{0, 1, 2});
    private static final Map<Integer, Integer> b = DataUtils.map(new Integer[]{0, 1, 2}, new Integer[]{0, 1, 2});
    private int c = 1;
    private final Map<Integer, Integer> d = new TreeMap<Integer, Integer>();
    private final Map<Double, String> e = new TreeMap<Double, String>();
    private final Map<BufferedImage, String> f = new LinkedHashMap<BufferedImage, String>();
    private final Map<Font, String> g = new LinkedHashMap<Font, String>();
    private int h;

    public PDFGraphics2D(double d, double d2, double d3, double d4) {
        super(d, d2, d3, d4);
        this.writeHeader();
    }

    protected void writeString(String string, double d, double d2) {
        string = string.replaceAll("\\\\", "\\\\\\\\").replaceAll("\t", "\\\\t").replaceAll("\b", "\\\\b").replaceAll("\f", "\\\\f").replaceAll("\\(", "\\\\(").replaceAll("\\)", "\\\\)");
        float f = this.getFont().getSize2D();
        this.writeln("q BT");
        String string2 = this.getFontResource(this.getFont());
        this.writeln("/", string2, " ", Float.valueOf(f), " Tf");
        this.writeln("1 0 0 -1 ", d, " ", d2, " cm");
        string = string.replaceAll("[\r\n]", "");
        this.writeln("(", string, ") Tj");
        this.writeln("ET Q");
    }

    public void setStroke(Stroke stroke) {
        BasicStroke basicStroke = this.getStroke() instanceof BasicStroke ? (BasicStroke)this.getStroke() : new BasicStroke();
        super.setStroke(stroke);
        if (stroke instanceof BasicStroke) {
            if (((BasicStroke)(stroke = (BasicStroke)stroke)).getLineWidth() != basicStroke.getLineWidth()) {
                this.writeln(Float.valueOf(((BasicStroke)stroke).getLineWidth()), " w");
            }
            if (((BasicStroke)stroke).getLineJoin() != basicStroke.getLineJoin()) {
                this.writeln(b.get(((BasicStroke)stroke).getLineJoin()), " j");
            }
            if (((BasicStroke)stroke).getEndCap() != basicStroke.getEndCap()) {
                this.writeln(a.get(((BasicStroke)stroke).getEndCap()), " J");
            }
            if (!Arrays.equals(((BasicStroke)stroke).getDashArray(), basicStroke.getDashArray()) || ((BasicStroke)stroke).getDashPhase() != basicStroke.getDashPhase()) {
                this.writeln("[", DataUtils.join(" ", ((BasicStroke)stroke).getDashArray()), "] ", Float.valueOf(((BasicStroke)stroke).getDashPhase()), " d");
            }
        }
    }

    protected void writeImage(Image object, int n, int n2, double d, double d2, double d3, double d4) {
        object = GraphicsUtils.toBufferedImage((Image)object);
        object = this.getImageResource((BufferedImage)object);
        this.write("q ");
        AffineTransform affineTransform = this.getTransform();
        if (!affineTransform.isIdentity()) {
            double[] dArray = new double[6];
            affineTransform.getMatrix(dArray);
            this.write(DataUtils.join(" ", dArray), " cm ");
        }
        this.write(d3, " 0 0 ", d4, " ", d, " ", d2, " cm ");
        this.write("1 0 0 -1 0 1 cm ");
        this.write("/", object, " Do ");
        this.writeln("Q");
    }

    public void setColor(Color color) {
        Color color2 = this.getColor();
        if (color != null) {
            double d;
            super.setColor(color);
            if (color2.getAlpha() != color.getAlpha()) {
                d = (double)color.getAlpha() / 255.0;
                String string = this.getTransparencyResource(d);
                this.writeln("/", string, " gs");
            }
            if (color2.getRed() != color.getRed() || color2.getGreen() != color.getGreen() || color2.getBlue() != color.getBlue()) {
                d = (double)color.getRed() / 255.0;
                double d2 = (double)color.getGreen() / 255.0;
                double d3 = (double)color.getBlue() / 255.0;
                this.write(d, " ", d2, " ", d3, " rg ");
                this.writeln(d, " ", d2, " ", d3, " RG");
            }
        }
    }

    public void setClip(Shape shape) {
        if (this.getClip() != null) {
            this.writeln("Q");
        }
        super.setClip(shape);
        if (this.getClip() != null) {
            this.writeln("q");
            this.writeShape(this.getClip());
            this.writeln(" W n");
        }
    }

    protected void writeHeader() {
        Rectangle2D rectangle2D = this.getBounds();
        int n = (int)Math.floor(rectangle2D.getX() * 2.834645669291339);
        int n2 = (int)Math.floor(rectangle2D.getY() * 2.834645669291339);
        int n3 = (int)Math.ceil(rectangle2D.getWidth() * 2.834645669291339);
        int n4 = (int)Math.ceil(rectangle2D.getHeight() * 2.834645669291339);
        this.writeln("%PDF-1.4");
        this.writeObj("Type", "/Catalog", "Pages", "2 0 R");
        this.writeObj("Type", "/Pages", "Kids", "[3 0 R]", "Count", "1");
        this.writeObj("Type", "/Page", "Parent", "2 0 R", "MediaBox", String.format("[%d %d %d %d]", n, n2, n3, n4), "Contents", "4 0 R", "Resources", "6 0 R");
        this.writeln(this.a(this.size()), " 0 obj");
        this.writeDict("Length", "5 0 R");
        this.writeln("stream");
        this.h = this.size();
        this.writeln("q");
        this.writeln(2.834645669291339, " 0 0 ", -2.834645669291339, " 0 ", n4, " cm");
    }

    protected void writeDict(Object ... objectArray) {
        this.writeln("<<");
        for (int i = 0; i < objectArray.length; i += 2) {
            this.writeln("/", objectArray[i], " ", objectArray[i + 1]);
        }
        this.writeln(">>");
    }

    protected int writeObj(Object ... objectArray) {
        int n = this.a(this.size());
        this.writeln(n, " 0 obj");
        this.writeDict(objectArray);
        this.writeln("endobj");
        return n;
    }

    protected int peekObjId() {
        return this.c + 1;
    }

    private int a(int n) {
        this.d.put(this.c, n);
        return this.c++;
    }

    protected String getTransparencyResource(double d) {
        String string = this.e.get(d);
        if (string == null) {
            string = String.format("%s%d", TRANSPARENCY_RESOURCE_PREFIX, this.e.size() + 1);
            this.e.put(d, string);
        }
        return string;
    }

    protected String getImageResource(BufferedImage bufferedImage) {
        String string = this.f.get(bufferedImage);
        if (string == null) {
            string = String.format("%s%d", IMAGE_RESOURCE_PREFIX, this.f.size() + 1);
            this.f.put(bufferedImage, string);
        }
        return string;
    }

    protected String getFontResource(Font font) {
        String string = this.g.get(font);
        if (string == null) {
            string = String.format("%s%d", FONT_RESOURCE_PREFIX, this.g.size() + 1);
            this.g.put(font, string);
        }
        return string;
    }

    protected void writeClosingDraw(Shape shape) {
        this.writeln(" S");
    }

    protected void writeClosingFill(Shape shape) {
        this.writeln(" f");
        if (!(this.getPaint() instanceof Color)) {
            super.writeClosingFill(shape);
        }
    }

    protected void writeShape(Shape object) {
        object = this.getTransform().createTransformedShape((Shape)object).getPathIterator(null);
        double[] dArray = new double[6];
        double[] dArray2 = new double[2];
        int n = 0;
        while (!object.isDone()) {
            if (n > 0) {
                this.write(" ");
            }
            switch (object.currentSegment(dArray)) {
                case 0: {
                    this.write(dArray[0], " ", dArray[1], " m");
                    dArray2[0] = dArray[0];
                    dArray2[1] = dArray[1];
                    break;
                }
                case 1: {
                    this.write(dArray[0], " ", dArray[1], " l");
                    dArray2[0] = dArray[0];
                    dArray2[1] = dArray[1];
                    break;
                }
                case 3: {
                    this.write(dArray[0], " ", dArray[1], " ", dArray[2], " ", dArray[3], " ", dArray[4], " ", dArray[5], " c");
                    dArray2[0] = dArray[4];
                    dArray2[1] = dArray[5];
                    break;
                }
                case 2: {
                    double d = dArray2[0] + 0.6666666666666666 * (dArray[0] - dArray2[0]);
                    double d2 = dArray2[1] + 0.6666666666666666 * (dArray[1] - dArray2[1]);
                    double d3 = dArray[0] + 0.3333333333333333 * (dArray[2] - dArray[0]);
                    double d4 = dArray[1] + 0.3333333333333333 * (dArray[3] - dArray[1]);
                    double d5 = dArray[2];
                    double d6 = dArray[3];
                    this.write(d, " ", d2, " ", d3, " ", d4, " ", d5, " ", d6, " c");
                    dArray2[0] = d5;
                    dArray2[1] = d6;
                    break;
                }
                case 4: {
                    this.write("h");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown path operation.");
                }
            }
            ++n;
            object.next();
        }
    }

    private static String a(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        int n3 = bufferedImage.getSampleModel().getNumBands();
        StringBuffer stringBuffer = new StringBuffer(n * n2 * n3 << 1);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n4 = bufferedImage.getRGB(j, i) & 0xFFFFFF;
                if (n3 >= 3) {
                    String string = String.format("%06x", n4);
                    stringBuffer.append(string);
                    continue;
                }
                if (n3 != 1) continue;
                stringBuffer.append(String.format("%02x", n4));
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.append('>').toString();
    }

    protected String getFooter() {
        String string;
        Serializable serializable;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getClip() != null) {
            stringBuffer.append("Q\n");
        }
        stringBuffer.append("Q");
        int n = this.size() + stringBuffer.length();
        stringBuffer.append('\n');
        stringBuffer.append("endstream\n");
        stringBuffer.append("endobj\n");
        int n2 = this.a(this.size() + stringBuffer.length());
        stringBuffer.append(n2).append(" 0 obj\n");
        stringBuffer.append(n - this.h).append('\n');
        stringBuffer.append("endobj\n");
        n = this.a(this.size() + stringBuffer.length());
        stringBuffer.append(n).append(" 0 obj\n");
        stringBuffer.append("<<\n");
        stringBuffer.append(" /ProcSet [/PDF /Text /ImageB /ImageC /ImageI]\n");
        if (!this.g.isEmpty()) {
            stringBuffer.append(" /Font <<\n");
            for (Map.Entry<Font, String> entry : this.g.entrySet()) {
                serializable = entry.getKey();
                string = entry.getValue();
                stringBuffer.append("  /").append(string).append(" << /Type /Font /Subtype /TrueType /BaseFont /").append(((Font)serializable).getPSName()).append(" >>\n");
            }
            stringBuffer.append(" >>\n");
        }
        if (!this.f.isEmpty()) {
            stringBuffer.append(" /XObject <<\n");
            int n3 = 0;
            Iterator<Map.Entry<BufferedImage, String>> iterator = this.f.entrySet().iterator();
            while (iterator.hasNext()) {
                string = iterator.next().getValue();
                stringBuffer.append("  /").append(string).append(' ').append(this.c + n3).append(" 0 R\n");
                ++n3;
            }
            stringBuffer.append(" >>\n");
        }
        if (!this.e.isEmpty()) {
            stringBuffer.append(" /ExtGState <<\n");
            for (Map.Entry<Double, String> entry : this.e.entrySet()) {
                serializable = entry.getKey();
                string = entry.getValue();
                stringBuffer.append("  /").append(string).append(" << /Type /ExtGState /ca ").append(serializable).append(" /CA ").append(serializable).append(" >>\n");
            }
            stringBuffer.append(" >>\n");
        }
        stringBuffer.append(">>\n");
        stringBuffer.append("endobj\n");
        for (BufferedImage bufferedImage : this.f.keySet()) {
            int n4 = this.a(this.size() + stringBuffer.length());
            stringBuffer.append(n4).append(" 0 obj\n");
            stringBuffer.append("<<\n");
            string = PDFGraphics2D.a(bufferedImage);
            stringBuffer.append("/Type /XObject\n/Subtype /Image\n/Width ").append(bufferedImage.getWidth()).append('\n').append("/Height ").append(bufferedImage.getHeight()).append('\n').append("/ColorSpace /DeviceRGB\n/BitsPerComponent 8\n/Length ").append(string.length()).append('\n').append("/Filter /ASCIIHexDecode\n>>\nstream\n").append(string).append("\nendstream\nendobj\n");
        }
        int n5 = this.d.size() + 1;
        n2 = this.size() + stringBuffer.length();
        stringBuffer.append("xref\n");
        stringBuffer.append("0 ").append(n5).append('\n');
        stringBuffer.append(String.format("%010d %05d", 0, 65535)).append(" f \n");
        for (int n6 : this.d.values()) {
            stringBuffer.append(String.format("%010d %05d", n6, 0)).append(" n \n");
        }
        stringBuffer.append("trailer\n");
        stringBuffer.append("<<\n");
        stringBuffer.append("/Size ").append(n5).append('\n');
        stringBuffer.append("/Root 1 0 R\n");
        stringBuffer.append(">>\n");
        stringBuffer.append("startxref\n");
        stringBuffer.append(n2).append('\n');
        stringBuffer.append("%%EOF\n");
        return stringBuffer.toString();
    }

    public String toString() {
        return super.toString();
    }

    public byte[] getBytes() {
        try {
            return this.toString().getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return super.getBytes();
        }
    }
}

