/*
 * Decompiled with CFR 0.152.
 */
package mesh2d.graph;

import java.util.ArrayList;
import java.util.List;
import mesh2d.graph.Edge;
import mesh2d.graph.Vertex;

public class Graph {
    private List<Vertex> vertices = new ArrayList<Vertex>();
    private List<Edge> edges = new ArrayList<Edge>();

    public void addVertex(Vertex v) {
        this.vertices.add(v);
    }

    public void removeVertex(Vertex v) {
        this.vertices.remove(v);
    }

    public void addEdge(Edge e) {
        this.edges.add(e);
    }

    public void removeEdge(Edge e) {
        this.edges.remove(e);
    }

    public List<Vertex> getVertices() {
        return this.vertices;
    }

    public void setVertices(List<Vertex> vertices) {
        this.vertices = vertices;
    }

    public List<Edge> getEdges() {
        return this.edges;
    }

    public void setEdges(List<Edge> edges) {
        this.edges = edges;
    }

    public Vertex getVertexById(int id) {
        for (Vertex v : this.vertices) {
            if (v.getId() != id) continue;
            return v;
        }
        return null;
    }

    public List<Edge> getEdgesByVertex(Vertex v) {
        ArrayList<Edge> validEdges = new ArrayList<Edge>();
        for (Edge e : this.edges) {
            if (!e.getSource().equals(v) && !e.getTarget().equals(v)) continue;
            validEdges.add(e);
        }
        return validEdges;
    }
}

