/*
 * Decompiled with CFR 0.152.
 */
package mesh2d.graph.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mesh2d.graph.Edge;
import mesh2d.graph.Graph;
import mesh2d.graph.Vertex;

public class GraphFilter {
    public static Graph euclidianFilter(Graph graph, float minDistance) {
        HashSet<Vertex> toRemoveVertices = new HashSet<Vertex>();
        for (int i = 0; i < graph.getVertices().size(); ++i) {
            Vertex currentVertex = graph.getVertices().get(i);
            if (toRemoveVertices.contains(currentVertex)) continue;
            for (int j = i + 1; j < graph.getVertices().size(); ++j) {
                Vertex nextVertex = graph.getVertices().get(j);
                if (!(nextVertex.distanceTo(currentVertex) < minDistance)) continue;
                toRemoveVertices.add(nextVertex);
            }
        }
        graph.getVertices().removeAll(toRemoveVertices);
        return graph;
    }

    public static Graph graphDistFilter(Graph graph, float minDistance) {
        HashSet<Vertex> verticesToRemove = new HashSet<Vertex>();
        HashSet<Vertex> visitedVertices = new HashSet<Vertex>();
        for (Vertex v : graph.getVertices()) {
            if (!v.isValid()) continue;
            visitedVertices.add(v);
            Set<Vertex> neighborsToRemove = GraphFilter.distanceDepthSearch(graph, v, visitedVertices, minDistance);
            verticesToRemove.addAll(neighborsToRemove);
        }
        graph.getVertices().removeAll(verticesToRemove);
        return graph;
    }

    private static Set<Vertex> distanceDepthSearch(Graph graph, Vertex v, Set<Vertex> visitedVertices, float distance) {
        HashSet<Vertex> neighborsToRemove = new HashSet<Vertex>();
        List<Edge> vertexEdges = graph.getEdgesByVertex(v);
        for (Edge e : vertexEdges) {
            Vertex neighbor = null;
            if (!e.getSource().equals(v)) {
                neighbor = e.getSource();
            } else if (!e.getTarget().equals(v)) {
                neighbor = e.getTarget();
            }
            if (visitedVertices.contains(neighbor) || !(e.getWeight() < distance)) continue;
            if (neighbor.isValid()) {
                neighborsToRemove.add(neighbor);
            }
            visitedVertices.add(neighbor);
            neighborsToRemove.addAll(GraphFilter.distanceDepthSearch(graph, neighbor, visitedVertices, distance - e.getWeight()));
        }
        return neighborsToRemove;
    }

    public static Graph neighborFilter(Graph graph, int neighborRadius) {
        HashSet<Vertex> verticesToRemove = new HashSet<Vertex>();
        HashSet<Vertex> visitedVertices = new HashSet<Vertex>();
        for (Vertex v : graph.getVertices()) {
            if (!v.isValid()) continue;
            visitedVertices.add(v);
            Set<Vertex> neighborsToRemove = GraphFilter.neighborRadiusSearch(graph, v, visitedVertices, neighborRadius);
            verticesToRemove.addAll(neighborsToRemove);
        }
        graph.getVertices().removeAll(verticesToRemove);
        return graph;
    }

    private static Set<Vertex> neighborRadiusSearch(Graph graph, Vertex v, Set<Vertex> visitedVertices, int neighborRadius) {
        HashSet<Vertex> neighborsToRemove = new HashSet<Vertex>();
        List<Edge> vertexEdges = graph.getEdgesByVertex(v);
        for (Edge e : vertexEdges) {
            Vertex neighbor = null;
            if (!e.getSource().equals(v)) {
                neighbor = e.getSource();
            } else if (!e.getTarget().equals(v)) {
                neighbor = e.getTarget();
            }
            if (visitedVertices.contains(neighbor) || neighborRadius <= 0) continue;
            if (neighbor.isValid()) {
                neighborsToRemove.add(neighbor);
            }
            visitedVertices.add(neighbor);
            neighborsToRemove.addAll(GraphFilter.neighborRadiusSearch(graph, neighbor, visitedVertices, neighborRadius - 1));
        }
        return neighborsToRemove;
    }
}

