/*
 * Decompiled with CFR 0.152.
 */
package mesh2d.voronoi;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import mesh2d.basic.AbstractMesh;
import mesh2d.basic.Cell;
import mesh2d.graph.Edge;
import mesh2d.graph.Graph;
import mesh2d.graph.Vertex;

public class VoronoiMesh
extends AbstractMesh {
    protected Graph graph;

    public VoronoiMesh() {
    }

    public VoronoiMesh(Graph graph) {
        this.graph = graph;
    }

    public void build(Rectangle boundingBox) {
        this.cellList = new ArrayList();
        List<Vertex> pointList = this.graph.getVertices();
        for (int i = 0; i < pointList.size(); ++i) {
            List<Vertex> newCellPoints = new ArrayList<Vertex>();
            newCellPoints.add(new Vertex(boundingBox.getMinX(), boundingBox.getMinY()));
            newCellPoints.add(new Vertex(boundingBox.getMinX(), boundingBox.getMinY() + boundingBox.getHeight() - 1.0));
            newCellPoints.add(new Vertex(boundingBox.getMinX() + boundingBox.getWidth() - 1.0, boundingBox.getMinY() + boundingBox.getHeight() - 1.0));
            newCellPoints.add(new Vertex(boundingBox.getMinX() + boundingBox.getWidth() - 1.0, boundingBox.getMinY()));
            for (int j = 0; j < pointList.size(); ++j) {
                newCellPoints = this.buildCellPoints(newCellPoints, pointList.get(i), pointList.get(j));
            }
            Cell cell = this.makeCell(pointList.get(i).getId(), newCellPoints);
            this.cellList.add(cell);
        }
    }

    private List<Vertex> buildCellPoints(List<Vertex> cellPoints, Vertex site1, Vertex site2) {
        double ptoMedioX = 0.0;
        double ptoMedioY = 0.0;
        double vetorIX = 0.0;
        double vetorIY = 0.0;
        double[] valorX = new double[cellPoints.size()];
        double[] valorY = new double[cellPoints.size()];
        for (int i = 0; i < cellPoints.size(); ++i) {
            ptoMedioX = (site1.getX() + site2.getX()) / 2.0;
            ptoMedioY = (site1.getY() + site2.getY()) / 2.0;
            vetorIX = site2.getX() - ptoMedioX;
            vetorIY = site2.getY() - ptoMedioY;
            double normaVetorI = Math.sqrt(vetorIX * vetorIX + vetorIY * vetorIY);
            double pontoX = cellPoints.get(i).getX();
            double pontoY = cellPoints.get(i).getY();
            double vetorPontoX = pontoX - ptoMedioX;
            double vetorPontoY = pontoY - ptoMedioY;
            valorX[i] = vetorPontoX * (vetorIX /= normaVetorI) + vetorPontoY * (vetorIY /= normaVetorI);
        }
        int start = -1;
        int end = -1;
        double celula0X = 0.0;
        double celula0Y = 0.0;
        double celula1X = 0.0;
        double celula1Y = 0.0;
        double celula10X = 0.0;
        double celula10Y = 0.0;
        double celula11X = 0.0;
        double celula11Y = 0.0;
        int[] ant = new int[2];
        int[] dep = new int[2];
        int num = 0;
        ant[0] = 0;
        dep[0] = 0;
        for (int i = 0; i < cellPoints.size(); ++i) {
            if (!(valorX[i] * valorX[(i + 1) % cellPoints.size()] < 0.0)) continue;
            if (num == 0) {
                celula0X = cellPoints.get(i).getX();
                celula0Y = cellPoints.get(i).getY();
                celula1X = cellPoints.get((i + 1) % cellPoints.size()).getX();
                celula1Y = cellPoints.get((i + 1) % cellPoints.size()).getY();
                ++num;
                ant[0] = i;
                dep[0] = (i + 1) % cellPoints.size();
            } else {
                celula10X = cellPoints.get(i).getX();
                celula10Y = cellPoints.get(i).getY();
                celula11X = cellPoints.get((i + 1) % cellPoints.size()).getX();
                celula11Y = cellPoints.get((i + 1) % cellPoints.size()).getY();
                ant[1] = i;
                dep[1] = (i + 1) % cellPoints.size();
            }
            if (start != -1) {
                end = i;
                break;
            }
            start = (i + 1) % cellPoints.size();
        }
        double[] pontoFinalX = new double[2];
        double[] pontoFinalY = new double[2];
        double[] valoresY = new double[2];
        double vetorJX = -vetorIY;
        double vetorJY = vetorIX;
        valorY[ant[0]] = (celula0X - ptoMedioX) * vetorJX + (celula0Y - ptoMedioY) * vetorJY;
        valorY[dep[0]] = (celula1X - ptoMedioX) * vetorJX + (celula1Y - ptoMedioY) * vetorJY;
        valoresY[0] = (valorY[dep[0]] - valorY[ant[0]]) / (valorX[ant[0]] - valorX[dep[0]]) * valorX[ant[0]] + valorY[ant[0]];
        pontoFinalX[0] = -vetorIY * valoresY[0] + ptoMedioX;
        pontoFinalY[0] = vetorIX * valoresY[0] + ptoMedioY;
        valorY[ant[1]] = (celula10X - ptoMedioX) * vetorJX + (celula10Y - ptoMedioY) * vetorJY;
        valorY[dep[1]] = (celula11X - ptoMedioX) * vetorJX + (celula11Y - ptoMedioY) * vetorJY;
        valoresY[1] = (valorY[dep[1]] - valorY[ant[1]]) / (valorX[ant[1]] - valorX[dep[1]]) * valorX[ant[1]] + valorY[ant[1]];
        pontoFinalX[1] = -vetorIY * valoresY[1] + ptoMedioX;
        pontoFinalY[1] = vetorIX * valoresY[1] + ptoMedioY;
        if (start != -1) {
            if (valorX[0] < 0.0) {
                for (int i = start; i < end + 1; ++i) {
                    cellPoints.remove(start);
                }
                cellPoints.add(start, new Vertex(pontoFinalX[1], pontoFinalY[1]));
                cellPoints.add(start, new Vertex(pontoFinalX[0], pontoFinalY[0]));
            } else {
                for (int i = 0; i < start; ++i) {
                    cellPoints.remove(0);
                    --end;
                }
                while (end + 1 < cellPoints.size()) {
                    cellPoints.remove(end + 1);
                }
                cellPoints.add(new Vertex(pontoFinalX[1], pontoFinalY[1]));
                cellPoints.add(new Vertex(pontoFinalX[0], pontoFinalY[0]));
            }
        }
        return cellPoints;
    }

    private Cell makeCell(int siteId, List<Vertex> cellPoints) {
        Edge edge;
        Vertex dest;
        Vertex src;
        ArrayList<Edge> edgeList = new ArrayList<Edge>();
        for (int i = 0; i < cellPoints.size() - 1; ++i) {
            src = cellPoints.get(i);
            dest = cellPoints.get(i + 1);
            edge = new Edge(src, dest);
            edgeList.add(edge);
        }
        src = cellPoints.get(cellPoints.size() - 1);
        dest = cellPoints.get(0);
        edge = new Edge(src, dest);
        edgeList.add(edge);
        Cell cell = new Cell(siteId, edgeList);
        return cell;
    }

    @Override
    public void paint(Graphics2D g2, boolean highQualityRender) {
        super.paint(g2, highQualityRender);
    }

    public Graph getGraph() {
        return this.graph;
    }

    public static void main(String[] args) throws IOException {
        BufferedImage image = new BufferedImage(400, 400, 2);
        ArrayList<Vertex> points = new ArrayList<Vertex>();
        points.add(new Vertex(50.0, 50.0));
        points.add(new Vertex(150.0, 150.0));
        points.add(new Vertex(250.0, 250.0));
        Graph g = new Graph();
        g.setVertices(points);
        BufferedImage backgroundImage = ImageIO.read(VoronoiMesh.class.getResourceAsStream("/resources/sample.jpg"));
        VoronoiMesh mesh = new VoronoiMesh(g);
        mesh.build(new Rectangle(0, 0, image.getWidth(), image.getHeight()));
        mesh.setAlpha(0.5f);
        mesh.setBackgroundAlpha(0.8f);
        ((Cell)mesh.cellList.get(0)).setColor(Color.BLUE);
        ((Cell)mesh.cellList.get(1)).setColor(Color.YELLOW);
        ((Cell)mesh.cellList.get(1)).setBackground(backgroundImage);
        mesh.paint(image.createGraphics(), true);
        ImageIO.write((RenderedImage)image, "png", new File("/home/renato/test.png"));
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }
}

