/*
 * Decompiled with CFR 0.152.
 */
package code;

import code.AnySelectionTable;
import code.TableSelectionModel;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellEditor;

public class AnySelectionTableUI
extends BasicTableUI {
    public static ComponentUI createUI(JComponent c) {
        return new AnySelectionTableUI();
    }

    protected MouseInputListener createMouseInputListener() {
        return new AnySelectionMouseInputHandler();
    }

    protected JTable getTable() {
        return this.table;
    }

    protected void updateTableSelectionModel(int row, int column, boolean ctrlDown, boolean shiftDown) {
        AnySelectionTable t = (AnySelectionTable)this.getTable();
        column = t.convertColumnIndexToModel(column);
        TableSelectionModel tsm = t.getTableSelectionModel();
        int anchorIndex = -1;
        int ac = -1;
        int col = 0;
        int dif = Integer.MAX_VALUE;
        for (int c = 0; c < tsm.listSelectionModels.size(); ++c) {
            ac = tsm.getListSelectionModelAt(c).getAnchorSelectionIndex();
            if (ac == -1 || Math.abs(column - c) >= dif) continue;
            col = c;
            anchorIndex = ac;
        }
        if (ctrlDown) {
            if (tsm.isSelected(row, column)) {
                tsm.removeSelection(row, column);
            } else {
                tsm.addSelection(row, column);
            }
        } else if (shiftDown && anchorIndex != -1) {
            if (col < tsm.listSelectionModels.size()) {
                tsm.addSelectionInterval(anchorIndex, row, col, column);
            }
        } else {
            tsm.setSelection(row, column);
        }
    }

    public class AnySelectionMouseInputHandler
    extends BasicTableUI.MouseInputHandler {
        public AnySelectionMouseInputHandler() {
            super(AnySelectionTableUI.this);
        }

        public void mouseReleased(MouseEvent e) {
            super.mousePressed(e);
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            Point p = e.getPoint();
            int row = AnySelectionTableUI.this.getTable().rowAtPoint(p);
            int column = AnySelectionTableUI.this.getTable().columnAtPoint(p);
            if (column == -1 || row == -1) {
                return;
            }
            TableCellEditor tce = AnySelectionTableUI.this.getTable().getCellEditor();
            if (tce == null || tce.shouldSelectCell(e)) {
                AnySelectionTableUI.this.getTable().requestFocus();
                AnySelectionTableUI.this.updateTableSelectionModel(row, column, e.isControlDown(), e.isShiftDown());
                AnySelectionTableUI.this.getTable().repaint();
            }
        }
    }
}

