/*
 * Decompiled with CFR 0.152.
 */
package code;

import code.TableSelectionEvent;
import code.TableSelectionListener;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableSelectionModel
implements PropertyChangeListener,
ListSelectionListener,
TableModelListener {
    protected EventListenerList listenerList = new EventListenerList();
    protected Vector listSelectionModels = new Vector();

    public void addSelection(int row, int column) {
        ListSelectionModel lsm = this.getListSelectionModelAt(column);
        lsm.addSelectionInterval(row, row);
    }

    public void setSelection(int row, int column) {
        this.clearSelection();
        ListSelectionModel lsm = this.getListSelectionModelAt(column);
        lsm.setSelectionInterval(row, row);
    }

    public void setSelectionInterval(int row1, int row2, int column) {
        this.clearSelection();
        ListSelectionModel lsm = this.getListSelectionModelAt(column);
        lsm.setSelectionInterval(row1, row2);
    }

    public void addSelectionInterval(int row1, int row2, int column1, int column2) {
        int end;
        int start;
        if (column1 < column2) {
            start = column1;
            end = column2;
        } else {
            start = column2;
            end = column1;
        }
        for (int i = start; i <= end; ++i) {
            ListSelectionModel lsm = this.getListSelectionModelAt(i);
            lsm.addSelectionInterval(row1, row2);
        }
    }

    public void setLeadSelectionIndex(int row, int column) {
        ListSelectionModel lsm = this.getListSelectionModelAt(column);
        if (lsm.isSelectionEmpty()) {
            lsm.setSelectionInterval(row, row);
        } else {
            lsm.setLeadSelectionIndex(row);
        }
    }

    public void removeSelection(int row, int column) {
        ListSelectionModel lsm = this.getListSelectionModelAt(column);
        lsm.removeSelectionInterval(row, row);
    }

    public void clearSelection() {
        for (int i = 0; i < this.listSelectionModels.size(); ++i) {
            ListSelectionModel lm = (ListSelectionModel)this.listSelectionModels.get(i);
            lm.clearSelection();
            lm.setAnchorSelectionIndex(-1);
        }
    }

    public boolean isSelected(int row, int column) {
        ListSelectionModel lsm = this.getListSelectionModelAt(column);
        return lsm.isSelectedIndex(row);
    }

    public ListSelectionModel getListSelectionModelAt(int index) {
        return (ListSelectionModel)this.listSelectionModels.elementAt(index);
    }

    public void setColumns(int count) {
        this.listSelectionModels = new Vector();
        for (int i = 0; i < count; ++i) {
            this.addColumn();
        }
    }

    protected void addColumn() {
        DefaultListSelectionModel newListModel = new DefaultListSelectionModel();
        this.listSelectionModels.addElement(newListModel);
        newListModel.addListSelectionListener(this);
    }

    protected void removeColumn() {
        DefaultListSelectionModel removedModel = (DefaultListSelectionModel)this.listSelectionModels.lastElement();
        removedModel.removeListSelectionListener(this);
        this.listSelectionModels.removeElement(removedModel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("model".equals(evt.getPropertyName())) {
            TableModel newModel = (TableModel)evt.getNewValue();
            this.setColumns(newModel.getColumnCount());
            TableModel oldModel = (TableModel)evt.getOldValue();
            if (oldModel != null) {
                oldModel.removeTableModelListener(this);
            }
            newModel.addTableModelListener(this);
        }
    }

    public void addTableSelectionListener(TableSelectionListener l) {
        this.listenerList.add(TableSelectionListener.class, l);
    }

    public void removeTableSelectionListener(TableSelectionListener l) {
        this.listenerList.remove(TableSelectionListener.class, l);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        TableModel tm = (TableModel)e.getSource();
        int count = this.listSelectionModels.size();
        int tmCount = tm.getColumnCount();
        while (count-- > tmCount) {
            this.removeColumn();
        }
        while (tmCount > count++) {
            this.addColumn();
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        int columnIndex = this.listSelectionModels.lastIndexOf(lsm);
        if (columnIndex > -1) {
            this.fireValueChanged(this, e.getFirstIndex(), e.getLastIndex(), columnIndex, e.getValueIsAdjusting());
        }
    }

    protected void fireValueChanged(Object source, int firstIndex, int lastIndex, int columnIndex, boolean isAdjusting) {
        Object[] listeners = this.listenerList.getListenerList();
        TableSelectionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TableSelectionListener.class) continue;
            if (e == null) {
                e = new TableSelectionEvent(source, firstIndex, lastIndex, columnIndex, false);
            }
            ((TableSelectionListener)listeners[i + 1]).valueChanged(e);
        }
    }

    public ArrayList<Point> getSelectedCells() {
        ArrayList<Point> points = new ArrayList<Point>();
        for (int col = 0; col < this.listSelectionModels.size(); ++col) {
            ListSelectionModel lsm = this.getListSelectionModelAt(col);
            int startRow = lsm.getMinSelectionIndex();
            int endRow = lsm.getMaxSelectionIndex();
            for (int row = startRow; row <= endRow; ++row) {
                if (!lsm.isSelectedIndex(row)) continue;
                points.add(new Point(row, col));
            }
        }
        return points;
    }

    public String toString() {
        String ret = "[\n";
        for (int col = 0; col < this.listSelectionModels.size(); ++col) {
            ret = ret + "'" + col + "'={";
            ListSelectionModel lsm = this.getListSelectionModelAt(col);
            int startRow = lsm.getMinSelectionIndex();
            int endRow = lsm.getMaxSelectionIndex();
            for (int row = startRow; row < endRow; ++row) {
                if (!lsm.isSelectedIndex(row)) continue;
                ret = ret + row + ", ";
            }
            if (lsm.isSelectedIndex(endRow)) {
                ret = ret + endRow;
            }
            ret = ret + "}\n";
        }
        ret = ret + "]";
        return ret;
    }
}

