/*
 * Decompiled with CFR 0.152.
 */
package mdsj;

import java.util.Random;
import mdsj.Data;

public class ClassicalScaling {
    public static void eigen(double[][] matrix, double[][] evecs, double[] evals) {
        double eps = 1.0E-6;
        int maxiter = 100;
        int d = evals.length;
        int n = matrix.length;
        int m = 0;
        while (m < d) {
            int i;
            if (m > 0) {
                i = 0;
                while (i < n) {
                    int j = 0;
                    while (j < n) {
                        double[] dArray = matrix[i];
                        int n2 = j;
                        dArray[n2] = dArray[n2] - evals[m - 1] * evecs[m - 1][i] * evecs[m - 1][j];
                        ++j;
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < n) {
                evecs[m][i] = Math.random();
                ++i;
            }
            Data.normalize(evecs[m]);
            double r = 0.0;
            int iter = 0;
            while (Math.abs(1.0 - r) > 1.0E-6 && iter < 100) {
                double[] q = new double[n];
                int i2 = 0;
                while (i2 < n) {
                    int j = 0;
                    while (j < n) {
                        int n3 = i2;
                        q[n3] = q[n3] + matrix[i2][j] * evecs[m][j];
                        ++j;
                    }
                    ++i2;
                }
                evals[m] = Data.prod(evecs[m], q);
                Data.normalize(q);
                r = Math.abs(Data.prod(evecs[m], q));
                evecs[m] = q;
                ++iter;
            }
            ++m;
        }
    }

    public static double largestEigenvalue(double[][] matrix) {
        double eps = 1.0E-6;
        int maxiter = 100;
        int n = matrix.length;
        double lambda = 0.0;
        double[] x = new double[n];
        int i = 0;
        while (i < n) {
            x[i] = 1.0;
            ++i;
        }
        double r = 0.0;
        int iter = 0;
        while (Math.abs(1.0 - r) > 1.0E-6 && iter < 100) {
            double[] q = new double[n];
            int i2 = 0;
            while (i2 < n) {
                int j = 0;
                while (j < n) {
                    int n2 = i2;
                    q[n2] = q[n2] + matrix[i2][j] * x[j];
                    ++j;
                }
                ++i2;
            }
            lambda = Data.prod(x, q);
            Data.normalize(q);
            r = Math.abs(Data.prod(x, q));
            x = q;
            ++iter;
        }
        return lambda;
    }

    public static double smallestEigenvalue(double[][] matrix) {
        double rho = ClassicalScaling.largestEigenvalue(matrix);
        double eps = 1.0E-6;
        int maxiter = 100;
        int n = matrix.length;
        double lambda = 0.0;
        double[] x = new double[n];
        Random random = new Random(1L);
        int i = 0;
        while (i < n) {
            x[i] = 0.5 - random.nextDouble();
            ++i;
        }
        Data.normalize(x);
        double r = 0.0;
        int iter = 0;
        while (Math.abs(1.0 - r) > 1.0E-6 && iter < 100) {
            double[] q = new double[n];
            int i2 = 0;
            while (i2 < n) {
                int n2 = i2;
                q[n2] = q[n2] - rho * x[i2];
                int j = 0;
                while (j < n) {
                    int n3 = i2;
                    q[n3] = q[n3] + matrix[i2][j] * x[j];
                    ++j;
                }
                ++i2;
            }
            lambda = Data.prod(x, q);
            Data.normalize(q);
            r = Math.abs(Data.prod(x, q));
            x = q;
            ++iter;
        }
        return lambda + rho;
    }

    public static double[] pivotmds(double[][] input, double[][] result) {
        double[] evals = new double[result.length];
        Data.doubleCenter(input);
        Data.multiply(input, -0.5);
        ClassicalScaling.svd(input, result, evals);
        int i = 0;
        while (i < result.length) {
            int j = 0;
            while (j < result[0].length) {
                double[] dArray = result[i];
                int n = j++;
                dArray[n] = dArray[n] * Math.sqrt(evals[i]);
            }
            ++i;
        }
        return evals;
    }

    public static double[] lmds(double[][] P, double[][] result) {
        double[][] distances = new double[P.length][P[0].length];
        int i = 0;
        while (i < distances.length) {
            int j = 0;
            while (j < distances[0].length) {
                distances[i][j] = P[i][j];
                ++j;
            }
            ++i;
        }
        Data.squareEntries(distances);
        int k = distances.length;
        int n = distances[0].length;
        int d = result.length;
        double[] mean = new double[n];
        int i2 = 0;
        while (i2 < n) {
            int j = 0;
            while (j < k) {
                int n2 = i2;
                mean[n2] = mean[n2] + distances[j][i2];
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < n) {
            int n3 = i2++;
            mean[n3] = mean[n3] / (double)k;
        }
        double[] lambda = new double[d];
        double[][] temp = new double[d][k];
        Data.randomize(temp);
        double[][] K = Data.landmarkMatrix(P);
        Data.squareEntries(K);
        Data.doubleCenter(K);
        Data.multiply(K, -0.5);
        ClassicalScaling.eigen(K, temp, lambda);
        int i3 = 0;
        while (i3 < temp.length) {
            int j = 0;
            while (j < temp[0].length) {
                double[] dArray = temp[i3];
                int n4 = j++;
                dArray[n4] = dArray[n4] * Math.sqrt(lambda[i3]);
            }
            ++i3;
        }
        int m = 0;
        while (m < d) {
            int i4 = 0;
            while (i4 < n) {
                result[m][i4] = 0.0;
                int j = 0;
                while (j < k) {
                    double[] dArray = result[m];
                    int n5 = i4;
                    dArray[n5] = dArray[n5] - 0.5 * (distances[j][i4] - mean[i4]) * temp[m][j] / lambda[m];
                    ++j;
                }
                ++i4;
            }
            ++m;
        }
        return lambda;
    }

    private static void svd(double[][] matrix, double[][] svecs, double[] svals) {
        int j;
        int i;
        int k = matrix.length;
        int n = matrix[0].length;
        int d = svecs.length;
        int m = 0;
        while (m < d) {
            svals[m] = Data.normalize(svecs[m]);
            ++m;
        }
        double[][] K = new double[k][k];
        Data.selfprod(matrix, K);
        double[][] temp = new double[d][k];
        int m2 = 0;
        while (m2 < d) {
            int i2 = 0;
            while (i2 < k) {
                int j2 = 0;
                while (j2 < n) {
                    double[] dArray = temp[m2];
                    int n2 = i2;
                    dArray[n2] = dArray[n2] + matrix[i2][j2] * svecs[m2][j2];
                    ++j2;
                }
                ++i2;
            }
            ++m2;
        }
        m2 = 0;
        while (m2 < d) {
            svals[m2] = Data.normalize(svecs[m2]);
            ++m2;
        }
        ClassicalScaling.eigen(K, temp, svals);
        double[][] tempOld = new double[d][k];
        int m3 = 0;
        while (m3 < d) {
            i = 0;
            while (i < k) {
                j = 0;
                while (j < k) {
                    double[] dArray = tempOld[m3];
                    int n3 = j;
                    dArray[n3] = dArray[n3] + K[i][j] * temp[m3][i];
                    ++j;
                }
                ++i;
            }
            ++m3;
        }
        m3 = 0;
        while (m3 < d) {
            svals[m3] = Data.normalize(tempOld[m3]);
            ++m3;
        }
        m3 = 0;
        while (m3 < d) {
            svals[m3] = Math.sqrt(svals[m3]);
            i = 0;
            while (i < n) {
                svecs[m3][i] = 0.0;
                j = 0;
                while (j < k) {
                    double[] dArray = svecs[m3];
                    int n4 = i;
                    dArray[n4] = dArray[n4] + matrix[j][i] * temp[m3][j];
                    ++j;
                }
                ++i;
            }
            ++m3;
        }
        m3 = 0;
        while (m3 < d) {
            Data.normalize(svecs[m3]);
            ++m3;
        }
    }

    public static double[] fullmds(double[][] distances, double[][] result) {
        double[] evals = new double[result.length];
        Data.squareEntries(distances);
        Data.doubleCenter(distances);
        Data.multiply(distances, -0.5);
        ClassicalScaling.eigen(distances, result, evals);
        int i = 0;
        while (i < result.length) {
            if (evals[i] > 0.0) {
                evals[i] = Math.sqrt(evals[i]);
            }
            int j = 0;
            while (j < result[0].length) {
                double[] dArray = result[i];
                int n = j++;
                dArray[n] = dArray[n] * evals[i];
            }
            ++i;
        }
        return evals;
    }
}

