/*
 * Decompiled with CFR 0.152.
 */
package example;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import jclusteroutline.Outline;
import jclusteroutline.Vector2d;

public class DataCluster {
    private ArrayList<Vector2d> dataSet;
    private ArrayList<Vector2d> outlineSet;
    private Color clusterColor;
    private Outline outlineAlg;
    private Dimension dim;

    public DataCluster(Outline outlineAlg, ArrayList<Vector2d> dataSet, Dimension dim) {
        this.dataSet = dataSet;
        this.clusterColor = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
        this.outlineAlg = outlineAlg;
        this.dim = dim;
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (Vector2d v : dataSet) {
            points.add(new Point2D.Double(v.getX() * (double)dim.width, v.getY() * (double)dim.height));
        }
        this.outlineSet = outlineAlg.compute(points, dim);
    }

    public DataCluster(Outline outlineAlg) {
        this.clusterColor = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
        this.outlineAlg = outlineAlg;
        this.dataSet = new ArrayList();
        this.outlineSet = new ArrayList();
    }

    public void addDataPoint(Vector2d newPoint) {
        this.dataSet.add(newPoint);
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (Vector2d v : this.dataSet) {
            points.add(new Point2D.Double(v.getX() * (double)this.dim.width, v.getY() * (double)this.dim.height));
        }
        this.outlineSet = this.outlineAlg.compute(points, this.dim);
    }

    protected void redoOutline() {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (Vector2d v : this.dataSet) {
            points.add(new Point2D.Double(v.getX() * (double)this.dim.width, v.getY() * (double)this.dim.height));
        }
        this.outlineSet = this.outlineAlg.compute(points, this.dim);
    }

    public ArrayList<Vector2d> getDataSet() {
        return this.dataSet;
    }

    public ArrayList<Vector2d> getOutlineSet() {
        return this.outlineSet;
    }

    public Color getClusterColor() {
        return this.clusterColor;
    }

    public void randomizeClusterColor() {
        this.clusterColor = new Color((float)Math.random(), (float)Math.random(), (float)Math.random());
    }
}

