/*
 * Decompiled with CFR 0.152.
 */
package example;

import example.TestCore;
import example.drawPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Test
extends JFrame {
    private TestCore core;
    private int nClusters;
    private JButton addClusterButton;
    private JButton cleanButton;
    private JComboBox clusterComboBox;
    private drawPanel drawPanel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JSpinner lambdaSpinner;
    private JSpinner nIterationsSpinner;
    private JSpinner paddingSpinner;
    private JButton randomizeAllColorsButton;
    private JButton randomizeClusterColorButton;
    private JButton removeCluster;
    private JSpinner samplingDistanceSpinner;
    private JToggleButton showOutlineToggleButton;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Test().setVisible(true);
            }
        });
    }

    public Test() {
        this.initComponents();
        ComboBoxRenderer newRenderer = new ComboBoxRenderer();
        this.core = new TestCore(this.drawPanel.getWidth(), this.drawPanel.getHeight());
        this.drawPanel.setTestCore(this.core);
        this.clusterComboBox.setRenderer(newRenderer);
        this.updateClusterComboBox();
        this.repaint();
    }

    private void updateClusterComboBox() {
        int selectedCluster = this.core.getSelectedCluster();
        this.clusterComboBox.removeAllItems();
        int size = this.core.getDataClusters().size();
        for (int cnt = 0; cnt < size; ++cnt) {
            this.clusterComboBox.addItem(cnt);
        }
        this.clusterComboBox.setSelectedIndex(selectedCluster);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.addClusterButton = new JButton();
        this.showOutlineToggleButton = new JToggleButton();
        this.randomizeClusterColorButton = new JButton();
        this.randomizeAllColorsButton = new JButton();
        this.removeCluster = new JButton();
        this.cleanButton = new JButton();
        this.jPanel2 = new JPanel();
        this.paddingSpinner = new JSpinner();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.samplingDistanceSpinner = new JSpinner();
        this.jPanel3 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.lambdaSpinner = new JSpinner();
        this.nIterationsSpinner = new JSpinner();
        this.clusterComboBox = new JComboBox();
        this.drawPanel = new drawPanel();
        this.setDefaultCloseOperation(3);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.addClusterButton.setLabel("Add Cluster");
        this.addClusterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.addClusterButtonActionPerformed(evt);
            }
        });
        this.showOutlineToggleButton.setText("Show Outline");
        this.showOutlineToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.showOutlineToggleButtonActionPerformed(evt);
            }
        });
        this.randomizeClusterColorButton.setText("Randomize Cluster Color");
        this.randomizeClusterColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.randomizeClusterColorButtonActionPerformed(evt);
            }
        });
        this.randomizeAllColorsButton.setText("Randomize All Colors");
        this.randomizeAllColorsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.randomizeAllColorsButtonActionPerformed(evt);
            }
        });
        this.removeCluster.setText("Remove Cluster");
        this.removeCluster.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.removeClusterActionPerformed(evt);
            }
        });
        this.cleanButton.setText("Clean");
        this.cleanButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.cleanButtonActionPerformed(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Parameters"));
        this.paddingSpinner.setModel(new SpinnerNumberModel(0.04, 0.0, 1.001, 0.01));
        this.paddingSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Test.this.paddingSpinnerStateChanged(evt);
            }
        });
        this.jLabel1.setText("Padding");
        this.jLabel2.setText("Sampling Distance");
        this.samplingDistanceSpinner.setModel(new SpinnerNumberModel(0.02, 0.0, 1.001, 0.002));
        this.samplingDistanceSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Test.this.samplingDistanceSpinnerStateChanged(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.paddingSpinner).addComponent(this.samplingDistanceSpinner)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.paddingSpinner, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.samplingDistanceSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder("Laplacian Smoothing")));
        this.jLabel3.setText("Lambda");
        this.jLabel4.setText("# Iterations");
        this.lambdaSpinner.setModel(new SpinnerNumberModel(0.5, 0.0, 1.0, 0.05));
        this.lambdaSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Test.this.lambdaSpinnerStateChanged(evt);
            }
        });
        this.nIterationsSpinner.setModel(new SpinnerNumberModel(10, 0, 99, 1));
        this.nIterationsSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                Test.this.nIterationsSpinnerStateChanged(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lambdaSpinner).addComponent(this.nIterationsSpinner, -1, 63, Short.MAX_VALUE)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(13, 13, 13).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.lambdaSpinner, -2, -1, -2)).addGap(12, 12, 12).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.nIterationsSpinner, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.clusterComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.clusterComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Test.this.clusterComboBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.addClusterButton).addGap(62, 62, 62)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.cleanButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.randomizeAllColorsButton).addGap(0, 10, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(23, 23, 23).addComponent(this.randomizeClusterColorButton)).addGroup(jPanel1Layout.createSequentialGroup().addGap(51, 51, 51).addComponent(this.showOutlineToggleButton))).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.clusterComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.removeCluster))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clusterComboBox, -2, -1, -2).addComponent(this.removeCluster)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.randomizeClusterColorButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.addClusterButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addGap(13, 13, 13).addComponent(this.showOutlineToggleButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.randomizeAllColorsButton).addComponent(this.cleanButton)).addContainerGap(21, Short.MAX_VALUE)));
        this.drawPanel.setBorder(BorderFactory.createEtchedBorder());
        GroupLayout drawPanelLayout = new GroupLayout(this.drawPanel);
        this.drawPanel.setLayout(drawPanelLayout);
        drawPanelLayout.setHorizontalGroup(drawPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 428, Short.MAX_VALUE));
        drawPanelLayout.setVerticalGroup(drawPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.drawPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.drawPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        this.pack();
    }

    private void addClusterButtonActionPerformed(ActionEvent evt) {
        this.core.addCluster();
        this.updateClusterComboBox();
    }

    private void showOutlineToggleButtonActionPerformed(ActionEvent evt) {
        this.drawPanel.toggleShowOutlines();
        this.drawPanel.repaint();
    }

    private void randomizeClusterColorButtonActionPerformed(ActionEvent evt) {
        this.core.randomizeSelectedClusterColor();
        this.updateClusterComboBox();
        this.drawPanel.repaint();
    }

    private void randomizeAllColorsButtonActionPerformed(ActionEvent evt) {
        this.core.randomizeAllClusterColor();
        this.updateClusterComboBox();
        this.drawPanel.repaint();
    }

    private void removeClusterActionPerformed(ActionEvent evt) {
        this.core.removeSelectedCluster();
        this.updateClusterComboBox();
        this.drawPanel.repaint();
    }

    private void cleanButtonActionPerformed(ActionEvent evt) {
        this.core.removeAllClusters();
        this.updateClusterComboBox();
        this.drawPanel.repaint();
    }

    private void paddingSpinnerStateChanged(ChangeEvent evt) {
        this.core.setPadding((Double)this.paddingSpinner.getValue());
        this.drawPanel.repaint();
    }

    private void samplingDistanceSpinnerStateChanged(ChangeEvent evt) {
        this.core.setSamplingDistance((Double)this.samplingDistanceSpinner.getValue());
        this.drawPanel.repaint();
    }

    private void lambdaSpinnerStateChanged(ChangeEvent evt) {
        this.core.setLaplacianLambda((Double)this.lambdaSpinner.getValue());
        this.drawPanel.repaint();
    }

    private void nIterationsSpinnerStateChanged(ChangeEvent evt) {
        this.core.setLaplacianNumIterations((Integer)this.nIterationsSpinner.getValue());
        this.drawPanel.repaint();
    }

    private void clusterComboBoxActionPerformed(ActionEvent evt) {
        int selected = this.clusterComboBox.getSelectedIndex();
        if (selected == -1) {
            if (this.clusterComboBox.getItemCount() > 0) {
                this.clusterComboBox.setSelectedIndex(this.core.getSelectedCluster());
            }
            return;
        }
        this.core.setSelectedCluster(selected);
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int selectedIndex = (Integer)value;
            if (selectedIndex < 0) {
                return this;
            }
            Color color = Test.this.core.getDataClusters().get(selectedIndex).getClusterColor();
            int average = (color.getRed() + color.getBlue() + color.getGreen()) / 3;
            if (average > 127) {
                this.setForeground(Color.BLACK);
            } else {
                this.setForeground(Color.WHITE);
            }
            this.setBackground(color);
            this.setText("Cluster " + (selectedIndex + 1));
            return this;
        }
    }
}

