/*
 * Decompiled with CFR 0.152.
 */
package mesh2d.basic;

import java.awt.Graphics2D;
import java.util.List;
import mesh2d.basic.Cell;
import mesh2d.graph.Edge;

public abstract class AbstractMesh {
    protected List<Cell> cellList;
    protected float alpha = 0.5f;
    protected float backgroundAlpha = 0.5f;
    protected float edgeAlpha = 0.5f;

    public List<Cell> getCells() {
        return this.cellList;
    }

    public Cell getCell(int x, int y) {
        for (Cell cell : this.cellList) {
            if (!cell.contains(x, y)) continue;
            return cell;
        }
        return null;
    }

    public void paint(Graphics2D g2, boolean highQualityRender) {
        for (Cell cell : this.cellList) {
            cell.setAlpha(this.alpha);
            if (cell.isSelected()) {
                cell.setBackgroundAlpha(1.0f);
            } else {
                cell.setBackgroundAlpha(this.backgroundAlpha);
            }
            cell.paint(g2, highQualityRender);
            for (Edge edge : cell.getEdges()) {
                edge.setAlpha(this.edgeAlpha);
                edge.paint(g2, highQualityRender);
            }
        }
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public float getBackgroundAlpha() {
        return this.backgroundAlpha;
    }

    public void setBackgroundAlpha(float backgroundAlpha) {
        this.backgroundAlpha = backgroundAlpha;
    }

    public float getEdgeAlpha() {
        return this.edgeAlpha;
    }

    public void setEdgeAlpha(float edgeAlpha) {
        this.edgeAlpha = edgeAlpha;
    }
}

