/*
 * Decompiled with CFR 0.152.
 */
package mesh2d.graph;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Objects;
import mesh2d.basic.Element;
import mesh2d.graph.Vertex;

public class Edge
extends Element {
    private final Vertex source;
    private final Vertex target;
    private float weight = 1.0f;

    public Edge(Vertex src, Vertex dest) {
        this.source = src;
        this.target = dest;
        this.alpha = 0.5f;
        this.color = Color.BLACK;
    }

    public Edge(Vertex src, Vertex dest, float weight) {
        this(src, dest);
        this.weight = weight;
    }

    public Vertex getSource() {
        return this.source;
    }

    public Vertex getTarget() {
        return this.target;
    }

    public float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = weight;
    }

    public void paint(Graphics2D g2, boolean highQualityRender) {
        g2 = (Graphics2D)g2.create();
        if (highQualityRender) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g2.setComposite(AlphaComposite.getInstance(3, this.alpha));
        g2.setColor(this.color);
        g2.drawLine((int)this.source.getX(), (int)this.source.getY(), (int)this.target.getX(), (int)this.target.getY());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Edge)) {
            return false;
        }
        Edge ref = (Edge)o;
        return ref.source.equals(this.source) && ref.target.equals(this.target);
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Objects.hashCode(this.source);
        hash = 79 * hash + Objects.hashCode(this.target);
        return hash;
    }

    public String toString() {
        return this.source.toString() + " - " + this.target.toString();
    }
}

