/*
 * Decompiled with CFR 0.152.
 */
package simpletree.basics;

import java.util.Arrays;

public class ContentSimpleTree {
    private int id;
    private boolean valid;
    private int level;
    private int[] children;
    private float[] distChildren;
    private int parent;
    private float cdata;
    public int multiscaleLevel = -1;
    private int recursiveChildCount;

    public long computeMemoryAmount() {
        int i;
        long total = 0L;
        total += 136L;
        total += 96L;
        if (this.children != null) {
            for (i = 0; i < this.children.length; ++i) {
                total += 32L;
            }
        }
        total += 96L;
        if (this.distChildren != null) {
            for (i = 0; i < this.distChildren.length; ++i) {
                total += 32L;
            }
        }
        return total;
    }

    public ContentSimpleTree(int id) {
        this.id = id;
        this.valid = true;
        this.level = 0;
        this.parent = -1;
        this.distChildren = new float[2];
        Arrays.fill(this.distChildren, 0.0f);
        this.children = new int[2];
        Arrays.fill(this.children, -1);
    }

    public void addChildren(int id, float distance) {
        if (this.children == null) {
            this.children = new int[2];
            this.distChildren = new float[2];
            Arrays.fill(this.children, -1);
            Arrays.fill(this.distChildren, -1.0f);
            this.children[0] = id;
            this.distChildren[0] = distance;
            return;
        }
        boolean foundSpot = false;
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != -1) continue;
            this.children[i] = id;
            this.distChildren[i] = distance;
            foundSpot = true;
            break;
        }
        if (!foundSpot) {
            this.children = Arrays.copyOf(this.children, this.children.length + 1);
            this.distChildren = Arrays.copyOf(this.distChildren, this.distChildren.length + 1);
            this.children[this.children.length - 1] = id;
            this.distChildren[this.distChildren.length - 1] = distance;
            return;
        }
    }

    public ContentSimpleTree clone() {
        ContentSimpleTree t = new ContentSimpleTree(this.id);
        t.valid = this.valid;
        t.level = this.level;
        t.children = new int[this.children.length];
        System.arraycopy(this.children, 0, t.children, 0, this.children.length);
        t.distChildren = new float[this.distChildren.length];
        System.arraycopy(this.distChildren, 0, t.distChildren, 0, this.distChildren.length);
        t.parent = this.parent;
        return t;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int l) {
        this.level = l;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getParent() {
        return this.parent;
    }

    public void setParent(int parent) {
        this.parent = parent;
    }

    public boolean isRelative(ContentSimpleTree node) {
        return false;
    }

    public ContentSimpleTree getRoot() {
        return null;
    }

    public boolean hasChildren() {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == -1) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public int getNumChildren() {
        int ct = 0;
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] == -1) continue;
                ++ct;
            }
        }
        return ct;
    }

    public void setDistChildren(int i, float d) {
        if (i >= 0) {
            if (this.distChildren == null) {
                this.distChildren = new float[2];
            }
            if (i < this.distChildren.length) {
                this.distChildren[i] = d;
            } else {
                float[] temp = new float[this.distChildren.length];
                System.arraycopy(this.distChildren, 0, temp, 0, this.distChildren.length);
                this.distChildren = new float[3];
                System.arraycopy(temp, 0, this.distChildren, 0, temp.length);
                this.distChildren[2] = d;
            }
        }
    }

    public float getDistChildren(int i) {
        if (this.distChildren != null) {
            if (i >= 0 && i < this.distChildren.length) {
                return this.distChildren[i];
            }
            return 0.0f;
        }
        return 0.0f;
    }

    public boolean removeChild(int childId) {
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != childId) continue;
            this.children[i] = -1;
            return true;
        }
        return false;
    }

    public void setChildrenId(int i, int id) {
        if (i >= 0) {
            if (this.children == null) {
                this.children = new int[2];
                for (int k = 0; k < this.children.length; ++k) {
                    this.children[k] = -1;
                }
            }
            if (i < this.children.length) {
                this.children[i] = id;
            } else {
                int[] temp = new int[this.children.length];
                System.arraycopy(this.children, 0, temp, 0, this.children.length);
                this.children = new int[3];
                System.arraycopy(temp, 0, this.children, 0, temp.length);
                this.children[2] = id;
            }
        }
    }

    public int getChildrenId(int i) {
        if (this.children != null) {
            if (i >= 0 && i < this.children.length) {
                return this.children[i];
            }
            return -1;
        }
        return -1;
    }

    public int getChildrenIndex(int id) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                if (this.children[i] != id) continue;
                return i;
            }
            return -1;
        }
        return -1;
    }

    public float getKlass() {
        return this.cdata;
    }

    public void setKlass(float c) {
        this.cdata = c;
    }

    public String toString() {
        return this.id + ":(" + (this.valid ? "valid" : "non-valid") + ")";
    }

    public int getRecursiveChildCount() {
        return this.recursiveChildCount;
    }

    public void setRecursiveChildCount(int recursiveChildCount) {
        this.recursiveChildCount = recursiveChildCount;
    }
}

