/*
 * Decompiled with CFR 0.152.
 */
package simpletree.basics;

import java.io.IOException;
import simpletree.basics.Ref;
import simpletree.basics.SimpleTree;
import simpletree.layout.radial.RadialLayoutComp;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;
import simpletree.model.SimpleTreeModel;
import simpletree.model.SimpleTreeModelComp;
import simpletree.view.SimpleTreeFrameComp;

public class NewickTree {
    NewickTree left;
    NewickTree right;
    String name;
    float branch_length;

    public NewickTree() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NewickTree(Ref ref, String newick_string) {
        System.out.println("Recursive Descent Newick Tree Parser, adapted from Eddie Yee Tak Ma, in http://eddiema.ca/2010/06/25/parsing-a-newick-tree-with-recursive-descent/");
        try {
            if (ref == null) {
                ref = new Ref();
                ref.cursor = 0;
            }
            if (newick_string.charAt(ref.cursor) == '(') {
                ++ref.cursor;
                if (newick_string.charAt(ref.cursor) == '(') {
                    this.left = new NewickTree(ref, newick_string);
                } else {
                    String lname = newick_string.substring(ref.cursor, newick_string.indexOf(":", ref.cursor));
                    if (lname != null && !lname.isEmpty()) {
                        this.left = new NewickTree();
                        this.left.name = lname;
                        ref.cursor += lname.length();
                    }
                }
            }
            String branch_length_string = "";
            if (newick_string.charAt(ref.cursor) == ':') {
                ++ref.cursor;
                if (newick_string.indexOf(",", ref.cursor) != -1) {
                    branch_length_string = newick_string.substring(ref.cursor, newick_string.indexOf(",", ref.cursor));
                } else if (newick_string.indexOf(")", ref.cursor) != -1) {
                    branch_length_string = newick_string.substring(ref.cursor, newick_string.indexOf(")", ref.cursor));
                }
                try {
                    this.left.branch_length = Float.parseFloat(branch_length_string);
                }
                catch (NumberFormatException e) {
                    if (newick_string.indexOf(")", ref.cursor) != -1) {
                        branch_length_string = newick_string.substring(ref.cursor, newick_string.indexOf(")", ref.cursor));
                    } else if (newick_string.indexOf(",", ref.cursor) != -1) {
                        branch_length_string = newick_string.substring(ref.cursor, newick_string.indexOf(",", ref.cursor));
                    }
                    try {
                        this.left.branch_length = Float.parseFloat(branch_length_string);
                    }
                    catch (NumberFormatException e1) {
                        System.out.println("Could not parse string [" + branch_length_string + "]");
                        this.left.branch_length = 0.0f;
                    }
                }
                ref.cursor += branch_length_string.length();
            }
            if (newick_string.charAt(ref.cursor) == ',') {
                ++ref.cursor;
                if (newick_string.charAt(ref.cursor) == '(') {
                    this.right = new NewickTree(ref, newick_string);
                } else {
                    String rname = newick_string.substring(ref.cursor, newick_string.indexOf(":", ref.cursor));
                    if (rname != null && !rname.isEmpty()) {
                        this.right = new NewickTree();
                        this.right.name = rname;
                        ref.cursor += rname.length();
                    }
                }
            }
            if (newick_string.charAt(ref.cursor) == ':') {
                ++ref.cursor;
                if (newick_string.indexOf(")", ref.cursor) != -1) {
                    branch_length_string = newick_string.substring(ref.cursor, newick_string.indexOf(")", ref.cursor));
                } else if (newick_string.indexOf(",", ref.cursor) != -1) {
                    branch_length_string = newick_string.substring(ref.cursor, newick_string.indexOf(",", ref.cursor));
                }
                try {
                    this.right.branch_length = Float.parseFloat(branch_length_string);
                }
                catch (NumberFormatException e) {
                    if (newick_string.indexOf(",", ref.cursor) != -1) {
                        branch_length_string = newick_string.substring(ref.cursor, newick_string.indexOf(",", ref.cursor));
                    } else if (newick_string.indexOf(")", ref.cursor) != -1) {
                        branch_length_string = newick_string.substring(ref.cursor, newick_string.indexOf(")", ref.cursor));
                    }
                    try {
                        this.right.branch_length = Float.parseFloat(branch_length_string);
                    }
                    catch (NumberFormatException e1) {
                        System.out.println("Could not parse string [" + branch_length_string + "]");
                        this.right.branch_length = 0.0f;
                    }
                }
                ref.cursor += branch_length_string.length();
            }
            if (newick_string.charAt(ref.cursor) == ')') {
                ++ref.cursor;
            }
            String pname = "";
            if (newick_string.indexOf(":", ref.cursor) != -1) {
                pname = newick_string.substring(ref.cursor, newick_string.indexOf(":", ref.cursor));
            } else if (newick_string.indexOf(";", ref.cursor) != -1) {
                pname = newick_string.substring(ref.cursor, newick_string.indexOf(";", ref.cursor));
            }
            if (pname != null && !pname.isEmpty()) {
                this.name = pname;
                ref.cursor += pname.length();
            }
            if (newick_string.charAt(ref.cursor) == ':') {
                ++ref.cursor;
                if (newick_string.indexOf(",", ref.cursor) != -1) {
                    branch_length_string = newick_string.substring(ref.cursor, newick_string.indexOf(",", ref.cursor));
                } else if (newick_string.indexOf(")", ref.cursor) != -1) {
                    branch_length_string = newick_string.substring(ref.cursor, newick_string.indexOf(")", ref.cursor));
                }
                try {
                    this.branch_length = Float.parseFloat(branch_length_string);
                }
                catch (NumberFormatException e) {
                    if (newick_string.indexOf(")", ref.cursor) != -1) {
                        branch_length_string = newick_string.substring(ref.cursor, newick_string.indexOf(")", ref.cursor));
                    } else if (newick_string.indexOf(",", ref.cursor) != -1) {
                        branch_length_string = newick_string.substring(ref.cursor, newick_string.indexOf(",", ref.cursor));
                    }
                    try {
                        this.branch_length = Float.parseFloat(branch_length_string);
                    }
                    catch (NumberFormatException e2) {
                        System.out.println("Could not parse string [" + branch_length_string + "]");
                        this.branch_length = 0.0f;
                    }
                }
                ref.cursor += branch_length_string.length();
            }
            if (newick_string.charAt(ref.cursor) == ';') {
                ++ref.cursor;
                if (this.right == null && this.left != null) {
                    this.left = this.left.left;
                    this.right = this.left.right;
                    this.branch_length = this.left.branch_length;
                }
            }
            if (ref.cursor < newick_string.length()) return;
        }
        catch (Exception e1) {
            System.out.println("Could not parse string");
        }
    }

    public float getDistParent(String name, NewickTree n) {
        if (n.name.equalsIgnoreCase(name)) {
            return n.branch_length;
        }
        if (n.left != null) {
            float t = this.getDistParent(name, n.left);
            if (t != -1.0f) {
                return t;
            }
            return this.getDistParent(name, n.right);
        }
        return -1.0f;
    }

    public static void main(String[] a) throws IOException {
        String n = "(((((97:1.0,98:4.0)6:1.0,99:2.0)7:1.0,102:5.0)8:1.0,101:2.0)9:1.5,100:1.5)10;";
        Ref ref = null;
        NewickTree nw = new NewickTree(ref, n);
        boolean x = true;
        SimpleTree sTree = new SimpleTree("/home/renato/test.newick");
        SimpleTreeModelComp sTreeModelC = new SimpleTreeModelComp();
        sTreeModelC.input(sTree);
        sTreeModelC.execute();
        SimpleTreeModel stModel = sTreeModelC.output();
        RadialLayoutComp layout = new RadialLayoutComp();
        layout.input(stModel);
        layout.execute();
        stModel = layout.output();
        SimpleTreeFrameComp frameComp = new SimpleTreeFrameComp();
        AbstractMatrix matrix = MatrixFactory.getInstance("/home/renato/ImagensCorel.data");
        frameComp.input(matrix);
        frameComp.input(stModel);
        frameComp.execute();
    }
}

