/*
 * Decompiled with CFR 0.152.
 */
package simpletree.basics.color;

import java.awt.Color;
import java.io.IOException;

public abstract class ColorScale {
    private float min = 0.0f;
    private float max = 1.0f;
    private boolean reverse = false;
    protected Color[] colors;

    public Color getColor(float value) {
        if (this.reverse) {
            int minindex = (int)((float)(this.colors.length - 1) * (1.0f - this.min));
            int maxindex = (int)((float)(this.colors.length - 1) * (1.0f - this.max));
            int index = (int)((float)Math.abs(minindex - maxindex) * (1.0f - value)) + maxindex;
            return this.colors[index];
        }
        int minindex = (int)((float)(this.colors.length - 1) * this.min);
        int maxindex = (int)((float)(this.colors.length - 1) * this.max);
        int index = Math.round((float)Math.abs(maxindex - minindex) * value) + minindex;
        return this.colors[index];
    }

    public int getNumberColors() {
        return this.colors.length;
    }

    public float getMin() {
        return this.min;
    }

    public void setMinMax(float min, float max) throws IOException {
        if (!(max >= min)) {
            throw new IOException("The min value of color should be smaller than max value");
        }
        this.max = max;
        this.min = min;
    }

    public float getMax() {
        return this.max;
    }

    public boolean isReverse() {
        return this.reverse;
    }

    public void setReverse(boolean reverse) {
        this.reverse = reverse;
    }
}

