/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.clustering;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.datamining.clustering.Clustering;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.MatrixFactory;
import simpletree.matrix.util.MatrixUtils;

public class Kmeans
extends Clustering {
    public int[] instClusters;
    private ArrayList<ArrayList<Integer>> clusters = new ArrayList();
    private AbstractMatrix centroids;
    private int nriterations = 1000;

    public Kmeans(int nrclusters) {
        super(nrclusters);
    }

    @Override
    public ArrayList<ArrayList<Integer>> execute(AbstractDissimilarity diss, AbstractMatrix matrix) throws IOException {
        try {
            int i;
            this.nrclusters = Math.min(this.nrclusters, matrix.getRowCount());
            long init = System.currentTimeMillis();
            this.centroids = MatrixFactory.getInstance(matrix.getClass());
            this.instClusters = new int[matrix.getRowCount()];
            Arrays.fill(this.instClusters, -1);
            int slop = Math.max((matrix.getRowCount() - 1) / this.nrclusters, 1);
            for (i = 0; i < this.nrclusters; ++i) {
                this.centroids.addRow((AbstractVector)matrix.getRow(i * slop).clone());
            }
            for (int it = 0; it < this.nriterations; ++it) {
                int i2;
                this.clusters.clear();
                Arrays.fill(this.instClusters, -1);
                for (i2 = 0; i2 < this.nrclusters; ++i2) {
                    this.clusters.add(new ArrayList());
                }
                for (int point = 0; point < matrix.getRowCount(); ++point) {
                    int nearest = 0;
                    float mindist = Float.MAX_VALUE;
                    for (int cluster = 0; cluster < this.nrclusters; ++cluster) {
                        AbstractVector pointVector;
                        float dist;
                        AbstractVector centroidVector = this.centroids.getRow(cluster);
                        if (centroidVector.getValues().length == 0) {
                            System.out.println("!!!!");
                        }
                        if (!(mindist > (dist = diss.calculate(pointVector = matrix.getRow(point), centroidVector)))) continue;
                        nearest = cluster;
                        mindist = dist;
                    }
                    this.clusters.get(nearest).add(point);
                    this.instClusters[point] = nearest;
                }
                for (i2 = 0; i2 < this.clusters.size(); ++i2) {
                    if (this.clusters.get(i2).size() != 0) continue;
                    int instanceIndex = (int)(Math.random() * (double)(matrix.getRowCount() - 1));
                    int oldCluster = this.instClusters[instanceIndex];
                    while (this.clusters.get(oldCluster).size() <= 1) {
                        instanceIndex = (int)(Math.random() * (double)(matrix.getRowCount() - 1));
                        oldCluster = this.instClusters[instanceIndex];
                    }
                    this.centroids.setRow(i2, (AbstractVector)matrix.getRow(instanceIndex).clone());
                    this.clusters.get(i2).add(instanceIndex);
                    if (this.instClusters[instanceIndex] == -1) continue;
                    ArrayList<Integer> cluster = this.clusters.get(oldCluster);
                    cluster.remove(new Integer(instanceIndex));
                    this.instClusters[instanceIndex] = i2;
                }
                this.updateCentroids(matrix);
            }
            for (i = this.clusters.size() - 1; i >= 0; --i) {
                if (!this.clusters.get(i).isEmpty()) continue;
                this.clusters.remove(i);
                this.centroids.removeRow(i);
            }
            long end = System.currentTimeMillis();
            long diff = end - init;
            return this.clusters;
        }
        catch (CloneNotSupportedException ex) {
            Logger.getLogger(Kmeans.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public ArrayList<ArrayList<Integer>> execute(DistanceMatrix dmat) throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public AbstractMatrix getCentroids() {
        return this.centroids;
    }

    public int[] getMedoids(AbstractMatrix matrix, AbstractDissimilarity diss) throws IOException {
        int[] m = new int[this.centroids.getRowCount()];
        for (int i = 0; i < m.length; ++i) {
            int point = -1;
            float distance = Float.MAX_VALUE;
            for (int j = 0; j < this.clusters.get(i).size(); ++j) {
                float distance2 = diss.calculate(this.centroids.getRow(i), matrix.getRow(this.clusters.get(i).get(j)));
                if (!(distance > distance2)) continue;
                point = this.clusters.get(i).get(j);
                distance = distance2;
            }
            m[i] = point;
        }
        return m;
    }

    public void setNumberIterations(int nriterations) {
        this.nriterations = nriterations;
    }

    private void updateCentroids(AbstractMatrix matrix) throws IOException {
        this.centroids = MatrixFactory.getInstance(matrix.getClass());
        for (int cluster = 0; cluster < this.nrclusters; ++cluster) {
            AbstractMatrix vectors = MatrixFactory.getInstance(matrix.getClass());
            for (int el = 0; el < this.clusters.get(cluster).size(); ++el) {
                vectors.addRow(matrix.getRow(this.clusters.get(cluster).get(el)));
            }
            AbstractVector centroid = MatrixUtils.mean(vectors);
            this.centroids.addRow(centroid);
        }
    }
}

