/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.clustering;

import java.io.IOException;
import java.util.ArrayList;
import simpletree.datamining.clustering.Clustering;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.matrix.AbstractMatrix;

public class Kmedoids
extends Clustering {
    private int[] medoids;

    public Kmedoids(int nrclusters) {
        super(nrclusters);
        this.medoids = new int[nrclusters];
    }

    @Override
    public ArrayList<ArrayList<Integer>> execute(AbstractDissimilarity diss, AbstractMatrix matrix) throws IOException {
        DistanceMatrix dmat = new DistanceMatrix(matrix, diss);
        return this.execute(dmat);
    }

    @Override
    public ArrayList<ArrayList<Integer>> execute(DistanceMatrix dmat) throws IOException {
        ArrayList<ArrayList<Integer>> clusters = new ArrayList<ArrayList<Integer>>();
        for (int i = 0; i < this.nrclusters; ++i) {
            clusters.add(new ArrayList());
        }
        int[] oldMedoids = new int[this.nrclusters];
        for (int i = 0; i < this.nrclusters; ++i) {
            this.medoids[i] = i * (dmat.getElementCount() / this.nrclusters);
        }
        boolean medoidModified = true;
        for (int nroIterations = 0; medoidModified && nroIterations < dmat.getElementCount(); ++nroIterations) {
            int numberElements = Integer.MAX_VALUE;
            for (int point = 0; point < dmat.getElementCount(); ++point) {
                int nearestCluster = 0;
                float distance = dmat.getDistance(point, this.medoids[nearestCluster]);
                for (int cluster = 1; cluster < clusters.size(); ++cluster) {
                    float distance2 = dmat.getDistance(point, this.medoids[cluster]);
                    if (distance > distance2) {
                        nearestCluster = cluster;
                        distance = distance2;
                        continue;
                    }
                    if (distance != distance2 || numberElements <= clusters.get(cluster).size()) continue;
                    numberElements = clusters.get(cluster).size() + 1;
                    nearestCluster = cluster;
                    distance = distance2;
                }
                clusters.get(nearestCluster).add(point);
            }
            oldMedoids = this.medoids;
            this.updateMedoids(dmat, clusters);
            medoidModified = this.isMedoidModified(oldMedoids);
        }
        return clusters;
    }

    public int[] getMedoids() {
        return this.medoids;
    }

    private void updateMedoids(DistanceMatrix dmat, ArrayList<ArrayList<Integer>> clusters) {
        for (int cluster = 0; cluster < clusters.size(); ++cluster) {
            int medoid = clusters.get(cluster).get(0);
            float sumDistances = dmat.getMaxDistance();
            for (int point = 0; point < clusters.get(cluster).size(); ++point) {
                float sumDistances2 = 0.0f;
                for (int point2 = 0; point2 < clusters.get(cluster).size(); ++point2) {
                    sumDistances2 += dmat.getDistance(clusters.get(cluster).get(point), clusters.get(cluster).get(point2));
                }
                if (!(sumDistances > (sumDistances2 /= (float)clusters.get(cluster).size()))) continue;
                sumDistances = sumDistances2;
                medoid = clusters.get(cluster).get(point);
            }
            this.medoids[cluster] = medoid;
        }
    }

    private boolean isMedoidModified(int[] oldMedoids) {
        for (int medoid = 0; medoid < oldMedoids.length; ++medoid) {
            if (oldMedoids[medoid] == this.medoids[medoid]) continue;
            return true;
        }
        return false;
    }

    @Override
    public AbstractMatrix getCentroids() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

