/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.clustering.isodata;

import java.util.ArrayList;
import simpletree.matrix.AbstractVector;

public class Group {
    private float number;
    private AbstractVector meanPoint;
    private float meanDistance;
    private ArrayList<Integer> ids;

    public Group(int number) {
        this.number = number;
    }

    public void setMeanPoint(AbstractVector meanPoint) {
        this.meanPoint = meanPoint;
    }

    public AbstractVector getMeanPoint() {
        return this.meanPoint;
    }

    public float getNumber() {
        return this.number;
    }

    public void setNumber(float number) {
        this.number = number;
    }

    public float getMeanDistance() {
        return this.meanDistance;
    }

    public void setMeanDistance(float meanDistance) {
        this.meanDistance = meanDistance;
    }

    public ArrayList<Integer> getIds() {
        return this.ids;
    }

    public int getSize() {
        if (this.ids == null) {
            return 0;
        }
        return this.ids.size();
    }

    public void addId(int id) {
        if (this.ids == null) {
            this.ids = new ArrayList();
        }
        this.ids.add(id);
    }

    public String toString() {
        StringBuilder sbuf = new StringBuilder("groups[" + (this.number + 1.0f) + "], mean point");
        sbuf.append("(");
        float[] values = this.meanPoint.getValues();
        for (int i = 0; i < values.length; ++i) {
            sbuf.append(values[i]);
            if (i == values.length - 1) continue;
            sbuf.append(", ");
        }
        sbuf.append(")");
        return sbuf.toString();
    }
}

