/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.clustering.isodata;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import simpletree.datamining.clustering.isodata.SamplePoint;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.MatrixFactory;
import simpletree.matrix.dense.DenseMatrix;

public class Utils {
    public static AbstractMatrix readSamplePoints(String file) throws Exception {
        AbstractMatrix points = MatrixFactory.getInstance(file);
        return points;
    }

    public static List<SamplePoint> readLabeledSamplePoints(String file) throws Exception {
        ArrayList<SamplePoint> points = new ArrayList<SamplePoint>();
        System.out.println("\u00b6\u00c1\u00c8\u00a1\u00ca\u00fd\u00be\u00dd\u00ce\u00c4\u00bc\u00fe...");
        BufferedReader in = new BufferedReader(new FileReader(file));
        String line = "";
        int linecount = 0;
        while ((line = in.readLine()) != null) {
            StringTokenizer st = new StringTokenizer(line, " \t\n\r\f,");
            float[] values = new float[st.countTokens()];
            SamplePoint point = new SamplePoint(++linecount, values);
            for (int i = 0; i < values.length; ++i) {
                if (i == values.length - 1) {
                    values[i] = 1.0f;
                    int groupNumber = Integer.parseInt(st.nextToken());
                    point.setGroupNumber(groupNumber);
                    continue;
                }
                values[i] = Float.parseFloat(st.nextToken());
            }
            points.add(point);
            System.out.println(point);
        }
        in.close();
        return points;
    }

    public static AbstractMatrix hashObject(Float key, AbstractVector obj, Map<Float, AbstractMatrix> mapObjs) {
        AbstractMatrix objList = mapObjs.get(key);
        if (objList == null) {
            objList = new DenseMatrix();
            mapObjs.put(key, objList);
        }
        objList.addRow(obj);
        return objList;
    }
}

