/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.clustering.multiscale;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.MatrixFactory;
import simpletree.matrix.dense.DenseVector;

public class Cluster {
    private int id = 0;
    private ArrayList<Cluster> subClusterList;
    private ArrayList<Integer> itemList;
    private ArrayList<Integer> medoidList;
    private DenseVector centroidVector;
    private int size;
    private int levelHeight = 1;

    public Cluster(int id) {
        this.id = id;
        this.itemList = new ArrayList();
        this.subClusterList = new ArrayList();
        this.medoidList = new ArrayList();
    }

    public Cluster clone() {
        Cluster newCluster = new Cluster(this.id);
        newCluster.itemList.addAll(this.itemList);
        newCluster.medoidList.addAll(this.medoidList);
        newCluster.size = this.size;
        newCluster.levelHeight = this.levelHeight;
        ArrayList<Cluster> newSubClusterList = new ArrayList<Cluster>();
        if (this.subClusterList != null && !this.subClusterList.isEmpty()) {
            for (Cluster subCluster : this.subClusterList) {
                newSubClusterList.add(subCluster.clone());
            }
        }
        newCluster.setSubClusterList(newSubClusterList);
        return newCluster;
    }

    public DenseVector getCentroidVector() {
        return this.centroidVector;
    }

    public void setCentroidVector(DenseVector centroidVector) {
        this.centroidVector = centroidVector;
    }

    public int getLevelHeight() {
        return this.levelHeight;
    }

    public void setLevelHeight(int levelHeight) {
        this.levelHeight = levelHeight;
    }

    public String toString() {
        return Integer.toString(this.id);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public List<Cluster> getSubClusterList() {
        return this.subClusterList;
    }

    public void setSubClusterList(ArrayList<Cluster> subClusterList) {
        this.subClusterList = subClusterList;
    }

    public ArrayList<Integer> getItemList() {
        return this.itemList;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setItemList(ArrayList<Integer> itemList) {
        this.itemList = itemList;
    }

    public List<Integer> getMedoidList() {
        return this.medoidList;
    }

    public void setMedoidList(ArrayList<Integer> medoidList) {
        this.medoidList = medoidList;
    }

    public AbstractMatrix getClusterPointsMatrix(AbstractMatrix matrix) {
        AbstractMatrix clusterMatrix = null;
        try {
            clusterMatrix = MatrixFactory.getInstance(matrix.getClass());
            ArrayList<String> labels = new ArrayList<String>();
            for (Integer clusterItem : this.itemList) {
                AbstractVector vector = matrix.getRow(clusterItem);
                clusterMatrix.addRow(vector);
                labels.add(matrix.getLabel(clusterItem));
            }
            clusterMatrix.setLabels(labels);
            clusterMatrix.setAttributes(matrix.getAttributes());
        }
        catch (IOException e) {
            System.err.println("Error on building cluster matrix!" + e.getMessage());
        }
        return clusterMatrix;
    }
}

