/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.clustering.multiscale;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.datamining.clustering.BKmeans;
import simpletree.datamining.clustering.Clustering;
import simpletree.datamining.clustering.HierarchicalClustering;
import simpletree.datamining.clustering.Jdbscan2D;
import simpletree.datamining.clustering.Kmeans;
import simpletree.datamining.clustering.Kmedoids;
import simpletree.datamining.clustering.isodata.Group;
import simpletree.datamining.clustering.isodata.IsoData;
import simpletree.datamining.clustering.javaml.KmedoidsJavaML;
import simpletree.datamining.clustering.multiscale.Cluster;
import simpletree.datamining.clustering.multiscale.DistanceElementPair;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.MatrixFactory;
import simpletree.matrix.dense.DenseVector;

public class MultiscaleClustering {
    private Logger logger = Logger.getLogger(MatrixFactory.class.getName());
    private int nrMedoids = 5;
    private AbstractDissimilarity diss;
    public int minLevelSize = 5;
    public float levelFraction = 0.0f;
    public static String clusteringParams;
    public static boolean verbose;
    private int maxId;
    private int totalElementCount;
    private int currentElementCount;
    private long initTime;
    private int clusteringLevel;
    public static final int CLUSTER_OK = 0;
    public static final int CLUSTER_SIZE_ERROR = 1;
    public static final int CLUSTER_ITEM_INDEX_ERROR = 2;
    public static final int CLUSTER_MEDOID_INDEX_ERROR = 4;

    public static void print(String msg) {
        if (verbose) {
            System.out.println(msg);
        }
    }

    public static void printErr(String msg) {
        if (verbose) {
            System.err.println(msg);
        }
    }

    public List<Cluster> clusterize(AbstractMatrix dataMatrix, Clustering clusteringTechnique, AbstractDissimilarity dissimilarity, int maxClusterSize, boolean clustersFromClasses, int numMedoids) throws IOException {
        this.clusteringLevel = 0;
        this.nrMedoids = numMedoids;
        this.diss = dissimilarity;
        this.totalElementCount = dataMatrix.getRowCount();
        this.maxId = dataMatrix.getRows().size();
        this.initTime = System.currentTimeMillis();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Date date = new Date(this.initTime);
        MultiscaleClustering.print("[" + sdf.format(date) + "] Beginning multiscale clustering...");
        ArrayList<Cluster> clusterList = this.getClustersRecursive(dataMatrix, clusteringTechnique, this.diss, maxClusterSize, clustersFromClasses);
        for (Cluster cluster : clusterList) {
            AbstractMatrix clusterMatrix = cluster.getClusterPointsMatrix(dataMatrix);
            date = new Date(System.currentTimeMillis());
            MultiscaleClustering.print(String.format("[" + sdf.format(date) + "] Getting Cluster %d medoids...\n", cluster.getId()));
            ArrayList<Integer> newMedoidList = this.processMedoidsRecursive(cluster, dataMatrix);
            cluster.setMedoidList(newMedoidList);
            date = new Date(System.currentTimeMillis());
            MultiscaleClustering.print(String.format("[" + sdf.format(date) + "]Syncing subclusters indices (elements and medoids)...\n", new Object[0]));
            for (Cluster subCluster : cluster.getSubClusterList()) {
                this.syncClusterIds(subCluster, clusterMatrix, dataMatrix);
            }
            Stack<Cluster> clusterStack = new Stack<Cluster>();
            clusterStack.add(cluster);
            while (!clusterStack.isEmpty()) {
                Cluster currentCluster = (Cluster)clusterStack.pop();
                if (currentCluster.getSubClusterList().isEmpty()) continue;
                currentCluster.getItemList().clear();
                for (Cluster subCluster : currentCluster.getSubClusterList()) {
                    clusterStack.add(subCluster);
                }
            }
        }
        long endTime = System.currentTimeMillis();
        date = new Date(endTime);
        MultiscaleClustering.print(sdf.format(date) + " Finished multiscale clustering...");
        MultiscaleClustering.print("The process took " + (float)(endTime - this.initTime) / 1000.0f + " seconds.");
        return clusterList;
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<Cluster> getClustersRecursive(AbstractMatrix matrix, Clustering clusteringTechnique, AbstractDissimilarity diss, int maxClusterSize, boolean clustersFromClasses) throws IOException {
        void var9_20;
        ArrayList<Object> clusters = new ArrayList();
        if (clustersFromClasses) {
            MultiscaleClustering.print(String.format("[Clustering - Level %d] Getting classes as clusters...\n", this.clusteringLevel));
            ArrayList<Float> klasses = new ArrayList<Float>();
            for (int i = 0; i < matrix.getRowCount(); ++i) {
                AbstractVector abstractVector = matrix.getRow(i);
                if (!klasses.contains(Float.valueOf(abstractVector.getKlass()))) {
                    clusters.add(new ArrayList());
                    klasses.add(Float.valueOf(abstractVector.getKlass()));
                }
                ((ArrayList)clusters.get(klasses.indexOf(Float.valueOf(abstractVector.getKlass())))).add(i);
            }
        } else if (clusteringTechnique instanceof Jdbscan2D) {
            clusters = clusteringTechnique.execute(diss, matrix);
            float eps = ((Jdbscan2D)clusteringTechnique).getEps();
            while (clusters == null || clusters.size() < 2) {
                MultiscaleClustering.print("DBScan clustering (EPS = " + eps + ") generated a single cluster. Trying with eps = " + (eps - 0.1f));
                clusteringTechnique = new Jdbscan2D(eps -= 0.01f);
                clusters = clusteringTechnique.execute(diss, matrix);
            }
        } else {
            if (clusteringTechnique instanceof Kmeans && this.levelFraction > 0.0f) {
                int numclusters = Math.max((int)Math.ceil((float)matrix.getRowCount() * this.levelFraction), this.minLevelSize);
                MultiscaleClustering.print(String.format("Clustering using matrix fraction: F = %.3f, K = %d\n", Float.valueOf(this.levelFraction), numclusters));
                try {
                    clusteringTechnique = new Kmeans(numclusters);
                }
                catch (Exception ex) {
                    Logger.getLogger(MultiscaleClustering.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            MultiscaleClustering.print(String.format("[Clustering - Level %d - Id %d] Clustering %d elements...\n", this.clusteringLevel, this.maxId, matrix.getRowCount()));
            clusters = clusteringTechnique.execute(diss, matrix);
            if (clusters.size() == 1) {
                MultiscaleClustering.printErr("WARNING: All instances fell into a single cluster... Using K-Medoids...");
                try {
                    KmedoidsJavaML kmedoids = new KmedoidsJavaML(Integer.valueOf(clusteringParams));
                    clusters = kmedoids.execute(diss, matrix);
                    MultiscaleClustering.print(clusters.size() + " clusters after K-Medoids...");
                }
                catch (Exception ex) {
                    Logger.getLogger(MultiscaleClustering.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        int clustersElementsCount = 0;
        for (ArrayList arrayList : clusters) {
            clustersElementsCount += arrayList.size();
        }
        if (clustersElementsCount != matrix.getRowCount()) {
            MultiscaleClustering.printErr("[Cluster Id " + this.maxId + "]: Error! Clustering output size is different from the original matrix.");
            MultiscaleClustering.printErr(String.format("Original matrix = %d, Clustering result = %d\n", matrix.getRowCount(), clustersElementsCount));
            System.exit(0);
        }
        ArrayList<Cluster> clusterList = new ArrayList<Cluster>();
        boolean bl = false;
        while (var9_20 < clusters.size()) {
            Cluster cluster = new Cluster(this.maxId);
            ++this.maxId;
            ArrayList<Integer> clusterElements = new ArrayList<Integer>();
            clusterElements.addAll((Collection)clusters.get((int)var9_20));
            cluster.setItemList(clusterElements);
            cluster.setSize(clusterElements.size());
            clusterList.add(cluster);
            ++var9_20;
        }
        for (Cluster cluster : clusterList) {
            if (cluster.getSize() > maxClusterSize) {
                MultiscaleClustering.print(String.format("[Cluster Id %d, Level %d, Size %d] Re-clustering...\n", cluster.getId(), this.clusteringLevel, cluster.getSize()));
                AbstractMatrix clusterPoints = cluster.getClusterPointsMatrix(matrix);
                ++this.clusteringLevel;
                ArrayList<Cluster> subClusterList = this.getClustersRecursive(clusterPoints, clusteringTechnique, diss, maxClusterSize, false);
                --this.clusteringLevel;
                cluster.setSubClusterList(subClusterList);
                int maxHeight = 0;
                for (Cluster subCluster : subClusterList) {
                    if (maxHeight >= subCluster.getLevelHeight()) continue;
                    maxHeight = subCluster.getLevelHeight();
                }
                cluster.setLevelHeight(maxHeight + 1);
                MultiscaleClustering.print(String.format("[Cluster Id %d, Level %d, Size %d] Finished\n", cluster.getId(), this.clusteringLevel, cluster.getSize()));
                continue;
            }
            this.currentElementCount += cluster.getSize();
            float progress = (float)this.currentElementCount / (float)this.totalElementCount * 100.0f;
            MultiscaleClustering.print(String.format("[Cluster Id %d, Level %d, Size %d] Progress: %d/%d elements processed...%d%%\n", cluster.getId(), this.clusteringLevel, cluster.getSize(), this.currentElementCount, this.totalElementCount, (int)progress));
        }
        return clusterList;
    }

    private int getBestMedoid(List<Integer> medoidList, AbstractMatrix matrix) {
        TreeMap<Float, Integer> medoidDistanceMap = new TreeMap<Float, Integer>();
        DenseVector vector = this.getClusterCentroid(matrix, medoidList);
        for (Integer i : medoidList) {
            AbstractVector vector2 = matrix.getRow(i);
            float distance = this.diss.calculate(vector, vector2);
            medoidDistanceMap.put(Float.valueOf(distance), i);
        }
        return (Integer)medoidDistanceMap.get(medoidDistanceMap.firstKey());
    }

    private ArrayList<Integer> processMedoidsRecursive(Cluster cluster, AbstractMatrix upperLevelMatrix) throws IOException {
        ++this.clusteringLevel;
        DenseVector centroidVector = this.getClusterCentroid(upperLevelMatrix, cluster.getItemList());
        cluster.setCentroidVector(centroidVector);
        ArrayList<Integer> newMedoidList = new ArrayList<Integer>();
        if (cluster.getSubClusterList().isEmpty()) {
            DenseVector clusterCentroid = this.getClusterCentroid(upperLevelMatrix, cluster.getItemList());
            newMedoidList = this.getClusterMedoids(this.nrMedoids, upperLevelMatrix, this.diss, clusterCentroid, cluster.getItemList());
            cluster.setMedoidList(newMedoidList);
        } else {
            AbstractMatrix clusterMatrix = cluster.getClusterPointsMatrix(upperLevelMatrix);
            for (Cluster subCluster : cluster.getSubClusterList()) {
                ArrayList<Integer> newSubClusterMedoids = this.processMedoidsRecursive(subCluster, clusterMatrix);
                int subClusterMedoid = this.getBestMedoid(newSubClusterMedoids, clusterMatrix);
                ArrayList<Integer> newSubClusterMedoidList = new ArrayList<Integer>();
                newSubClusterMedoidList.add(subClusterMedoid);
                AbstractMatrix subClusterMatrix = subCluster.getClusterPointsMatrix(clusterMatrix);
                try {
                    this.syncItemsIds(newSubClusterMedoidList, clusterMatrix, upperLevelMatrix);
                }
                catch (IndexOutOfBoundsException e) {
                    MultiscaleClustering.printErr(String.format("Error processing medoids of clusterId " + cluster.getId(), new Object[0]));
                    throw e;
                }
                subClusterMedoid = newSubClusterMedoidList.get(0);
                newMedoidList.add(subClusterMedoid);
            }
            cluster.setMedoidList(newMedoidList);
        }
        --this.clusteringLevel;
        return newMedoidList;
    }

    private void syncItemsIds(List<Integer> idsList, AbstractMatrix currMatrix, AbstractMatrix originalMatrix) {
        for (int i = 0; i < idsList.size(); ++i) {
            AbstractVector pointCurrMatrix = currMatrix.getRow(idsList.get(i));
            int originalMatrixRow = this.getMatrixRow(pointCurrMatrix, originalMatrix);
            idsList.set(i, originalMatrixRow);
        }
    }

    private int getMatrixRow(AbstractVector vector, AbstractMatrix matrix) {
        int matrixRow = -1;
        for (int i = 0; i < matrix.getRowCount(); ++i) {
            if (vector.getId() != matrix.getRow(i).getId()) continue;
            matrixRow = i;
            break;
        }
        return matrixRow;
    }

    private void syncClusterIds(Cluster cluster, AbstractMatrix upperLevelMatrix, AbstractMatrix originalMatrix) throws IOException {
        AbstractMatrix clusterMatrix = cluster.getClusterPointsMatrix(upperLevelMatrix);
        if (cluster.getMedoidList().size() > 0) {
            this.syncItemsIds(cluster.getMedoidList(), upperLevelMatrix, originalMatrix);
        }
        if (cluster.getItemList().size() > 0 && cluster.getSubClusterList().isEmpty()) {
            this.syncItemsIds(cluster.getItemList(), upperLevelMatrix, originalMatrix);
        }
        for (Cluster subCluster : cluster.getSubClusterList()) {
            this.syncClusterIds(subCluster, clusterMatrix, originalMatrix);
        }
    }

    private DenseVector getClusterCentroid(AbstractMatrix matrix, List<Integer> clusterElements) {
        float[] vector = new float[matrix.getDimensions()];
        for (int j = 0; j < clusterElements.size(); ++j) {
            AbstractVector v = matrix.getRow(clusterElements.get(j));
            if (v == null) continue;
            for (int k = 0; k < v.size(); ++k) {
                int n = k;
                vector[n] = vector[n] + v.getValue(k);
            }
        }
        int k = 0;
        while (k < vector.length) {
            int n = k++;
            vector[n] = vector[n] / (float)clusterElements.size();
        }
        DenseVector centroid = new DenseVector(vector, this.maxId + 1);
        ++this.maxId;
        return centroid;
    }

    private ArrayList<Integer> getClusterMedoids(int nrMedoids, AbstractMatrix clusterMatrix, AbstractDissimilarity diss, AbstractVector centroid, List<Integer> clusterItems) {
        ArrayList<Integer> medoidList = new ArrayList<Integer>();
        ArrayList<DistanceElementPair> medoidDistanceList = new ArrayList<DistanceElementPair>();
        for (Integer clusterItem : clusterItems) {
            AbstractVector itemVector = clusterMatrix.getRow(clusterItem);
            float distance = diss.calculate(centroid, itemVector);
            medoidDistanceList.add(new DistanceElementPair(Float.valueOf(distance), clusterItem));
        }
        Collections.sort(medoidDistanceList, DistanceElementPair.PairComparator);
        Iterator it = medoidDistanceList.iterator();
        for (int medoidListSize = 0; it.hasNext() && medoidListSize < nrMedoids; ++medoidListSize) {
            int nextId = ((DistanceElementPair)it.next()).getElementId();
            medoidList.add(nextId);
        }
        return medoidList;
    }

    public static Clustering getClusteringTechnique(int clusteringType, String clusteringParams, AbstractDissimilarity diss, AbstractMatrix matrix) throws Exception {
        MultiscaleClustering.clusteringParams = clusteringParams;
        Clustering clustering = null;
        switch (clusteringType) {
            case 0: {
                clustering = new Kmeans(Integer.parseInt(clusteringParams));
                break;
            }
            case 1: {
                clustering = new BKmeans(Integer.parseInt(clusteringParams));
                break;
            }
            case 2: {
                clustering = new Kmedoids(Integer.parseInt(clusteringParams));
                break;
            }
            case 3: {
                String[] hParams = clusteringParams.split(";");
                int lNumClusters = Integer.parseInt(hParams[0]);
                if (hParams[1].equalsIgnoreCase("Single Link")) {
                    clustering = new HierarchicalClustering(lNumClusters, HierarchicalClustering.HierarchicalClusteringType.SLINK);
                    break;
                }
                if (hParams[1].equalsIgnoreCase("Complete Link")) {
                    clustering = new HierarchicalClustering(lNumClusters, HierarchicalClustering.HierarchicalClusteringType.CLINK);
                    break;
                }
                if (!hParams[1].equalsIgnoreCase("Average Link")) break;
                clustering = new HierarchicalClustering(lNumClusters, HierarchicalClustering.HierarchicalClusteringType.ALINK);
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                clustering = new Jdbscan2D();
                break;
            }
            case 7: {
                Group[] groups = new Group[2];
                int idx = 0;
                groups[idx] = new Group(idx);
                groups[idx].setMeanPoint(matrix.getRow(0));
                groups[++idx] = new Group(idx);
                groups[idx].setMeanPoint(matrix.getRow(1));
                ++idx;
                String[] isoParams = clusteringParams.split(";");
                int k = Integer.parseInt(isoParams[0]);
                int minNumThres = Integer.parseInt(isoParams[1]);
                float stdDeviationThres = Float.parseFloat(isoParams[2]);
                float minDistanceThres = Float.parseFloat(isoParams[3]);
                int maxMergeNumsThres = Integer.parseInt(isoParams[4]);
                int maxIters = Integer.parseInt(isoParams[5]);
                clustering = new IsoData(groups, matrix, k, minNumThres, stdDeviationThres, minDistanceThres, maxMergeNumsThres, maxIters, diss);
            }
        }
        return clustering;
    }

    public static int testCluster(Cluster cluster, AbstractMatrix matrix) {
        int clusterErrorCode = 0;
        Stack<Cluster> clusterStack = new Stack<Cluster>();
        clusterStack.add(cluster);
        int totalClusterSize = 0;
        while (!clusterStack.isEmpty()) {
            Cluster currentCluster = (Cluster)clusterStack.pop();
            if (currentCluster.getSubClusterList() != null && !currentCluster.getSubClusterList().isEmpty() && !currentCluster.getItemList().isEmpty()) {
                clusterErrorCode = 1;
                MultiscaleClustering.printErr(String.format("[Cluster %d] ItemList should by empty!\n", currentCluster.getId()));
            }
            for (Cluster subCluster : currentCluster.getSubClusterList()) {
                clusterStack.push(subCluster);
            }
            for (Integer item : currentCluster.getItemList()) {
                if (item < matrix.getRowCount()) continue;
                clusterErrorCode |= 2;
                MultiscaleClustering.printErr(String.format("[Cluster %d] Item %d doesn't fit matrix rows index!\n", currentCluster.getId(), item));
            }
            for (Integer medoid : currentCluster.getMedoidList()) {
                if (currentCluster.getSubClusterList().isEmpty()) {
                    if (currentCluster.getItemList().indexOf(medoid) == -1) {
                        clusterErrorCode |= 4;
                        MultiscaleClustering.printErr(String.format("[Cluster %d] Medoid %d isn't in cluster ItemList!\n", currentCluster.getId(), medoid));
                    }
                } else {
                    boolean temErro = true;
                    for (Cluster subCluster : currentCluster.getSubClusterList()) {
                        try {
                            if (subCluster.getMedoidList().indexOf(medoid) == -1) continue;
                            temErro = false;
                            break;
                        }
                        catch (IndexOutOfBoundsException ex) {
                            MultiscaleClustering.printErr(String.format("[Cluster %d] Error getting subClusters medoidList!\n", subCluster.getId()));
                            MultiscaleClustering.printErr(ex.getMessage());
                            temErro = true;
                        }
                    }
                    if (temErro) {
                        clusterErrorCode |= 4;
                        MultiscaleClustering.printErr(String.format("[Cluster %d] Medoid %d isn't in subClusters MedoidList!\n", currentCluster.getId(), medoid));
                    }
                }
                if (medoid < matrix.getRowCount()) continue;
                clusterErrorCode |= 2;
            }
            totalClusterSize += currentCluster.getItemList().size();
        }
        if (totalClusterSize != cluster.getSize()) {
            clusterErrorCode |= 1;
            MultiscaleClustering.printErr(String.format("[Cluster %d]: The size of the cluster (%d) doesn't match (%d)", cluster.getId(), cluster.getSize(), totalClusterSize));
        }
        return clusterErrorCode;
    }

    public static void main(String[] args) throws IOException, Exception {
        AbstractMatrix matrix = MatrixFactory.getInstance("D:\\corel1000.data");
        AbstractDissimilarity diss = DissimilarityFactory.getInstance(DissimilarityFactory.DissimilarityType.EUCLIDEAN);
        MultiscaleClustering clus = new MultiscaleClustering();
        clus.levelFraction = 0.01f;
        Clustering technique = MultiscaleClustering.getClusteringTechnique(0, "40", diss, matrix);
        List<Cluster> clusterList = clus.clusterize(matrix, technique, diss, 80, false, 10);
        System.out.println("FIM");
    }

    static {
        verbose = true;
    }
}

