/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.dimreduction;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import simpletree.datamining.dimreduction.DimensionalityReductionComp;
import simpletree.datamining.dimreduction.DimensionalityReductionFactory;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import vispipelinebasics.interfaces.AbstractParametersView;

public class DimensionalityReductionParamView
extends AbstractParametersView {
    private DimensionalityReductionComp comp;
    private JLabel dimensionsLabel;
    private JPanel dimensionsPanel;
    private JTextField dimensionsTextField;
    private JComboBox dissimilarityComboBox;
    private JPanel dissimilarityPanel;
    private JComboBox reductionComboBox;
    private JPanel reductionPanel;

    public DimensionalityReductionParamView(DimensionalityReductionComp comp) {
        this.initComponents();
        this.comp = comp;
        for (DissimilarityFactory.DissimilarityType dissimilarityType : DissimilarityFactory.DissimilarityType.values()) {
            this.dissimilarityComboBox.addItem(dissimilarityType);
        }
        for (Enum enum_ : DimensionalityReductionFactory.DimensionalityReductionType.values()) {
            this.reductionComboBox.addItem(enum_);
        }
        this.reset();
    }

    private void initComponents() {
        this.dissimilarityPanel = new JPanel();
        this.dissimilarityComboBox = new JComboBox();
        this.dimensionsPanel = new JPanel();
        this.dimensionsLabel = new JLabel();
        this.dimensionsTextField = new JTextField();
        this.reductionPanel = new JPanel();
        this.reductionComboBox = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder("Dimensionality Reduction Parameters"));
        this.setLayout(new GridBagLayout());
        this.dissimilarityPanel.setBorder(BorderFactory.createTitledBorder("Dissimilarity"));
        this.dissimilarityPanel.setLayout(new BorderLayout());
        this.dissimilarityPanel.add((Component)this.dissimilarityComboBox, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add(this.dissimilarityPanel, gridBagConstraints);
        this.dimensionsPanel.setBorder(BorderFactory.createTitledBorder("Dimensions"));
        this.dimensionsPanel.setLayout(new GridBagLayout());
        this.dimensionsLabel.setText("Number of dimensions");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dimensionsPanel.add((Component)this.dimensionsLabel, gridBagConstraints);
        this.dimensionsTextField.setColumns(5);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.dimensionsPanel.add((Component)this.dimensionsTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.add(this.dimensionsPanel, gridBagConstraints);
        this.reductionPanel.setBorder(BorderFactory.createTitledBorder("Reduction Technique"));
        this.reductionPanel.setLayout(new BorderLayout());
        this.reductionPanel.add((Component)this.reductionComboBox, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add(this.reductionPanel, gridBagConstraints);
    }

    public void reset() {
        this.dissimilarityComboBox.setSelectedItem((Object)this.comp.getDissimilarityType());
        this.reductionComboBox.setSelectedItem((Object)this.comp.getDimensionalityReductionType());
    }

    public void finished() throws IOException {
        int nrdim;
        if (this.dimensionsTextField.getText().trim().length() > 0) {
            nrdim = Integer.parseInt(this.dimensionsTextField.getText());
            if (nrdim <= 0) {
                throw new IOException("The target dimensionality should be positive.");
            }
        } else {
            throw new IOException("The target dimensionality should be provided.");
        }
        this.comp.setNumberDimensions(nrdim);
        this.comp.setDimensionalityReductionType((DimensionalityReductionFactory.DimensionalityReductionType)((Object)this.reductionComboBox.getSelectedItem()));
        this.comp.setDissimilarityType((DissimilarityFactory.DissimilarityType)((Object)this.dissimilarityComboBox.getSelectedItem()));
    }
}

