/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.normalization;

import java.io.IOException;
import simpletree.datamining.normalization.AbstractNormalization;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.sparse.SparseMatrix;
import simpletree.matrix.sparse.SparseVector;

public class NormalizeColumns
extends AbstractNormalization {
    @Override
    public AbstractMatrix execute(AbstractMatrix matrix) throws IOException {
        assert (matrix.getRowCount() > 0) : "More than zero vectors must be used!";
        Object points = null;
        if (matrix instanceof DenseMatrix) {
            points = new float[matrix.getRowCount()][];
            for (int i = 0; i < ((float[][])points).length; ++i) {
                points[i] = matrix.getRow(i).getValues();
                matrix.getRow(i).shouldUpdateNorm();
            }
        } else {
            points = matrix.toMatrix();
        }
        for (int j = 0; j < matrix.getDimensions(); ++j) {
            int i;
            float max = Float.NEGATIVE_INFINITY;
            float min = Float.POSITIVE_INFINITY;
            for (i = 0; i < matrix.getRowCount(); ++i) {
                if (max < points[i][j]) {
                    max = points[i][j];
                }
                if (!(min > points[i][j])) continue;
                min = points[i][j];
            }
            for (i = 0; i < matrix.getRowCount(); ++i) {
                points[i][j] = max > min ? (points[i][j] - min) / (max - min) : 0.0f;
            }
        }
        if (matrix instanceof SparseMatrix) {
            SparseMatrix colmatrix = new SparseMatrix();
            colmatrix.setAttributes(matrix.getAttributes());
            for (int i = 0; i < matrix.getRowCount(); ++i) {
                AbstractVector oldv = matrix.getRow(i);
                ((AbstractMatrix)colmatrix).addRow(new SparseVector(points[i], oldv.getId(), oldv.getKlass()));
            }
            return colmatrix;
        }
        return matrix;
    }
}

