/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.normalization;

import java.io.IOException;
import java.util.Arrays;
import simpletree.datamining.normalization.AbstractNormalization;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;
import simpletree.matrix.sparse.SparseMatrix;

public class Standardization
extends AbstractNormalization {
    private static final float EPSILON = 1.0E-7f;

    @Override
    public AbstractMatrix execute(AbstractMatrix matrix) throws IOException {
        int j;
        int i;
        int j2;
        int i2;
        assert (matrix.getRowCount() > 0) : "More than zero vectors must be used!";
        Object points = null;
        if (matrix instanceof DenseMatrix) {
            points = new float[matrix.getRowCount()][];
            for (int i3 = 0; i3 < ((float[][])points).length; ++i3) {
                points[i3] = matrix.getRow(i3).getValues();
                matrix.getRow(i3).shouldUpdateNorm();
            }
        } else {
            points = matrix.toMatrix();
        }
        double[] mean = new double[points[0].length];
        Arrays.fill(mean, 0.0);
        for (i2 = 0; i2 < ((float[][])points).length; ++i2) {
            for (j2 = 0; j2 < points[i2].length; ++j2) {
                int n = j2;
                mean[n] = mean[n] + (double)points[i2][j2];
            }
        }
        i2 = 0;
        while (i2 < mean.length) {
            int n = i2++;
            mean[n] = mean[n] / (double)((float[][])points).length;
        }
        for (i2 = 0; i2 < ((float[][])points).length; ++i2) {
            for (j2 = 0; j2 < points[i2].length; ++j2) {
                float[] fArray = points[i2];
                int n = j2;
                fArray[n] = (float)((double)fArray[n] - mean[j2]);
            }
        }
        double[] deviation = new double[points[0].length];
        Arrays.fill(deviation, 0.0);
        for (i = 0; i < ((float[][])points).length; ++i) {
            for (j = 0; j < points[i].length; ++j) {
                int n = j;
                deviation[n] = deviation[n] + (double)points[i][j] * (double)points[i][j];
            }
        }
        for (i = 0; i < mean.length; ++i) {
            deviation[i] = Math.sqrt(deviation[i] / (double)(((float[][])points).length - 1));
            if (!(deviation[i] < (double)1.0E-7f)) continue;
            deviation[i] = 1.0E-7f;
        }
        for (i = 0; i < ((float[][])points).length; ++i) {
            for (j = 0; j < points[i].length; ++j) {
                if (deviation[j] == 0.0) continue;
                float[] fArray = points[i];
                int n = j;
                fArray[n] = (float)((double)fArray[n] / deviation[j]);
            }
        }
        if (matrix instanceof SparseMatrix) {
            DenseMatrix stdmatrix = new DenseMatrix();
            stdmatrix.setAttributes(matrix.getAttributes());
            for (int i4 = 0; i4 < matrix.getRowCount(); ++i4) {
                AbstractVector oldv = matrix.getRow(i4);
                ((AbstractMatrix)stdmatrix).addRow(new DenseVector(points[i4], oldv.getId(), oldv.getKlass()));
            }
            return stdmatrix;
        }
        return matrix;
    }
}

