/*
 * Decompiled with CFR 0.152.
 */
package simpletree.datamining.weighing;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import simpletree.datamining.weighing.AttributeWeighingComp;
import vispipelinebasics.interfaces.AbstractParametersView;

public class AttributeWeighingParamView
extends AbstractParametersView {
    private AttributeWeighingComp comp;
    private DefaultTableModel attributeModel;
    private JTable features_jTable;
    private JScrollPane selectedFeaturesjScrollPane;

    public AttributeWeighingParamView(AttributeWeighingComp comp) {
        this.initComponents();
        this.attributeModel = (DefaultTableModel)this.features_jTable.getModel();
        this.comp = comp;
        this.reset();
    }

    private void initComponents() {
        this.selectedFeaturesjScrollPane = new JScrollPane();
        this.features_jTable = new JTable();
        this.setBorder(BorderFactory.createTitledBorder("Attribute Weighing Parameters"));
        this.setLayout(new GridBagLayout());
        this.selectedFeaturesjScrollPane.setBorder(BorderFactory.createTitledBorder("Selected Features"));
        this.selectedFeaturesjScrollPane.setPreferredSize(new Dimension(250, 200));
        this.features_jTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Attribute", "Weight"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.features_jTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                AttributeWeighingParamView.this.features_jTableMouseClicked(evt);
            }
        });
        this.selectedFeaturesjScrollPane.setViewportView(this.features_jTable);
        this.add(this.selectedFeaturesjScrollPane, new GridBagConstraints());
    }

    private void features_jTableMouseClicked(MouseEvent evt) {
    }

    public void reset() {
        while (this.attributeModel.getRowCount() > 0) {
            this.attributeModel.removeRow(this.attributeModel.getRowCount() - 1);
        }
        for (int i = 0; i < this.comp.getInput().getDimensions(); ++i) {
            Object[] row = new String[]{i + " - " + this.comp.getInput().getAttributes().get(i), "1.0"};
            this.attributeModel.addRow(row);
        }
    }

    public void finished() throws IOException {
        ArrayList<Float> weights = new ArrayList<Float>();
        for (int i = 0; i < this.comp.getInput().getAttributes().size(); ++i) {
            weights.add(Float.valueOf(Float.parseFloat((String)this.attributeModel.getValueAt(i, 1))));
        }
        this.comp.setWeights(weights);
    }

    public DefaultTableModel getAttributeModel() {
        return this.attributeModel;
    }
}

