/*
 * Decompiled with CFR 0.152.
 */
package simpletree.detailedMatrix;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.detailedMatrix.dense.DetailedDenseMatrix;
import simpletree.detailedMatrix.sparse.DetailedSparseMatrix;
import simpletree.matrix.AbstractMatrix;
import simpletree.matrix.MatrixFactory;
import simpletree.matrix.reader.BinaryMatrixReader;

public class DetailedMatrixFactory
extends MatrixFactory {
    public static AbstractMatrix getInstance(String filename) throws IOException {
        AbstractMatrix matrix = null;
        if (filename.endsWith("data")) {
            BufferedReader in = new BufferedReader(new FileReader(filename));
            char[] header = in.readLine().trim().toCharArray();
            if (header.length != 2 && header.length != 3) {
                throw new IOException("Wrong format of header information.");
            }
            in.close();
            if (header[0] == 'D') {
                matrix = new DetailedDenseMatrix();
            } else if (header[0] == 'S') {
                matrix = new DetailedSparseMatrix();
            } else {
                throw new IOException("Unknow file format!");
            }
            ((AbstractMatrix)matrix).load(filename);
            Logger.getLogger(DetailedMatrixFactory.class.getName()).log(Level.INFO, "#Processing the points file: {0}", filename);
        } else if (filename.endsWith("bin")) {
            BinaryMatrixReader bmr = new BinaryMatrixReader();
            matrix = bmr.read(filename);
        }
        return matrix;
    }
}

