/*
 * Decompiled with CFR 0.152.
 */
package simpletree.detailedMatrix.dense;

import java.io.IOException;
import simpletree.detailedMatrix.DetailedMatrix;
import simpletree.matrix.AbstractVector;
import simpletree.matrix.dense.DenseMatrix;
import simpletree.matrix.dense.DenseVector;

public class DetailedDenseMatrix
extends DenseMatrix
implements DetailedMatrix {
    private String source = "";
    private String name = "";

    @Override
    public void load(String filename) throws IOException {
        super.load(filename);
        this.source = filename;
        int begin = this.source.lastIndexOf("\\");
        int end = this.source.lastIndexOf(".");
        if (begin == -1) {
            begin = 0;
        } else if (begin + 1 <= end) {
            ++begin;
        }
        if (end == -1) {
            end = this.source.length();
        }
        this.name = this.source.substring(begin, end);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        DetailedDenseMatrix clone = new DetailedDenseMatrix();
        clone.dimensions = this.dimensions;
        for (String lab : this.labels) {
            clone.labels.add(lab);
        }
        for (String attr : this.attributes) {
            clone.attributes.add(attr);
        }
        for (AbstractVector v : this.rows) {
            clone.rows.add((DenseVector)v.clone());
        }
        clone.source = this.source;
        clone.name = this.name;
        return clone;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

