/*
 * Decompiled with CFR 0.152.
 */
package simpletree.disk;

import java.io.IOException;
import simpletree.basics.SimpleTree;
import simpletree.disk.BinaryReaderParamView;
import simpletree.io.file.SupertreeFile;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Simple Tree.Disk", name="Binary SuperTree Reader", description="Read a Super Tree from a binary file in the disk.")
public class BinaryReaderComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private String filename;
    private int minNodeSize = 2;
    private int levelsToExpand = 1;
    private transient BinaryReaderParamView paramview;
    private transient SimpleTree stree;
    private transient SupertreeFile stFile;

    public void execute() throws IOException {
        if (this.filename == null || this.filename.isEmpty()) {
            System.out.println("SuperTree file can't be empty. Choose a .stree file");
            return;
        }
        this.stFile = new SupertreeFile(this.filename);
    }

    public SupertreeFile output() {
        return this.stFile;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new BinaryReaderParamView(this);
        }
        return this.paramview;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void reset() {
        this.stFile = null;
        this.stree = null;
    }
}

