/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import simpletree.distance.DistanceMatrixWriterComp;
import simpletree.util.PropertiesManager;
import simpletree.util.SaveDialog;
import simpletree.util.filter.DMATFilter;
import vispipelinebasics.interfaces.AbstractParametersView;

public class DistanceMatrixWriterParamView
extends AbstractParametersView {
    private DistanceMatrixWriterComp comp;
    private JButton distmatrixButton;
    private JLabel distmatrixLabel;
    private JTextField distmatrixTextField;

    public DistanceMatrixWriterParamView(DistanceMatrixWriterComp comp) {
        this.initComponents();
        this.comp = comp;
        this.reset();
    }

    private void initComponents() {
        this.distmatrixButton = new JButton();
        this.distmatrixTextField = new JTextField();
        this.distmatrixLabel = new JLabel();
        this.setBorder(BorderFactory.createTitledBorder("Distance Matrix Writer"));
        this.setLayout(new GridBagLayout());
        this.distmatrixButton.setText("Search...");
        this.distmatrixButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DistanceMatrixWriterParamView.this.distmatrixButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.distmatrixButton, gridBagConstraints);
        this.distmatrixTextField.setColumns(35);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.distmatrixTextField, gridBagConstraints);
        this.distmatrixLabel.setText("File name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.add(this.distmatrixLabel, gridBagConstraints);
    }

    private void distmatrixButtonActionPerformed(ActionEvent evt) {
        try {
            PropertiesManager spm = PropertiesManager.getInstance("basics.properties");
            int result = SaveDialog.showSaveDialog(spm, new DMATFilter(), (Component)((Object)this), "distancematrix.dmat");
            if (result == 0) {
                String filename = SaveDialog.getFilename();
                this.distmatrixTextField.setText(filename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(DistanceMatrixWriterParamView.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void reset() {
        this.distmatrixTextField.setText(this.comp.getFilename());
    }

    public void finished() throws IOException {
        if (this.distmatrixTextField.getText().trim().length() <= 0) {
            throw new IOException("A distance matrix file name must be provided.");
        }
        this.comp.setFilename(this.distmatrixTextField.getText());
    }
}

