/*
 * Decompiled with CFR 0.152.
 */
package simpletree.distance.converter;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import simpletree.distance.DetailedDistanceMatrix;
import simpletree.distance.DistanceMatrix;
import simpletree.distance.converter.DistanceMatrixCalculatorParamView;
import simpletree.distance.dissimilarity.AbstractDissimilarity;
import simpletree.distance.dissimilarity.DissimilarityFactory;
import simpletree.matrix.AbstractMatrix;
import vispipelinebasics.annotations.Param;
import vispipelinebasics.annotations.VisComponent;
import vispipelinebasics.interfaces.AbstractComponent;
import vispipelinebasics.interfaces.AbstractParametersView;

@VisComponent(hierarchy="Distance.Calculator", name="Distance Matrix calculator", description="Calculate a distance matrix based on a Points Matrix and a similarity measure.")
public class DistanceMatrixCalculatorComp
implements AbstractComponent {
    public static final long serialVersionUID = 1L;
    private transient DistanceMatrixCalculatorParamView paramview;
    private transient AbstractMatrix matrix;
    private transient DistanceMatrix dmat;
    private DissimilarityFactory.DissimilarityType disstype = DissimilarityFactory.DissimilarityType.EUCLIDEAN;
    private boolean saveDmat = true;
    private boolean normalize = true;
    private String dmatFilename = "";
    private String title = "";

    public void execute() {
        try {
            AbstractDissimilarity diss = DissimilarityFactory.getInstance(this.disstype);
            if (this.title == null || this.title.isEmpty()) {
                this.dmat = new DistanceMatrix(this.matrix, diss);
            } else {
                this.dmat = new DetailedDistanceMatrix(this.matrix, diss);
                ((DetailedDistanceMatrix)this.dmat).setName(this.title);
            }
            if (this.normalize) {
                DistanceMatrix normDmat = new DistanceMatrix(this.dmat.getElementCount());
                for (int i = 0; i < this.dmat.getElementCount(); ++i) {
                    for (int j = i + 1; j < this.dmat.getElementCount(); ++j) {
                        normDmat.setDistance(i, j, this.dmat.getDistance(i, j) / this.dmat.getMaxDistance());
                    }
                }
                normDmat.setLabels(this.dmat.getLabels());
                normDmat.setClassData(this.dmat.getClassData());
                normDmat.setIds(this.dmat.getIds());
                this.dmat = normDmat;
            }
            if (this.saveDmat) {
                this.dmat.save(this.dmatFilename);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(DistanceMatrixCalculatorComp.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void input(@Param(name="points matrix") AbstractMatrix matrix) {
        this.matrix = matrix;
    }

    public DistanceMatrix output() {
        return this.dmat;
    }

    public AbstractParametersView getParametersEditor() {
        if (this.paramview == null) {
            this.paramview = new DistanceMatrixCalculatorParamView(this);
        }
        return this.paramview;
    }

    public void reset() {
        this.matrix = null;
        this.dmat = null;
    }

    public String getDmatFilename() {
        return this.dmatFilename;
    }

    public void setDmatFilename(String dmatFilename) {
        this.dmatFilename = dmatFilename;
    }

    public DissimilarityFactory.DissimilarityType getDissimilarityType() {
        return this.disstype;
    }

    public void setDissimilarityType(DissimilarityFactory.DissimilarityType diss) {
        this.disstype = diss;
    }

    public void setSaveDmat(boolean selected) {
        this.saveDmat = selected;
    }

    public boolean getSaveDmat() {
        return this.saveDmat;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String t) {
        this.title = t;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public boolean isNormalize() {
        return this.normalize;
    }
}

